/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.dltk.dbgp.DbgpServerException;
import org.eclipse.dltk.dbgp.IDbgpServer;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.dbgp.internal.DbgpDebugingEngine;
import org.eclipse.dltk.dbgp.internal.DbgpSession;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;

public class DbgpServer
extends DbgpWorkingThread
implements IDbgpServer {
    private final int clientTimeout;
    private final int serverTimeout;
    private final Map acceptors;
    private ServerSocket server;

    protected void acceptNotAvailable() {
        Iterator it = this.acceptors.values().iterator();
        while (it.hasNext()) {
            ((IDbgpThreadAcceptor)it.next()).acceptDbgpThreadNotUnavailable();
        }
    }

    protected void checkServerClosed() throws DbgpServerException {
        if (this.server.isClosed()) {
            throw new DbgpServerException("Server socket is already closed.");
        }
    }

    protected void workingCycle() throws Exception, IOException {
        try {
            while (true) {
                Socket client = this.server.accept();
                client.setSoTimeout(this.clientTimeout);
                DbgpDebugingEngine dbgpDebugingEngine = new DbgpDebugingEngine(client);
                DbgpSession session = new DbgpSession(dbgpDebugingEngine);
                String id = session.getInfo().getIdeKey();
                IDbgpThreadAcceptor acceptor = (IDbgpThreadAcceptor)this.acceptors.get(id);
                if (acceptor != null) {
                    acceptor.acceptDbgpThread(session);
                    continue;
                }
                session.requestTermination();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.server.close();
            this.acceptNotAvailable();
            throw throwable;
        }
    }

    protected void tryStart(int port) throws IOException {
        this.server = new ServerSocket(port);
        this.server.setSoTimeout(this.serverTimeout);
        super.start();
    }

    public int getClientTimeout() {
        return this.clientTimeout;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public DbgpServer(int clientTimeout, int serverTimeout) {
        super("DBGP - Server");
        this.clientTimeout = clientTimeout;
        this.serverTimeout = serverTimeout;
        this.acceptors = Collections.synchronizedMap(new HashMap());
    }

    public void start(int port) throws DbgpServerException {
        try {
            this.tryStart(port);
        }
        catch (IOException e) {
            throw new DbgpServerException(e);
        }
    }

    public void start(int startPort, int endPort) throws DbgpServerException {
        if (startPort > endPort) {
            throw new IllegalArgumentException("startPort should be less or equal than endPort");
        }
        int port = startPort;
        while (port <= endPort) {
            try {
                this.tryStart(port);
                return;
            }
            catch (IOException iOException) {
                ++port;
            }
        }
        throw new DbgpServerException("Can't find available port in rage " + startPort + " ... " + endPort);
    }

    public void stop() throws DbgpServerException {
        try {
            this.server.close();
        }
        catch (IOException e) {
            throw new DbgpServerException(e);
        }
    }

    public int getPort() throws DbgpServerException {
        this.checkServerClosed();
        return this.server.getLocalPort();
    }

    public void registerAcceptor(String id, IDbgpThreadAcceptor acceptor) throws DbgpServerException {
        this.checkServerClosed();
        this.acceptors.put(id, acceptor);
    }

    public IDbgpThreadAcceptor unregisterAcceptor(String id) {
        return (IDbgpThreadAcceptor)this.acceptors.remove(id);
    }
}

