/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.index;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.util.HashtableOfObject;
import org.eclipse.dltk.compiler.util.SimpleSetOfCharArray;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.util.Util;

public class MixinIndex
extends Index {
    private static final String HEADER = "MIXIN INDEX 0.1";
    private HashtableOfObject docNamesToKeys;
    private final String fileName;
    private boolean dirty;

    public MixinIndex(String fileName, String containerPath, boolean reuseFile) throws IOException {
        super(fileName, containerPath);
        this.fileName = fileName;
        this.dirty = false;
        if (reuseFile) {
            this.initialize(reuseFile);
        } else {
            this.save();
        }
    }

    public void addIndexEntry(char[] category, char[] key, String containerRelativePath) {
        this.dirty = true;
        if (DLTKCore.DEBUG_INDEX) {
            System.out.println("DEBUG INDEX: Add Index Entry:" + new String(category) + " " + new String(key) + " path:" + containerRelativePath);
        }
        Assert.isTrue((boolean)CharOperation.equals(category, IIndexConstants.MIXIN));
        this.addIndexEntry(key, containerRelativePath.toCharArray());
    }

    private void addIndexEntry(char[] key, char[] containerRelativePath) {
        SimpleSetOfCharArray names = (SimpleSetOfCharArray)this.docNamesToKeys.get(containerRelativePath);
        if (names == null) {
            names = new SimpleSetOfCharArray(1);
            this.docNamesToKeys.put(containerRelativePath, names);
        }
        names.add(key);
    }

    public String containerRelativePath(String documentPath) {
        int index = documentPath.indexOf("|");
        if (index == -1) {
            index = this.containerPath.length();
            if (documentPath.length() <= index) {
                throw new IllegalArgumentException("Document path " + documentPath + " must be relative to " + this.containerPath);
            }
        }
        return documentPath.substring(index + 1);
    }

    public File getIndexFile() {
        return new File(this.fileName);
    }

    public boolean hasChanged() {
        return this.dirty;
    }

    public EntryResult[] query(char[][] categories, char[] key, int matchRule) throws IOException {
        boolean found = false;
        int i = 0;
        while (i < categories.length) {
            if (CharOperation.equals(categories[i], IIndexConstants.MIXIN)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            return new EntryResult[0];
        }
        HashtableOfObject results = new HashtableOfObject(10);
        this.performQuery(key, matchRule, results);
        EntryResult[] entryResults = new EntryResult[results.elementSize];
        int count = 0;
        Object[] values = results.valueTable;
        int i2 = 0;
        int l = values.length;
        while (i2 < l) {
            EntryResult result = (EntryResult)values[i2];
            if (result != null) {
                entryResults[count++] = result;
            }
            ++i2;
        }
        return entryResults;
    }

    private void performQuery(char[] key, int matchRule, HashtableOfObject results) {
        char[][] keyTable = this.docNamesToKeys.keyTable;
        int i = 0;
        while (i < keyTable.length) {
            SimpleSetOfCharArray keys;
            char[] docName = keyTable[i];
            if (docName != null && (keys = (SimpleSetOfCharArray)this.docNamesToKeys.get(docName)) != null) {
                int j = 0;
                while (j < keys.values.length) {
                    char[] k = keys.values[j];
                    if (k != null && Index.isMatch(key, k, matchRule)) {
                        EntryResult s = (EntryResult)results.get(k);
                        if (s == null) {
                            s = new EntryResult(k, null);
                            results.put(k, s);
                        }
                        s.addDocumentName(new String(docName));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private String[] extractKeysFromTable(HashtableOfObject table) {
        String[] documentNames = new String[table.elementSize];
        int count = 0;
        char[][] values = table.keyTable;
        int i = 0;
        int l = values.length;
        while (i < l) {
            char[] result = values[i];
            if (result != null) {
                documentNames[count++] = new String(result);
            }
            ++i;
        }
        return documentNames;
    }

    public String[] queryDocumentNames(String substring) throws IOException {
        if (substring == null) {
            return this.extractKeysFromTable(this.docNamesToKeys);
        }
        HashtableOfObject results = new HashtableOfObject(10);
        this.performQuery(substring.toCharArray(), 2, results);
        return this.extractKeysFromTable(results);
    }

    public void remove(String containerRelativePath) {
        this.dirty = true;
        this.docNamesToKeys.removeKey(containerRelativePath.toCharArray());
    }

    public void save() throws IOException {
        long t = System.currentTimeMillis();
        if (this.docNamesToKeys == null) {
            this.docNamesToKeys = new HashtableOfObject(0);
        }
        File f = this.getIndexFile();
        DataOutputStream stream = new DataOutputStream(new FileOutputStream(f));
        int docNamesCount = this.docNamesToKeys.elementSize;
        Util.writeUTF(stream, HEADER.toCharArray());
        stream.writeInt(docNamesCount);
        int i = 0;
        while (i < this.docNamesToKeys.keyTable.length) {
            char[] docName = this.docNamesToKeys.keyTable[i];
            if (docName != null) {
                Util.writeUTF(stream, docName);
                SimpleSetOfCharArray wordSet = (SimpleSetOfCharArray)this.docNamesToKeys.get(docName);
                if (wordSet != null) {
                    stream.writeInt(wordSet.elementSize);
                    int j = 0;
                    while (j < wordSet.values.length) {
                        char[] word = wordSet.values[j];
                        if (word != null) {
                            Util.writeUTF(stream, word);
                        }
                        ++j;
                    }
                } else {
                    stream.writeInt(0);
                }
            }
            ++i;
        }
        stream.close();
        this.dirty = false;
        if (DLTKCore.DEBUG_INDEX) {
            System.out.println("Mixin index for " + this.containerPath + " (" + new Path(this.fileName).lastSegment() + ") saved, took " + (System.currentTimeMillis() - t));
            System.out.println("Mixin modules: " + this.docNamesToKeys.size());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize(boolean reuseExistingFile) throws IOException {
        File indexFile;
        block18: {
            block17: {
                boolean successful = false;
                indexFile = this.getIndexFile();
                if (!indexFile.exists()) break block18;
                if (!reuseExistingFile) break block17;
                this.docNamesToKeys = new HashtableOfObject(0);
                try {
                    try {
                        this.monitor.enterRead();
                        DataInputStream stream = new DataInputStream(new FileInputStream(indexFile));
                        char[] header = Util.readUTF(stream);
                        if (new String(header).equals(HEADER)) {
                            int documentsCount = stream.readInt();
                            int i = 0;
                            block6: while (true) {
                                if (i >= documentsCount) {
                                    successful = true;
                                    break;
                                }
                                char[] docName = Util.readUTF(stream);
                                int wordsCount = stream.readInt();
                                int j = 0;
                                while (true) {
                                    if (j >= wordsCount) {
                                        ++i;
                                        continue block6;
                                    }
                                    char[] word = Util.readUTF(stream);
                                    this.addIndexEntry(word, docName);
                                    ++j;
                                }
                                break;
                            }
                        }
                        stream.close();
                    }
                    catch (FileNotFoundException e) {
                        if (DLTKCore.DEBUG_INDEX) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        if (DLTKCore.DEBUG_INDEX) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    this.monitor.exitRead();
                    throw throwable;
                }
                {
                    Object var12_16 = null;
                    this.monitor.exitRead();
                    if (!successful) break block17;
                    return;
                }
            }
            if (!indexFile.delete()) {
                if (DLTKCore.DEBUG_INDEX) {
                    System.out.println("initialize - Failed to delete mixin index " + this.fileName);
                }
                throw new IOException("Failed to delete mixin index " + this.fileName);
            }
        }
        if (indexFile.createNewFile()) {
            this.docNamesToKeys = new HashtableOfObject();
            this.save();
            this.dirty = false;
            return;
        }
        if (DLTKCore.DEBUG_INDEX) {
            System.out.println("initialize - Failed to create new index " + this.fileName);
        }
        throw new IOException("Failed to create new index " + this.fileName);
    }

    public void startQuery() {
    }

    public void stopQuery() {
    }

    public String toString() {
        return "Mixin Index for " + this.containerPath;
    }
}

