/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference.evaluators;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ruby.ast.RubyIfStatement;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class IfStatementTypeEvaluator
extends GoalEvaluator {
    private static final int STATE_TRY_THEN = 0;
    private static final int STATE_WAITING_THEN = 1;
    private static final int STATE_TRY_ELSE = 2;
    private static final int STATE_WAITING_ELSE = 3;
    private static final int STATE_DONE = -2;
    private int state = 0;
    private IEvaluatedType[] evaluatedTypes = new IEvaluatedType[2];
    private int index = 0;

    public IfStatementTypeEvaluator(ExpressionTypeGoal goal) {
        super((IGoal)goal);
    }

    private IGoal produceNextSubgoal(IGoal previousGoal, Object previousResult) {
        ASTNode clause;
        RubyIfStatement expression;
        ExpressionTypeGoal typedGoal;
        if (this.state == 0) {
            typedGoal = (ExpressionTypeGoal)this.goal;
            expression = (RubyIfStatement)typedGoal.getExpression();
            clause = expression.getThen();
            if (clause == null) {
                this.state = 2;
            } else {
                this.state = 1;
                return new ExpressionTypeGoal(this.goal.getContext(), clause);
            }
        }
        if (this.state == 1 || this.state == 3) {
            if (previousResult != null) {
                this.evaluatedTypes[this.index++] = (IEvaluatedType)previousResult;
            }
            this.state = this.state == 1 ? 2 : -2;
        } else {
            Assert.isTrue((previousGoal == null ? 1 : 0) != 0);
        }
        if (this.state == 2) {
            typedGoal = (ExpressionTypeGoal)this.goal;
            expression = (RubyIfStatement)typedGoal.getExpression();
            clause = expression.getElse();
            if (clause == null) {
                this.state = -2;
            } else {
                this.state = 3;
                return new ExpressionTypeGoal(this.goal.getContext(), clause);
            }
        }
        return null;
    }

    public Object produceResult() {
        return RubyTypeInferencingUtils.combineTypes(this.evaluatedTypes);
    }

    public IGoal[] init() {
        IGoal goal = this.produceNextSubgoal(null, null);
        if (goal != null) {
            return new IGoal[]{goal};
        }
        return IGoal.NO_GOALS;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        IGoal goal = this.produceNextSubgoal(subgoal, result);
        if (goal != null) {
            return new IGoal[]{goal};
        }
        return IGoal.NO_GOALS;
    }
}

