/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.builder.ScriptBuilderManager;
import org.eclipse.dltk.internal.core.builder.State;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class ScriptBuilder
extends IncrementalProjectBuilder {
    public static final boolean DEBUG = DLTKCore.DEBUG_SCRIPT_BUILDER;
    public IProject currentProject = null;
    ScriptProject scriptProject = null;
    State lastState;
    private HandleFactory factory = new HandleFactory();

    public static void buildStarting() {
    }

    public static void buildFinished() {
        if (DLTKCore.DEBUG) {
            System.out.println("build finished");
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (!DLTKLanguageManager.hasScriptNature(this.currentProject)) {
            return null;
        }
        this.scriptProject = (ScriptProject)DLTKCore.create(this.currentProject);
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return new IProject[0];
        }
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            this.lastState = this.getLastState(this.currentProject, monitor);
            if (this.lastState == null) {
                if (DEBUG) {
                    System.out.println("Performing full build since last saved state was not found");
                }
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        IProject[] requiredProjects = this.getRequiredProjects(true);
        if (DEBUG) {
            System.out.println("Finished build of " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        return requiredProjects;
    }

    private IProject[] getRequiredProjects(boolean includeBinaryPrerequisites) {
        if (this.scriptProject == null) {
            return new IProject[0];
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IBuildpathEntry[] entries = this.scriptProject.getExpandedBuildpath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IBuildpathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!((BuildpathEntry)entry).isOptional() || ScriptProject.hasScriptNature(p)) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    public State getLastState(IProject project, IProgressMonitor monitor) {
        return (State)ModelManager.getModelManager().getLastBuiltState(project, monitor);
    }

    private void clearLastState() {
        ModelManager.getModelManager().setLastBuiltState(this.currentProject, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        State newState;
        this.clearLastState();
        this.lastState = newState = new State(this);
        try {
            try {
                ArrayList resources = new ArrayList();
                this.currentProject.accept((IResourceVisitor)new ResourceVisitor(resources));
                ArrayList elements = new ArrayList();
                this.scriptProject.accept(new ExternalModuleVisitor(elements));
                int count = resources.size() + elements.size();
                monitor.beginTask("Indexing", count);
                this.buildResources(resources, monitor);
                this.buildElements(elements, monitor);
                monitor.done();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            throw throwable;
        }
        {
            Object var6_9 = null;
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        State newState = new State(this);
        if (this.lastState != null) {
            newState.copyFrom(this.lastState);
        }
        this.lastState = newState;
        try {
            ArrayList resources = new ArrayList();
            delta.accept((IResourceDeltaVisitor)new ResourceVisitor(resources));
            List actualResourcesToBuild = this.findDependencies(resources);
            ArrayList elements = new ArrayList();
            this.scriptProject.accept(new ExternalModuleVisitor(elements));
            monitor.beginTask("Indexing", actualResourcesToBuild.size() + elements.size());
            this.buildResources(actualResourcesToBuild, monitor);
            this.buildElements(elements, monitor);
            monitor.done();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            throw throwable;
        }
        {
            Object var7_9 = null;
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            return;
        }
    }

    protected void buildResources(List resources, IProgressMonitor monitor) {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        IDLTKSearchScope scope = SearchEngine.createSearchScope(new IModelElement[]{this.scriptProject});
        ArrayList<IResource> realResources = new ArrayList<IResource>();
        ArrayList<Openable> elements = new ArrayList<Openable>();
        int i = 0;
        while (i < resources.size()) {
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            IResource res = (IResource)resources.get(i);
            Openable element = this.factory.createOpenable(res.getFullPath().toString(), scope);
            if (element != null && element.getElementType() == 5 && element.exists()) {
                elements.add(element);
            } else {
                realResources.add(res);
            }
            ++i;
        }
        this.buildElements(elements, monitor);
        String[] natureIds = null;
        try {
            natureIds = this.currentProject.getDescription().getNatureIds();
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return;
        }
        int j = 0;
        while (j < natureIds.length) {
            block15: {
                try {
                    IScriptBuilder[] builders = ScriptBuilderManager.getScriptBuilders(natureIds[j]);
                    if (builders != null) {
                        int k = 0;
                        while (k < builders.length) {
                            IStatus[] st = builders[k].buildResources(this.scriptProject, realResources, monitor);
                            if (st != null) {
                                int i2 = 0;
                                while (i2 < st.length) {
                                    IStatus s = st[i2];
                                    if (s != null && s.getSeverity() != 0) {
                                        status.add(s);
                                    }
                                    ++i2;
                                }
                            }
                            ++k;
                        }
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block15;
                    e.printStackTrace();
                }
            }
            ++j;
        }
    }

    protected void buildElements(List elements, IProgressMonitor monitor) {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        IDLTKLanguageToolkit toolkit = null;
        try {
            toolkit = DLTKLanguageManager.getLanguageToolkit(this.scriptProject);
            IScriptBuilder[] builders = ScriptBuilderManager.getScriptBuilders(toolkit.getNatureId());
            if (builders != null) {
                int k = 0;
                while (k < builders.length) {
                    IStatus[] st = builders[k].buildModelElements(this.scriptProject, elements, monitor);
                    if (st != null) {
                        int i = 0;
                        while (i < st.length) {
                            IStatus s = st[i];
                            if (s != null && s.getSeverity() != 0) {
                                status.add(s);
                            }
                            ++i;
                        }
                    }
                    ++k;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
    }

    private List findDependencies(List resources) {
        try {
            IScriptBuilder[] builders = ScriptBuilderManager.getAllScriptBuilders();
            ArrayList elementsToCheck = new ArrayList();
            elementsToCheck.addAll(resources);
            ArrayList result = new ArrayList();
            result.addAll(resources);
            while (elementsToCheck.size() > 0) {
                ArrayList newElementsToCheck = new ArrayList();
                int i = 0;
                while (i < builders.length) {
                    List newResources = builders[i].getDependencies(this.scriptProject, elementsToCheck);
                    if (newResources != null) {
                        newElementsToCheck.addAll(newResources);
                    }
                    ++i;
                }
                i = 0;
                while (i < newElementsToCheck.size()) {
                    Object o = newElementsToCheck.get(i);
                    if (!result.contains(o)) {
                        result.add(o);
                    }
                    ++i;
                }
                elementsToCheck.clear();
                elementsToCheck.addAll(newElementsToCheck);
            }
            return result;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return resources;
        }
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.dltk.core.problem", false, 2);
                resource.deleteMarkers("org.eclipse.dltk.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void writeState(Object state, DataOutputStream out) throws IOException {
        ((State)state).write(out);
    }

    public static State readState(IProject project, DataInputStream in) throws IOException {
        State state = State.read(project, in);
        return state;
    }

    class ExternalModuleVisitor
    implements IModelElementVisitor {
        private List elements;

        public ExternalModuleVisitor(List elements) {
            this.elements = elements;
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 3) {
                if (!(element instanceof ExternalProjectFragment) && !(element instanceof BuiltinProjectFragment)) {
                    return false;
                }
                IProjectFragment fragment = (IProjectFragment)element;
                if (ScriptBuilder.this.lastState.externalFolderLocations.contains(fragment.getPath())) {
                    return false;
                }
                ScriptBuilder.this.lastState.externalFolderLocations.add(fragment.getPath());
            }
            if (element.getElementType() == 5 && (element instanceof ExternalSourceModule || element instanceof BuiltinSourceModule)) {
                if (!this.elements.contains(element)) {
                    this.elements.add(element);
                }
                return false;
            }
            return true;
        }
    }

    class ResourceVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private List resources;

        public ResourceVisitor(List resources) {
            this.resources = resources;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    if (this.resources.contains(resource) || resource.getType() != 1) break;
                    this.resources.add(resource);
                    return false;
                }
            }
            return true;
        }

        public boolean visit(IResource resource) {
            if (!this.resources.contains(resource) && resource.getType() == 1) {
                this.resources.add(resource);
                return false;
            }
            return true;
        }
    }
}

