/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ContentAssistProcessor;
import org.eclipse.dltk.ui.text.completion.ProposalSorterRegistry;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;

public abstract class ScriptCompletionProcessor
extends ContentAssistProcessor {
    private static final String VISIBILITY = "org.eclipse.dltk.core.codeComplete.visibilityCheck";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private IContextInformationValidator fValidator;
    protected final IEditorPart fEditor;

    public ScriptCompletionProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        super(assistant, partition);
        this.fEditor = editor;
    }

    public void restrictProposalsToVisibility(boolean restrict) {
        Hashtable options = DLTKCore.getOptions();
        Object value = options.get(VISIBILITY);
        if (value instanceof String) {
            String newValue;
            String string = newValue = restrict ? ENABLED : DISABLED;
            if (!newValue.equals(value)) {
                options.put(VISIBILITY, newValue);
                DLTKCore.setOptions((Hashtable)options);
            }
        }
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add ParameterListValidator support here.");
        }
        return this.fValidator;
    }

    protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        ProposalSorterRegistry.getDefault().getCurrentSorter().sortProposals(context, proposals);
        return proposals;
    }

    protected abstract ContentAssistInvocationContext createContext(ITextViewer var1, int var2);
}

