/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.ui.IEditorInput;

public class WorkingCopyManager
implements IWorkingCopyManager {
    private ISourceModuleDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(ISourceModuleDocumentProvider provider) {
        this.fDocumentProvider = provider;
    }

    public void connect(IEditorInput input) throws CoreException {
        this.fDocumentProvider.connect(input);
    }

    public void disconnect(IEditorInput input) {
        this.fDocumentProvider.disconnect(input);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        if (this.fIsShuttingDown) return;
        this.fIsShuttingDown = true;
        try {
            if (this.fMap != null) {
                this.fMap.clear();
                this.fMap = null;
            }
            this.fDocumentProvider.shutdown();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fIsShuttingDown = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fIsShuttingDown = false;
            return;
        }
    }

    public ISourceModule getWorkingCopy(IEditorInput input) {
        return this.getWorkingCopy(input, true);
    }

    public ISourceModule getWorkingCopy(IEditorInput input, boolean primaryOnly) {
        ISourceModule unit;
        ISourceModule iSourceModule = unit = this.fMap == null ? null : (ISourceModule)this.fMap.get(input);
        if (unit == null) {
            unit = this.fDocumentProvider.getWorkingCopy(input);
        }
        if (unit != null && (!primaryOnly || ScriptModelUtil.isPrimary((ISourceModule)unit))) {
            return unit;
        }
        return null;
    }

    public void setWorkingCopy(IEditorInput input, ISourceModule workingCopy) {
        if (this.fDocumentProvider.getDocument(input) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(input, workingCopy);
        }
    }

    public void removeWorkingCopy(IEditorInput input) {
        this.fMap.remove(input);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

