/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.ui.IContainmentAdapter;

public class DLTKElementContainmentAdapter
implements IContainmentAdapter {
    private IScriptModel fModel = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    static /* synthetic */ Class class$0;

    public boolean contains(Object workingSetElement, Object element, int flags) {
        if (!(workingSetElement instanceof IModelElement) || element == null) {
            return false;
        }
        IModelElement workingSetModelElement = (IModelElement)workingSetElement;
        IResource resource = null;
        IModelElement jElement = null;
        if (element instanceof IModelElement) {
            jElement = (IModelElement)element;
            resource = jElement.getResource();
        } else if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && this.fModel.contains(resource) && (jElement = DLTKCore.create((IResource)resource)) != null && !jElement.exists()) {
                jElement = null;
            }
        }
        if (jElement != null) {
            if (this.contains(workingSetModelElement, jElement, flags)) {
                return true;
            }
            if (workingSetModelElement.getElementType() == 3 && resource.getType() == 2 && this.checkIfDescendant(flags)) {
                return this.isChild(workingSetModelElement, resource);
            }
        } else if (resource != null) {
            return this.contains(workingSetModelElement, resource, flags);
        }
        return false;
    }

    private boolean contains(IModelElement workingSetElement, IModelElement element, int flags) {
        if (this.checkContext(flags) && workingSetElement.equals(element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetElement.equals(element.getParent())) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetElement, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetElement);
    }

    private boolean check(IModelElement ancestor, IModelElement descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals(descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    private boolean isChild(IModelElement workingSetElement, IResource element) {
        IResource resource = workingSetElement.getResource();
        if (resource == null) {
            return false;
        }
        return this.check(element, resource);
    }

    private boolean contains(IModelElement workingSetElement, IResource element, int flags) {
        IResource workingSetResource = workingSetElement.getResource();
        if (workingSetResource == null) {
            return false;
        }
        if (this.checkContext(flags) && workingSetResource.equals((Object)element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetResource.equals((Object)element.getParent())) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetResource, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetResource);
    }

    private boolean check(IResource ancestor, IResource descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    private boolean checkIfDescendant(int flags) {
        return (flags & 8) != 0;
    }

    private boolean checkIfAncestor(int flags) {
        return (flags & 4) != 0;
    }

    private boolean checkIfChild(int flags) {
        return (flags & 2) != 0;
    }

    private boolean checkContext(int flags) {
        return (flags & 1) != 0;
    }
}

