/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.corext.callhierarchy.CallLocation;
import org.eclipse.dltk.internal.corext.callhierarchy.CalleeMethodWrapper;
import org.eclipse.dltk.internal.corext.callhierarchy.CallerMethodWrapper;
import org.eclipse.dltk.internal.corext.callhierarchy.Implementors;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodCall;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.dltk.internal.ui.util.StringMatcher;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class CallHierarchy {
    private static final String PREF_USE_IMPLEMENTORS = "PREF_USE_IMPLEMENTORS";
    private static final String PREF_USE_FILTERS = "PREF_USE_FILTERS";
    private static final String PREF_FILTERS_LIST = "PREF_FILTERS_LIST";
    private static final String DEFAULT_IGNORE_FILTERS = "java.*,javax.*";
    private static CallHierarchy fgInstance;
    private IDLTKSearchScope fSearchScope;
    private StringMatcher[] fFilters;

    public static CallHierarchy getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchy();
        }
        return fgInstance;
    }

    public boolean isSearchUsingImplementorsEnabled() {
        IPreferenceStore settings = DLTKUIPlugin.getDefault().getPreferenceStore();
        return settings.getBoolean(PREF_USE_IMPLEMENTORS);
    }

    public void setSearchUsingImplementorsEnabled(boolean enabled) {
        IPreferenceStore settings = DLTKUIPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_USE_IMPLEMENTORS, enabled);
    }

    public Collection getImplementingMethods(IMethod method) {
        IModelElement[] result;
        if (this.isSearchUsingImplementorsEnabled() && (result = Implementors.getInstance().searchForImplementors(new IModelElement[]{method}, (IProgressMonitor)new NullProgressMonitor())) != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return new ArrayList(0);
    }

    public MethodWrapper getCallerRoot(IMethod method) {
        return new CallerMethodWrapper(null, new MethodCall((IModelElement)method));
    }

    public MethodWrapper getCalleeRoot(IMethod method) {
        return new CalleeMethodWrapper(null, new MethodCall((IModelElement)method));
    }

    public static CallLocation getCallLocation(Object element) {
        CallLocation callLocation = null;
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)element);
            MethodCall methodCall = methodWrapper.getMethodCall();
            if (methodCall != null) {
                callLocation = methodCall.getFirstCallLocation();
            }
        } else if (element instanceof CallLocation) {
            callLocation = (CallLocation)element;
        }
        return callLocation;
    }

    public IDLTKSearchScope getSearchScope(IDLTKLanguageToolkit toolkit) {
        if (this.fSearchScope == null) {
            this.fSearchScope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        }
        return this.fSearchScope;
    }

    public void setSearchScope(IDLTKSearchScope searchScope) {
        this.fSearchScope = searchScope;
    }

    public boolean isIgnored(String fullyQualifiedName) {
        if (this.getIgnoreFilters() != null && this.getIgnoreFilters().length > 0) {
            int i = 0;
            while (i < this.getIgnoreFilters().length) {
                String fullyQualifiedName1 = fullyQualifiedName;
                if (this.getIgnoreFilters()[i].match(fullyQualifiedName1)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isFilterEnabled() {
        IPreferenceStore settings = DLTKUIPlugin.getDefault().getPreferenceStore();
        return settings.getBoolean(PREF_USE_FILTERS);
    }

    public void setFilterEnabled(boolean filterEnabled) {
        IPreferenceStore settings = DLTKUIPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_USE_FILTERS, filterEnabled);
    }

    public String getFilters() {
        IPreferenceStore settings = DLTKUIPlugin.getDefault().getPreferenceStore();
        return settings.getString(PREF_FILTERS_LIST);
    }

    public void setFilters(String filters) {
        this.fFilters = null;
        IPreferenceStore settings = DLTKUIPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_FILTERS_LIST, filters);
    }

    private StringMatcher[] getIgnoreFilters() {
        if (this.fFilters == null) {
            String filterString = null;
            if (this.isFilterEnabled() && (filterString = this.getFilters()) == null) {
                filterString = DEFAULT_IGNORE_FILTERS;
            }
            this.fFilters = filterString != null ? CallHierarchy.parseList(filterString) : null;
        }
        return this.fFilters;
    }

    private static StringMatcher[] parseList(String listString) {
        ArrayList<StringMatcher> list = new ArrayList<StringMatcher>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String textFilter = tokenizer.nextToken().trim();
            list.add(new StringMatcher(textFilter, false, false));
        }
        return list.toArray(new StringMatcher[list.size()]);
    }
}

