/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;

public class AddSelectedLibraryOperation
extends BuildpathModifierOperation {
    public AddSelectedLibraryOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_tooltip, 13);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List elements = this.getSelectedElements();
            IScriptProject project = this.fInformationProvider.getScriptProject();
            result = this.addLibraryEntries(elements, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws ModelException {
        if (elements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.size()) {
            if (types[i] != 13) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getDescription(int type) {
        Object obj = this.getSelectedElements().get(0);
        String name = AddSelectedLibraryOperation.escapeSpecialChars(((IFile)obj).getName());
        if (type == 13) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ArchiveToBuildpath, name);
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_toBuildpath;
    }
}

