/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.AbstractScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;

public class ScriptVariable
extends AbstractScriptVariable {
    private final IDbgpSession session;
    private IScriptStackFrame frame;
    private final IDbgpProperty property;
    private String assignedValue;
    private IScriptType type;

    protected ScriptVariable[] readChildrenVariables(IDbgpCoreCommands core) throws DbgpException {
        String key = this.property.getKey();
        IDbgpProperty p = null;
        p = key != null ? core.getPropertyByKey(this.property.getEvalName(), this.property.getKey()) : (this.frame != null ? core.getProperty(this.property.getEvalName(), this.frame.getLevel()) : core.getProperty(this.property.getEvalName()));
        IDbgpProperty[] properties = p.getAvailableChildren();
        ScriptVariable[] variables = new ScriptVariable[properties.length];
        int i = 0;
        while (i < properties.length) {
            variables[i] = this.createChildVariable(properties[i]);
            ++i;
        }
        return variables;
    }

    protected ScriptVariable createChildVariable(IDbgpProperty property) {
        if (this.frame != null) {
            return new ScriptVariable(this.frame, property);
        }
        return new ScriptVariable(this.getDebugTarget(), this.session, property);
    }

    public ScriptVariable(IScriptStackFrame frame, IDbgpProperty property) {
        super(frame.getDebugTarget());
        this.frame = frame;
        this.session = ((IScriptThread)frame.getThread()).getDbgpSession();
        this.property = property;
    }

    public ScriptVariable(IDebugTarget target, IDbgpSession session, IDbgpProperty property) {
        super(target);
        this.session = session;
        this.property = property;
    }

    public String getName() throws DebugException {
        return this.property.getName();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getType().getName();
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
        try {
            if (this.frame != null) {
                if (this.session.getCoreCommands().setProperty(this.property.getEvalName(), this.frame.getLevel(), expression)) {
                    DebugEventHelper.fireChangeEvent(this);
                }
                this.assignedValue = expression;
            }
        }
        catch (DbgpException e) {
            throw this.wrapDbgpException("Can't assign variable", e);
        }
    }

    public void setValue(IValue value) throws DebugException {
        this.setValue(value.getValueString());
    }

    public boolean supportsValueModification() {
        return this.frame != null && !this.hasChildren() && !this.property.isConstant();
    }

    public boolean verifyValue(String expression) throws DebugException {
        return expression != null;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return this.verifyValue(value.getValueString());
    }

    public boolean hasChildren() {
        boolean shouldHas = this.property.hasChildren();
        int count = this.property.getChildrenCount();
        return count == -1 ? shouldHas : shouldHas && count > 0;
    }

    public boolean isConstant() {
        return this.property.isConstant();
    }

    public synchronized IScriptVariable[] getChildren() throws DebugException {
        try {
            return this.readChildrenVariables(this.session.getCoreCommands());
        }
        catch (DbgpException e) {
            throw this.wrapDbgpException("Exception during getting variable children", e);
        }
    }

    public String getValueString() {
        return this.assignedValue != null ? this.assignedValue : this.property.getValue();
    }

    public String toString() {
        return this.getEvalName();
    }

    public String getEvalName() {
        return this.property.getEvalName();
    }

    public String getId() {
        return this.property.getKey();
    }

    public IScriptType getType() {
        if (this.type == null) {
            IScriptTypeFactory factory = ScriptDebugManager.getInstance().getTypeFactoryByDebugModel(this.getModelIdentifier());
            this.type = factory != null ? factory.buildType(this.property.getType()) : new AtomicScriptType(this.property.getType());
        }
        return this.type;
    }
}

