/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.text;

import org.eclipse.dltk.ruby.core.text.RubyKeyword;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;

public abstract class RubyContext {
    public static final int MODE_FULL = 0;
    public static final int MODE_DOT_NAME = 1;
    public static final int INSIDE_NOTHING = 0;
    public static final int INSIDE_GLOBAL_VARIABLE = 1;
    public static final int INSIDE_INSTANCE_VARIABLE = 2;
    public static final int INSIDE_CLASS_VARIABLE = 3;
    public static final int INSIDE_IDENTIFIER = 4;
    public static final int INSIDE_CONSTANT = 5;
    public static final int INSIDE_NUMERIC_CONSTANT = 6;
    private final ModifierState modifierState;
    private final SlashStatus slashStatus;
    private final String name;
    public static final RubyContext UNKNOWN = new RubyContext("COMMAND_START", ModifierState.UNKNOWN, SlashStatus.UNKNOWN, HeredocStatus.UNKNOWN){};
    public static final RubyContext COMMAND_START = new RubyContext("COMMAND_START", ModifierState.STATEMENT, SlashStatus.REGEXP, HeredocStatus.HEREDOC){};
    public static final RubyContext ARGUMENT = new RubyContext("ARGUMENT ", ModifierState.MODIFIER, SlashStatus.SPACE_DEPENDENT, HeredocStatus.SPACE_DEPENDENT){};
    public static final RubyContext AFTER_EXPRESSION = new RubyContext("AFTER_EXPRESSION", ModifierState.MODIFIER, SlashStatus.OPERATOR, HeredocStatus.SHIFT){};
    public static final RubyContext ARGUMENT_OR_AFTER_EXPRESSION = new RubyContext("ARGUMENT_OR_AFTER_EXPRESSION", ModifierState.MODIFIER, SlashStatus.OPERATOR, HeredocStatus.HEREDOC){};
    public static final RubyContext NAME = new RubyContext("NAME", ModifierState.IGNORED, SlashStatus.IGNORED, HeredocStatus.UNEXPECTED){

        public boolean ignoreKeywords() {
            return true;
        }
    };
    public static final RubyContext AFTER_DOT = new RubyContext("AFTER_DOT", ModifierState.IGNORED, SlashStatus.IGNORED, HeredocStatus.UNEXPECTED){

        public boolean ignoreKeywords() {
            return true;
        }
    };
    public static final RubyContext EXPRESSION_START = new RubyContext("EXPRESSION_START", ModifierState.STATEMENT, SlashStatus.REGEXP, HeredocStatus.HEREDOC){};
    public static final RubyContext KEYWORD_ARGUMENT = new RubyContext("KEYWORD_ARGUMENT", ModifierState.STATEMENT, SlashStatus.REGEXP, HeredocStatus.HEREDOC){};
    public static final RubyContext COMMENT = new RubyContext("COMMENT", ModifierState.IGNORED, SlashStatus.IGNORED, HeredocStatus.IGNORED){};
    public static final RubyContext INSIDE = new RubyContext("INSIDE_CLASS_VAR", ModifierState.IGNORED, SlashStatus.IGNORED, HeredocStatus.IGNORED){};

    private RubyContext(String name, ModifierState modifierState, SlashStatus slashStatus, HeredocStatus heredocStatus) {
        this.name = name;
        this.modifierState = modifierState;
        this.slashStatus = slashStatus;
    }

    public ModifierState getModifierState() {
        return this.modifierState;
    }

    public SlashStatus getSlashStatus() {
        return this.slashStatus;
    }

    public boolean ignoreKeywords() {
        return false;
    }

    public String toString() {
        return this.name;
    }

    private static boolean isNewLineChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public static HeuristicLookupResult determineContext(CharSequence document, int offset, int mode) {
        int keywordStart;
        int keyOffset = offset - 1;
        char ch = '\u0000';
        while (keyOffset >= 0) {
            ch = document.charAt(keyOffset);
            if (!Character.isWhitespace(ch)) break;
            if (RubyContext.isNewLineChar(ch)) {
                --keyOffset;
                while (keyOffset >= 0) {
                    ch = document.charAt(keyOffset);
                    if (!RubyContext.isNewLineChar(ch)) break;
                    --keyOffset;
                }
                if (keyOffset < 0) break;
                if (ch != '\\') {
                    HeuristicLookupResult result = RubyContext.determineContext(document, keyOffset + 1, mode);
                    if (result.context == COMMAND_START || result.context == EXPRESSION_START || result.context == NAME || result.context == AFTER_DOT) {
                        return result;
                    }
                    HeuristicLookupResult myresult = new HeuristicLookupResult();
                    myresult.context = COMMAND_START;
                    myresult.keyOffset = keyOffset;
                    return myresult;
                }
            }
            --keyOffset;
        }
        HeuristicLookupResult myresult = new HeuristicLookupResult();
        myresult.keyOffset = keyOffset;
        if (keyOffset < 0) {
            myresult.context = COMMAND_START;
            return myresult;
        }
        switch (ch) {
            case '.': 
            case ':': {
                myresult.context = AFTER_DOT;
                return myresult;
            }
            case '!': {
                myresult.context = EXPRESSION_START;
                return myresult;
            }
            case '(': 
            case ';': {
                myresult.context = COMMAND_START;
                return myresult;
            }
            case '{': {
                myresult.context = EXPRESSION_START;
                return myresult;
            }
            case '=': {
                myresult.context = EXPRESSION_START;
                return myresult;
            }
            case '/': {
                myresult.context = EXPRESSION_START;
                return myresult;
            }
            case '%': 
            case '&': 
            case '+': 
            case ',': 
            case '-': 
            case '<': 
            case '>': 
            case '[': 
            case '^': 
            case '~': {
                myresult.context = EXPRESSION_START;
                return myresult;
            }
            case ')': 
            case ']': 
            case '}': {
                myresult.context = AFTER_EXPRESSION;
                return myresult;
            }
            case '|': {
                myresult.context = EXPRESSION_START;
                return myresult;
            }
            case '*': {
                myresult.context = EXPRESSION_START;
                return myresult;
            }
            case '#': {
                if (keyOffset >= 1) {
                    char c2 = document.charAt(keyOffset - 1);
                    if (c2 == '?') {
                        myresult.context = AFTER_EXPRESSION;
                        return myresult;
                    }
                    if (c2 == '\\' && keyOffset >= 2 && document.charAt(keyOffset - 2) == '?') {
                        myresult.context = AFTER_EXPRESSION;
                        return myresult;
                    }
                }
                myresult.context = COMMENT;
                return myresult;
            }
        }
        if ((mode & 1) == 1) {
            myresult.context = UNKNOWN;
            return myresult;
        }
        myresult.startOfIdentifier = keywordStart = RubySyntaxUtils.getInclusiveStartOfIdentifierEndingAt(document, keyOffset);
        if (keywordStart != -1) {
            RubyContext context;
            RubyKeyword keyword;
            char startCh = document.charAt(keywordStart);
            switch (startCh) {
                case '$': {
                    myresult.inside = 1;
                    break;
                }
                case '@': {
                    if (keywordStart + 1 < document.length() && document.charAt(keywordStart + 1) == '@') {
                        myresult.inside = 3;
                        break;
                    }
                    myresult.inside = 2;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    myresult.inside = 6;
                    break;
                }
                default: {
                    myresult.inside = Character.isUpperCase(startCh) ? 5 : 4;
                }
            }
            if (keyOffset == offset - 1 && offset < document.length() && RubySyntaxUtils.isIdentifierCharacter(document.charAt(offset)) && RubySyntaxUtils.isStrictIdentifierCharacter(document.charAt(offset - 1))) {
                myresult.context = INSIDE;
                return myresult;
            }
            myresult.preidentifierContext = RubyContext.determineContext(document, keywordStart, 1);
            RubyContext kwContext = myresult.preidentifierContext.context;
            if (kwContext == AFTER_DOT || kwContext == NAME) {
                myresult.context = ARGUMENT;
                return myresult;
            }
            String name = document.subSequence(keywordStart, keyOffset + 1).toString();
            if (Character.isDigit(name.charAt(0))) {
                myresult.context = AFTER_EXPRESSION;
                return myresult;
            }
            myresult.keyword = keyword = RubyKeyword.byName(name);
            if (keyword != null && (context = keyword.getIntroducedContext()) != null) {
                myresult.context = context;
                return myresult;
            }
        }
        switch (myresult.inside) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                myresult.context = AFTER_EXPRESSION;
                break;
            }
            default: {
                myresult.context = ARGUMENT_OR_AFTER_EXPRESSION;
            }
        }
        return myresult;
    }

    /* synthetic */ RubyContext(String string, ModifierState modifierState, SlashStatus slashStatus, HeredocStatus heredocStatus, RubyContext rubyContext) {
        this(string, modifierState, slashStatus, heredocStatus);
    }

    public static abstract class HeredocStatus {
        public static final HeredocStatus UNKNOWN = new HeredocStatus(){};
        public static final HeredocStatus UNEXPECTED = new HeredocStatus(){};
        public static final HeredocStatus IGNORED = new HeredocStatus(){};
        public static final HeredocStatus SHIFT = new HeredocStatus(){};
        public static final HeredocStatus HEREDOC = new HeredocStatus(){};
        public static final HeredocStatus SPACE_DEPENDENT = new HeredocStatus(){};

        private HeredocStatus() {
        }
    }

    public static class HeuristicLookupResult {
        public RubyContext context;
        public int keyOffset;
        public int startOfIdentifier = -1;
        public HeuristicLookupResult preidentifierContext;
        public int inside = 0;
        public RubyKeyword keyword;
    }

    public static abstract class ModifierState {
        public static final ModifierState UNKNOWN = new ModifierState(){};
        public static final ModifierState IGNORED = new ModifierState(){};
        public static final ModifierState STATEMENT = new ModifierState(){};
        public static final ModifierState MODIFIER = new ModifierState(){};

        private ModifierState() {
        }
    }

    public static abstract class SlashStatus {
        public static final SlashStatus UNKNOWN = new SlashStatus(){};
        public static final SlashStatus UNEXPECTED = new SlashStatus(){};
        public static final SlashStatus IGNORED = new SlashStatus(){};
        public static final SlashStatus OPERATOR = new SlashStatus(){};
        public static final SlashStatus REGEXP = new SlashStatus(){};
        public static final SlashStatus SPACE_DEPENDENT = new SlashStatus(){};

        private SlashStatus() {
        }
    }

    public static abstract class UnaryBinaryStatus {
        public static final SlashStatus UNKNOWN = new SlashStatus(){};
        public static final SlashStatus UNEXPECTED = new SlashStatus(){};
        public static final SlashStatus IGNORED = new SlashStatus(){};
        public static final SlashStatus UNARY = new SlashStatus(){};
        public static final SlashStatus BINARY = new SlashStatus(){};
        public static final SlashStatus SPACE_DEPENDENT = new SlashStatus(){};

        private UnaryBinaryStatus() {
        }
    }
}

