/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.screenreader.jaws.script;

import org.eclipse.actf.ai.screenreader.jaws.script.Key;
import org.eclipse.actf.ai.screenreader.jaws.script.KeyConverter;

public class Keymap {
    public int key;
    public int modifier;
    public boolean jaws;
    public boolean windows;
    public String scriptName;

    public Keymap(String line) {
        try {
            int index = line.indexOf("=");
            String keyStr = line.substring(0, index).trim();
            keyStr.equals("JAWSKey+H");
            this.scriptName = line.substring(index + 1).trim();
            String[] keyStrs = keyStr.split("[\\+]");
            int i = 0;
            while (i < keyStrs.length) {
                String k = keyStrs[i].toLowerCase().replaceAll(" ", "");
                if (k.equals("control")) {
                    this.modifier |= 2;
                } else if (k.equals("shift")) {
                    this.modifier |= 1;
                } else if (k.equals("alt")) {
                    this.modifier |= 8;
                } else if (k.equals("jawskey") || k.equals("insert")) {
                    this.jaws = true;
                } else if (k.equals("windows")) {
                    this.windows = true;
                } else {
                    this.key = KeyConverter.convert(k);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println(line);
        }
    }

    public String toString() {
        return String.valueOf(this.key) + ", " + this.modifier + ", " + this.jaws + ", " + this.windows + ", " + this.scriptName;
    }

    public boolean equals(Object o) {
        if (o instanceof Key) {
            Key k = (Key)o;
            if (k.key == this.key && k.modifier == this.modifier && !this.jaws && !this.windows) {
                return true;
            }
        }
        return false;
    }
}

