/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.screenreader.jaws.script;

import java.util.HashMap;

public class KeyConverter {
    private static HashMap<Integer, String> k2s = new HashMap();
    private static HashMap<String, Integer> s2k = new HashMap();

    static {
        k2s.put(48, "0");
        k2s.put(49, "1");
        k2s.put(50, "2");
        k2s.put(51, "3");
        k2s.put(52, "4");
        k2s.put(53, "5");
        k2s.put(54, "6");
        k2s.put(55, "7");
        k2s.put(56, "8");
        k2s.put(57, "9");
        k2s.put(96, "NumPad0");
        k2s.put(97, "NumPad1");
        k2s.put(98, "NumPad2");
        k2s.put(99, "NumPad3");
        k2s.put(100, "NumPad4");
        k2s.put(101, "NumPad5");
        k2s.put(102, "NumPad6");
        k2s.put(103, "NumPad7");
        k2s.put(104, "NumPad8");
        k2s.put(105, "NumPad9");
        k2s.put(65, "A");
        k2s.put(66, "B");
        k2s.put(67, "C");
        k2s.put(68, "D");
        k2s.put(69, "E");
        k2s.put(70, "F");
        k2s.put(71, "G");
        k2s.put(72, "H");
        k2s.put(73, "I");
        k2s.put(74, "J");
        k2s.put(75, "K");
        k2s.put(76, "L");
        k2s.put(77, "M");
        k2s.put(78, "N");
        k2s.put(79, "O");
        k2s.put(80, "P");
        k2s.put(81, "Q");
        k2s.put(82, "R");
        k2s.put(83, "S");
        k2s.put(84, "T");
        k2s.put(85, "U");
        k2s.put(86, "V");
        k2s.put(87, "W");
        k2s.put(88, "X");
        k2s.put(89, "Y");
        k2s.put(90, "Z");
        k2s.put(112, "F1");
        k2s.put(113, "F2");
        k2s.put(114, "F3");
        k2s.put(115, "F4");
        k2s.put(116, "F5");
        k2s.put(117, "F6");
        k2s.put(118, "F7");
        k2s.put(119, "F8");
        k2s.put(120, "F9");
        k2s.put(121, "F10");
        k2s.put(122, "F11");
        k2s.put(123, "F12");
        k2s.put(61440, "F13");
        k2s.put(61441, "F14");
        k2s.put(61442, "F15");
        k2s.put(61443, "F16");
        k2s.put(61444, "F17");
        k2s.put(61445, "F18");
        k2s.put(61446, "F19");
        k2s.put(61447, "F20");
        k2s.put(61448, "F21");
        k2s.put(61449, "F22");
        k2s.put(61450, "F23");
        k2s.put(61451, "F24");
        k2s.put(8, "Backspace");
        k2s.put(192, "`");
        k2s.put(12, "Clear");
        k2s.put(513, "Colon");
        k2s.put(93, "]");
        k2s.put(44, ",");
        k2s.put(127, "Delete");
        k2s.put(515, "$");
        k2s.put(40, "DownArrow");
        k2s.put(61, "Equals");
        k2s.put(27, "Escape");
        k2s.put(18, "Alt");
        k2s.put(13, "Enter");
        k2s.put(35, "End");
        k2s.put(36, "Home");
        k2s.put(155, "Insert");
        k2s.put(37, "LeftArrow");
        k2s.put(45, "-");
        k2s.put(91, "[");
        k2s.put(19, "Pause");
        k2s.put(34, "PageDown");
        k2s.put(33, "PageUp");
        k2s.put(46, ".");
        k2s.put(521, "+");
        k2s.put(39, "RightArrow");
        k2s.put(59, ";");
        k2s.put(108, "|");
        k2s.put(47, "/");
        k2s.put(32, "Space");
        k2s.put(9, "Tab");
        k2s.put(523, "_");
        k2s.put(38, "UpArrow");
        k2s.put(17, "Control");
        k2s.put(16, "Shift");
        for (int key : k2s.keySet()) {
            s2k.put(k2s.get(key).toLowerCase(), key);
        }
        s2k.put("numpadplus", 521);
        s2k.put("numpadminus", 45);
        s2k.put("numpadslash", 47);
        s2k.put("numpadstar", 151);
        s2k.put("homerow", 36);
        s2k.put("extendedleftarrow", 37);
        s2k.put("extendedrightarrow", 39);
        s2k.put("extendeduparrow", 38);
        s2k.put("extendeddownarrow", 40);
        s2k.put("comma", 44);
        s2k.put("period", 46);
        s2k.put("apostrophe", 222);
        s2k.put("leftbracket", 91);
        s2k.put("rightbracket", 93);
        s2k.put("semicolon", 59);
    }

    public static boolean isIt(int value, int mask) {
        return (value & mask) == mask;
    }

    public static int convert(String key) {
        Integer i = s2k.get(key.toLowerCase());
        if (i == null) {
            return 0;
        }
        return i;
    }

    public static String convert(int key, int modifier) {
        String s;
        StringBuffer sb = new StringBuffer();
        if (KeyConverter.isIt(modifier, 8)) {
            sb.append("Alt+");
        }
        if (KeyConverter.isIt(modifier, 2)) {
            sb.append("Control+");
        }
        if (KeyConverter.isIt(modifier, 1)) {
            sb.append("Shift+");
        }
        if ((s = k2s.get(new Integer(key))) == null) {
            System.err.println("ERROR convert " + key);
            System.exit(0);
        }
        sb.append(s);
        return sb.toString();
    }
}

