/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.screenreader.jaws.script;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import org.eclipse.actf.ai.screenreader.jaws.script.KeyConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Key {
    public int key;
    public int modifier;
    public Key jawsKey;
    public boolean jawsHandle = false;
    public boolean jawsSayAllStop = true;
    public boolean jawsSayAllStopIgnore = false;
    public boolean currentScript = false;
    public boolean jawsScript = true;

    public Key(Node keyNode, Element commandElement) {
        this(keyNode.getTextContent().trim());
        if (keyNode instanceof Element) {
            String jawsScriptVal;
            String jawsSayAllStopVal;
            String jawsHandleVal;
            Element keyElem = (Element)keyNode;
            String key = keyElem.getAttribute("jawskey");
            if (key != null && key.length() > 0) {
                this.jawsKey = new Key(key);
            }
            if ((jawsHandleVal = keyElem.getAttribute("jawshandle")) != null && jawsHandleVal.trim().equals("true")) {
                this.jawsHandle = true;
            }
            if ((jawsSayAllStopVal = keyElem.getAttribute("jawsSayAllStop")) != null && jawsSayAllStopVal.trim().equals("false")) {
                this.jawsSayAllStop = false;
            }
            if ((jawsScriptVal = keyElem.getAttribute("jawsscript")) != null && jawsScriptVal.trim().equals("false")) {
                this.jawsScript = false;
            }
            if ("speakAll".equals(commandElement.getTagName())) {
                this.jawsSayAllStopIgnore = true;
            }
        }
    }

    public Key(String keyStr) {
        this.init(keyStr);
    }

    private void init(String keyStr) {
        String[] keyStrs = keyStr.split("[ \t\r\n]");
        if ("currentScript".equals(keyStr)) {
            this.currentScript = true;
            return;
        }
        this.modifier = 0;
        int i = 0;
        while (i < keyStrs.length) {
            if (keyStrs[i].startsWith("VK_")) {
                this.key = this.convertToInt(keyStrs[i]);
            } else if (keyStrs[i].endsWith("_MASK")) {
                this.modifier |= this.convertToInt(keyStrs[i]);
            }
            ++i;
        }
        if (this.key == 0) {
            System.err.println("ERROR init " + keyStr);
        }
    }

    public String toString() {
        return KeyConverter.convert(this.key, this.modifier);
    }

    public String toTypeString() {
        if (this.key == 19) {
            return "Control+Alt+Shift+P";
        }
        return this.toString();
    }

    private int convertToInt(String code) {
        code = code.trim();
        try {
            int i = Integer.parseInt(code);
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            if (code.equals("VK_RETURN")) {
                return 13;
            }
            try {
                Class<KeyEvent> c = KeyEvent.class;
                Field f = c.getField(code);
                return (Integer)f.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("ERROR " + code);
                return 0;
            }
        }
    }

    public String toFuncString() {
        String temp = this.toString();
        temp = temp.replaceAll("\\+", "_");
        return "func_" + temp;
    }
}

