/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class WritingContentHandler
extends DefaultHandler2 {
    private final Writer out;
    private final boolean requireClose;
    private final HashMap<String, String> prefixMapping = new HashMap();

    private void outputEscape(char[] ch, int start, int length) throws IOException {
        int end = start + length;
        while (start < end) {
            char c = ch[start];
            switch (c) {
                case '<': {
                    this.out.append("&lt;");
                    break;
                }
                case '>': {
                    this.out.append("&gt;");
                    break;
                }
                case '&': {
                    this.out.append("&amp;");
                    break;
                }
                default: {
                    this.out.append(c);
                }
            }
            ++start;
        }
    }

    private void outputEscapeAttrVal(String val) throws IOException {
        int len = val.length();
        int i = 0;
        while (i < len) {
            int j;
            block8: {
                j = i;
                while (j < len) {
                    char c = val.charAt(j);
                    switch (c) {
                        case '<': {
                            this.out.append(val, i, j);
                            this.out.append("&lt;");
                            break block8;
                        }
                        case '>': {
                            this.out.append(val, i, j);
                            this.out.append("&gt;");
                            break block8;
                        }
                        case '&': {
                            this.out.append(val, i, j);
                            this.out.append("&amp;");
                            break block8;
                        }
                        case '\'': {
                            this.out.append(val, i, j);
                            this.out.append("&apos;");
                            break block8;
                        }
                        default: {
                            ++j;
                        }
                    }
                }
                this.out.append(val, i, j);
            }
            i = j;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        try {
            if (this.out instanceof OutputStreamWriter) {
                Charset encoding = Charset.forName(((OutputStreamWriter)this.out).getEncoding());
                this.out.append("<?xml version=\"1.0\" encoding=\"");
                this.out.append(encoding.name());
                this.out.append("\"?>\n");
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            if (this.requireClose) {
                this.out.close();
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMapping.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        boolean firstAttr = true;
        try {
            this.out.append('<');
            this.out.append(qName);
            for (String key : this.prefixMapping.keySet()) {
                String aName = key.length() > 0 ? "xmlns:" + key : "xmlns";
                if (attrs.getIndex(aName) >= 0) continue;
                if (firstAttr) {
                    this.out.append(' ');
                    firstAttr = false;
                }
                this.out.append(aName);
                this.out.append("=\"");
                this.out.append(this.prefixMapping.get(key));
                this.out.append("\" ");
            }
            this.prefixMapping.clear();
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                String qNameA = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (firstAttr) {
                    this.out.append(' ');
                    firstAttr = false;
                }
                this.out.append(qNameA);
                this.out.append("=\"");
                this.outputEscapeAttrVal(value);
                this.out.append("\" ");
                ++i;
            }
            this.out.append('>');
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.out.append("</");
            this.out.append(qName);
            this.out.append('>');
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.outputEscape(ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.out.write(ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.out.append("<?");
            this.out.append(target);
            this.out.append(' ');
            this.out.append(data);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.out.append("<!-- ");
            this.outputEscape(ch, start, length);
            this.out.append("-->");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public WritingContentHandler(String name) {
        this.out = new OutputStreamWriter(System.out);
        this.requireClose = false;
    }

    public WritingContentHandler(OutputStream os) {
        this.out = new OutputStreamWriter(os);
        this.requireClose = true;
    }

    public WritingContentHandler(Writer out) {
        this.out = out;
        this.requireClose = true;
    }
}

