/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.util;

import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLMode;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModel;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelTraverse;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLNoResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRule;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;

public class NVDLModelPrint
extends NVDLModelTraverse {
    private void println(Object o) {
        System.out.println(o);
    }

    public NVDLModel visitNVDLMode(NVDLMode mode) throws NVDLModelException {
        this.println("Mode " + mode.name + " " + mode.getLocation() + ":");
        return super.visitNVDLMode(mode);
    }

    private void printNVDLAction(NVDLAction action) {
        StringBuffer r = new StringBuffer(action.toString());
        if (action.getMessage() != null) {
            r.append("Message:");
            r.append(action.getMessage().toString());
        }
        r.append("useMode:");
        if (action.getUseModeName() != null) {
            r.append(action.getUseModeName());
        }
        this.println(r);
    }

    public NVDLModel visitNVDLNoResultAction(NVDLNoResultAction action) throws NVDLModelException {
        this.printNVDLAction(action);
        return super.visitNVDLNoResultAction(action);
    }

    public NVDLModel visitNVDLResultAction(NVDLResultAction action) throws NVDLModelException {
        this.printNVDLAction(action);
        return super.visitNVDLResultAction(action);
    }

    public NVDLModel visitNVDLRule(NVDLRule rule) throws NVDLModelException {
        this.println(rule);
        return super.visitNVDLRule(rule);
    }

    public NVDLModel visitNVDLRules(NVDLRules rules) throws NVDLModelException {
        this.println("Rules " + rules.getLocation() + ":");
        this.println("  SchemaType:" + rules.getSchmaType());
        this.println("  StartMode:");
        this.println(rules.getStartMode().name);
        this.println(rules.getTriggerManager());
        this.println("  Defined modes:");
        return super.visitNVDLRules(rules);
    }

    public static void printRules(NVDLRules r) {
        NVDLModelPrint v = new NVDLModelPrint();
        try {
            r.visitModel(v);
        }
        catch (NVDLModelException e) {
            System.out.println("Received NVDLModelException:" + e);
            e.printStackTrace();
        }
    }
}

