/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.driver;

import java.util.Locale;
import org.eclipse.actf.ai.xmlstore.nvdl.driver.DispatchDriver;
import org.eclipse.actf.ai.xmlstore.nvdl.driver.ReconstructionDriver;
import org.eclipse.actf.ai.xmlstore.nvdl.driver.ValidationDriver;
import org.eclipse.actf.ai.xmlstore.nvdl.util.Log;
import org.eclipse.actf.ai.xmlstore.nvdl.util.MessageErrorHandler;
import org.eclipse.actf.ai.xmlstore.nvdl.util.MessageFormatter;
import org.xml.sax.ErrorHandler;

public class SnRNV {
    private static String targetDirectory = "";
    private static boolean debug = false;
    private static boolean quiet = false;
    private static boolean dispatch = false;
    private static boolean reconstruction = false;

    private static void usage() {
        Log.error("SnRNV.Usage");
    }

    private static void printException(Exception e) {
        Log.error(MessageFormatter.exception(e));
    }

    private static void validate(String nvdlFile, String instanceFile, ErrorHandler eh) {
        try {
            ValidationDriver d = new ValidationDriver(eh, debug, quiet);
            d.validate(nvdlFile, instanceFile);
        }
        catch (Exception e) {
            SnRNV.printException(e);
        }
    }

    private static void dispatch(String nvdlFile, String instanceFile, ErrorHandler eh) {
        try {
            DispatchDriver d = new DispatchDriver(eh, debug, quiet);
            d.dispatch(nvdlFile, instanceFile, targetDirectory);
        }
        catch (Exception e) {
            SnRNV.printException(e);
        }
    }

    private static void reconstruct(String nvdlFile, String instanceFile, ErrorHandler eh) {
        try {
            ReconstructionDriver d = new ReconstructionDriver(eh, debug, quiet);
            d.reconstruct(nvdlFile, instanceFile, targetDirectory);
        }
        catch (Exception e) {
            SnRNV.printException(e);
        }
    }

    private static int setTargetDirectory(String[] args, int i) {
        if (i == args.length - 1) {
            Log.error("SnRNV.TargetDirectoryNotSpecifiedError");
            System.exit(255);
        }
        targetDirectory = args[++i];
        return i;
    }

    private static int setLocale(String[] args, int i) {
        Locale locale;
        String iso646Code;
        int idx;
        if (i == args.length - 1) {
            Log.error("SnRNV.LocaleRequireArgumentError");
            System.exit(255);
        }
        if ((idx = (iso646Code = args[++i]).indexOf(95)) > 0) {
            String lang = iso646Code.substring(0, idx);
            String country = iso646Code.substring(idx + 1);
            locale = new Locale(lang, country);
        } else {
            locale = new Locale(iso646Code);
        }
        Locale.setDefault(locale);
        MessageFormatter.setResourceBundle("org.eclipse.actf.ai.xmlstore.nvdl.driver.message.Messages");
        return i;
    }

    public static void main(String[] args) {
        MessageErrorHandler eh = new MessageErrorHandler();
        MessageFormatter.setResourceBundle("org.eclipse.actf.ai.xmlstore.nvdl.driver.message.Messages");
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) != '-') break;
            if (args[i].equals("-d")) {
                Log.setLevel(4);
                debug = true;
            } else if (args[i].equals("-v")) {
                Log.setLevel(3);
            } else if (args[i].equals("-q")) {
                Log.setLevel(2);
                quiet = true;
            } else if (args[i].equals("-p")) {
                i = SnRNV.setTargetDirectory(args, i);
                dispatch = true;
            } else if (args[i].equals("-r")) {
                i = SnRNV.setTargetDirectory(args, i);
                reconstruction = true;
            } else if (args[i].equals("-locale")) {
                i = SnRNV.setLocale(args, i);
            } else {
                Log.error("SnRNV.InvalidOptionError", new Object[]{args[i]});
                System.exit(255);
            }
            ++i;
        }
        if (args.length - i < 2) {
            SnRNV.usage();
            System.exit(255);
        }
        String nvdlFile = args[i];
        String instanceFile = args[i + 1];
        if (dispatch) {
            SnRNV.dispatch(nvdlFile, instanceFile, eh);
        } else if (reconstruction) {
            SnRNV.reconstruct(nvdlFile, instanceFile, eh);
        } else {
            SnRNV.validate(nvdlFile, instanceFile, eh);
        }
        System.exit(0);
    }
}

