/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.eclipse.actf.ai.xmlstore.spi.XMLSelectorInfo;
import org.eclipse.actf.ai.xmlstore.spi.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class XMLFile
implements IXMLInfo {
    protected final File file;
    private XMLSelectorInfo selectorInfo;
    private XMLReader reader;
    protected Document doc;
    private long lastModified;

    XMLSelectorInfo getSelectorInfo() {
        return this.selectorInfo;
    }

    XMLFile(File file) throws XMLStoreException {
        this.file = file;
        this.reset();
    }

    XMLFile(File file, boolean flag) throws XMLStoreException {
        this.file = file;
        if (flag) {
            this.reset();
        }
    }

    private boolean isNotLatest() {
        return this.file.lastModified() > this.lastModified;
    }

    public String getDocumentation() {
        return this.selectorInfo.getDocumentation();
    }

    public boolean isUserEntry() {
        return this.selectorInfo.isUserEntry();
    }

    public int getPriority() {
        return this.selectorInfo.getPriority();
    }

    private InputSource getInputSource() throws FileNotFoundException {
        return new InputSource(new FileInputStream(this.file));
    }

    public Node getRootNode() throws XMLStoreException {
        if (this.isNotLatest()) {
            this.reset();
        }
        if (this.doc == null) {
            try {
                DocumentBuilder builder = XMLUtil.newDocumentBuilder();
                InputSource is = this.getInputSource();
                this.doc = builder.parse(is);
            }
            catch (Exception e) {
                throw new XMLStoreException("DOM initialization is failed.", e);
            }
        }
        return this.doc.getDocumentElement();
    }

    private void initReader() throws SAXException {
        if (this.reader == null) {
            this.reader = XMLReaderFactory.createXMLReader();
        }
    }

    public void setContentHandler(ContentHandler h) {
        try {
            this.initReader();
        }
        catch (SAXException e) {
            e.printStackTrace();
            return;
        }
        this.reader.setContentHandler(h);
    }

    public void startSAX() throws XMLStoreException, SAXException {
        try {
            this.initReader();
            InputSource is = this.getInputSource();
            this.reader.parse(is);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XMLStoreException("SAX startup is failed", e);
        }
    }

    public void reset() throws XMLStoreException {
        this.reader = null;
        this.doc = null;
        this.selectorInfo = XMLSelectorInfo.parse(this);
        this.lastModified = this.file.lastModified();
    }
}

