/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.actf.ai.xmlstore.IXMLEditableInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.eclipse.actf.ai.xmlstore.local.XMLFile;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserXML
extends XMLFile
implements IXMLEditableInfo {
    private String namespaceURI;
    private String qualifiedName;
    private String documentation = "User Annotation";
    private String targetUriPattern;
    private Pattern uriPat;
    private String pageTitle;
    private String authorName;
    private final boolean onlyInMemory;
    private int priority;
    private boolean removed = false;

    private static String getFileName(String targetURI) {
        long time = System.currentTimeMillis();
        String uri = targetURI.replaceAll("[\\/:*?\"<>|]", "-");
        if (uri.length() > 200) {
            uri = uri.substring(0, 200);
        }
        return String.valueOf(time) + "-" + uri + ".fnc";
    }

    UserXML(File file) throws XMLStoreException {
        super(file);
        this.onlyInMemory = false;
        this.targetUriPattern = this.getSelectorInfo().getURI();
        this.documentation = this.getSelectorInfo().getDocumentation();
        this.priority = this.getSelectorInfo().getPriority();
        this.pageTitle = this.getSelectorInfo().getPageTitle();
        this.authorName = this.getSelectorInfo().getAuthorName();
    }

    UserXML(String namespaceURI, String qualifiedName, String targetUriPattern, File dir) throws XMLStoreException {
        super(new File(dir, UserXML.getFileName(targetUriPattern)), false);
        this.namespaceURI = namespaceURI;
        this.qualifiedName = qualifiedName;
        this.onlyInMemory = true;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            this.doc = impl.createDocument(namespaceURI, qualifiedName, null);
            this.setTargetURIPattern(targetUriPattern);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getTargetUriPattern() {
        return this.targetUriPattern;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isUserEntry() {
        return true;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public int getPriority() {
        return this.priority;
    }

    public Node getRootNode() throws XMLStoreException {
        if (this.onlyInMemory) {
            return this.doc.getDocumentElement();
        }
        return super.getRootNode();
    }

    public void setContentHandler(ContentHandler h) {
        if (!this.onlyInMemory) {
            super.setContentHandler(h);
        }
    }

    public void startSAX() throws XMLStoreException, SAXException {
        if (this.onlyInMemory) {
            throw new SAXException("not supported");
        }
        super.startSAX();
    }

    public void reset() throws XMLStoreException {
        if (!this.onlyInMemory) {
            super.reset();
        }
    }

    public void save() {
        this.save(this.doc, this.file);
    }

    public void save(File file) {
        this.save(this.doc, file);
    }

    private void save(Document doc, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            this.save(doc, fos);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void save(Document doc, OutputStream stream) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.resetMeta();
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
        this.resetMeta();
    }

    private void setTargetURIPattern(String targetUriPattern) {
        this.targetUriPattern = targetUriPattern;
        this.uriPat = Pattern.compile(this.quote(targetUriPattern, '*'));
        this.resetMeta();
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
        this.resetMeta();
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
        this.resetMeta();
    }

    private void resetMeta() {
        Element meta = this.getElement("meta", this.doc.getDocumentElement());
        this.getElement("userEntry", meta);
        Element target = this.getElement("targetSite", meta);
        Element documentation = this.getElement("documentation", meta);
        Element pageTitle = this.getElement("pageTitle", meta);
        Element authorName = this.getElement("authorName", meta);
        target.setAttribute("uri", this.getTargetUriPattern());
        documentation.setTextContent(this.getDocumentation());
        pageTitle.setTextContent(this.getPageTitle());
        authorName.setTextContent(this.getAuthorName());
    }

    private Element getElement(String name, Node parent) {
        NodeList list = this.doc.getElementsByTagNameNS("http://www.ibm.com/xmlns/prod/AcTF/aiBrowser/selector/1.0", name);
        if (list.getLength() == 0) {
            Element temp = this.doc.createElementNS("http://www.ibm.com/xmlns/prod/AcTF/aiBrowser/selector/1.0", name);
            parent.insertBefore(temp, parent.getFirstChild());
            return temp;
        }
        return (Element)list.item(0);
    }

    private String quote(String pat, char wildCardChar) {
        StringBuffer r = new StringBuffer();
        int i = 0;
        while (i < pat.length()) {
            char c = pat.charAt(i);
            if (c == wildCardChar) {
                r.append(".*");
            } else if ("\\?*+.[]{}()$^".indexOf(c) >= 0) {
                r.append('\\');
                r.append(c);
            } else {
                r.append(c);
            }
            ++i;
        }
        return r.toString();
    }

    public boolean match(IXMLSelector selector) {
        if (this.removed) {
            return false;
        }
        if (!this.onlyInMemory) {
            return super.getSelectorInfo().match(selector);
        }
        if (!this.matchDocumentElement(selector)) {
            return false;
        }
        return this.matchURI(selector);
    }

    private boolean matchDocumentElement(IXMLSelector selector) {
        if (selector.getDocumentElementName() != null) {
            if (!this.namespaceURI.equals(selector.getDocumentElementNS())) {
                return false;
            }
            if (!this.qualifiedName.equals(selector.getDocumentElementName())) {
                return false;
            }
        }
        return true;
    }

    private boolean matchURI(IXMLSelector selector) {
        String uri = selector.getURI();
        if (uri == null) {
            return true;
        }
        Matcher m = this.uriPat.matcher(uri);
        return m.matches();
    }

    public void remove() {
        this.removed = true;
        if (!this.file.exists()) {
            return;
        }
        this.file.delete();
    }

    public void save(ZipOutputStream zos) {
        try {
            zos.putNextEntry(new ZipEntry(this.file.getName()));
            this.getRootNode();
            this.save(this.doc, zos);
            zos.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStoreException e) {
            e.printStackTrace();
        }
    }
}

