/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.impl;

import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.internal.navigator.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormSelectDialog
extends Dialog {
    ITreeItem selectItem;
    private int[] selectedIndices;
    private String[] names;
    boolean multiple;
    List list;

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.multiple) {
            newShell.setText(Messages.FormSelectDialog_Multiple);
        } else {
            newShell.setText(Messages.FormSelectDialog_Single);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 200;
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        this.list = this.multiple ? new List(container, 2562) : new List(container, 2560);
        this.list.setLayoutData((Object)gd);
        Object base = this.selectItem.getBaseNode();
        if (base instanceof Node) {
            Node node = (Node)base;
            NodeList nl = node.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node child = nl.item(i);
                if ("OPTION".equals(child.getNodeName())) {
                    Node c = child.getFirstChild();
                    String text = "";
                    if (c != null) {
                        text = c.getNodeValue();
                    }
                    this.list.add(text);
                }
                ++i;
            }
        }
        this.names = new String[this.list.getItemCount()];
        int i = 0;
        while (i < this.names.length) {
            this.names[i] = this.list.getItem(i);
            ++i;
        }
        if (this.selectedIndices != null) {
            this.list.select(this.selectedIndices);
        }
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FormSelectDialog.this.selectedIndices = FormSelectDialog.this.list.getSelectionIndices();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FormSelectDialog.this.selectedIndices = FormSelectDialog.this.list.getSelectionIndices();
            }
        });
        return container;
    }

    FormSelectDialog(Shell parent, ITreeItem item, boolean multi) {
        super(parent);
        this.selectItem = item;
        this.multiple = multi;
        this.selectedIndices = item.getSelectedIndices();
    }

    public int[] getSelectedIndices() {
        return this.selectedIndices;
    }

    public String getTextAt(int index) {
        if (index >= 0 && index < this.names.length) {
            return this.names[index];
        }
        return "";
    }

    public int getLength() {
        return this.names.length;
    }
}

