/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.audio.description;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.actf.ai.audio.description.IMetadataProvider;
import org.eclipse.actf.ai.audio.description.impl.MetadataProviderImpl;
import org.eclipse.actf.ai.audio.description.views.DescriptionView;
import org.eclipse.actf.ai.tts.AbstractUIPluginForTTS;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.ai.tts.TTSRegistry;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.IXMLStore;
import org.eclipse.actf.ai.xmlstore.IXMLStoreService;
import org.eclipse.actf.ai.xmlstore.XMLStoreServiceUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DescriptionPlugin
extends AbstractUIPluginForTTS
implements IPropertyChangeListener,
IVoiceEventListener {
    public static final String PLUGIN_ID = "org.eclipse.actf.ai.audio.description";
    public static final String PREF_ENGINE = "AudioDescriptionTTSEngine";
    private static DescriptionPlugin plugin;
    private boolean enable = true;
    private IMetadataProvider activeProvider;
    private ITTSEngine engine;
    private IVoiceEventListener listener;
    private DescriptionView view;

    public DescriptionPlugin() {
        plugin = this;
    }

    public IMetadataProvider getMetadata(String url) {
        IXMLStoreService service = XMLStoreServiceUtil.getXMLStoreService();
        IXMLStore store = service.getRootStore();
        IXMLSelector selector1 = service.getSelectorWithDocElem("puits", "urn:puits");
        System.out.println(url);
        IXMLSelector selector2 = service.getSelectorWithURI(url);
        store = store.specify(selector1);
        store = store.specify(selector2);
        ArrayList<IXMLInfo> list = new ArrayList<IXMLInfo>();
        Iterator i = store.getInfoIterator();
        while (i.hasNext()) {
            list.add((IXMLInfo)i.next());
        }
        if (list.size() == 0) {
            return null;
        }
        MetadataProviderImpl provider = new MetadataProviderImpl(list);
        if (provider != null) {
            provider.reload();
            provider.setLocale(Locale.getDefault());
            provider.prepareMetadata();
        }
        return provider;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initialize();
    }

    private void initialize() {
        this.engine = this.newTTSEngine();
        DescriptionPlugin.getDefault().addPropertyChangeListener(this);
    }

    private ITTSEngine newTTSEngine() {
        String e = DescriptionPlugin.getDefault().getPreferenceStore().getString(PREF_ENGINE);
        if (e.equals("org.eclipse.actf.ai.screenreader.jaws")) {
            return null;
        }
        ITTSEngine engine = TTSRegistry.createTTSEngine((String)e);
        if (engine != null) {
            engine.setSpeed(50);
            engine.setEventListener((IVoiceEventListener)this);
        }
        return engine;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (PREF_ENGINE.equals(event.getProperty()) && this.engine != null) {
            this.engine.stop();
            this.engine.dispose();
            this.engine = this.newTTSEngine();
        }
    }

    public ITTSEngine getTTSEngine() {
        return this.engine;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static DescriptionPlugin getDefault() {
        return plugin;
    }

    public void setDescriptionView(DescriptionView view) {
        this.view = view;
    }

    public DescriptionView getDescriptionView() {
        return this.view;
    }

    public int setEnable(boolean flag) {
        if (!this.isAvailable()) {
            this.enable = false;
            return 8;
        }
        this.enable = flag;
        this.getDescriptionView().setEnable(this.enable);
        if (this.enable) {
            return 2;
        }
        return 4;
    }

    public boolean isAvailable() {
        if (this.activeProvider == null) {
            return false;
        }
        return this.activeProvider.hasMetadata();
    }

    public boolean canSpeak() {
        return this.engine != null;
    }

    public void speak(String str, int speed, String gender) {
        if (this.engine != null) {
            this.engine.setEventListener((IVoiceEventListener)this);
            this.engine.setGender(gender);
            this.engine.setSpeed(speed);
            this.engine.speak(str, 1, -1);
        }
    }

    public void addSpeakIndex(int index) {
        if (this.engine != null) {
            this.engine.speak("", 0, index);
        }
    }

    public void setVoiceEventListener(IVoiceEventListener listener) {
        this.listener = listener;
    }

    public int toggleEnable() {
        return this.setEnable(!this.getEnable());
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void setActiveMetadataProvider(IMetadataProvider provider) {
        this.activeProvider = provider;
    }

    public static String getString(String key) {
        return Platform.getResourceString((Bundle)DescriptionPlugin.getDefault().getBundle(), (String)key);
    }

    public void indexReceived(int index) {
        if (this.listener != null) {
            this.listener.indexReceived(index);
        }
    }
}

