/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.description.views;

import org.eclipse.actf.ai.audio.description.util.TimeFormatUtil;
import org.eclipse.actf.ai.internal.audio.description.DescriptionPlugin;
import org.eclipse.actf.ai.internal.audio.description.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class VideoStatusViewer {
    private Composite parent;
    private Label status;
    private boolean enable = false;
    private String timeText;

    public VideoStatusViewer(Composite parent) {
        this.parent = parent;
        this.initialize();
    }

    public void initialize() {
        this.status = new Label(this.parent, 0);
        GridData data = new GridData(768);
        this.status.setLayoutData((Object)data);
        this.status.setAlignment(131072);
        this.setTime(0.0);
        this.enable = DescriptionPlugin.getDefault().getEnable();
    }

    public void setTime(double time) {
        this.timeText = TimeFormatUtil.getTimeString(time);
        this.refreshText();
    }

    private void refreshText() {
        if (this.status.isDisposed()) {
            return;
        }
        if (this.enable) {
            this.status.setText(String.valueOf(Messages.AudioDescription_view_enable) + " " + this.timeText);
        } else {
            this.status.setText(String.valueOf(Messages.AudioDescription_view_notEnable) + " " + this.timeText);
        }
    }

    public void setEnable(boolean b) {
        this.enable = b;
        this.refreshText();
    }
}

