/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class ValuePropertyDetailList
extends ListProperty {
    private final IValueProperty masterProperty;
    private final IListProperty detailProperty;

    public ValuePropertyDetailList(IValueProperty masterProperty, IListProperty detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    public Object getElementType() {
        return this.detailProperty.getElementType();
    }

    public IObservableList observe(Realm realm, Object source) {
        IObservableValue masterValue = this.masterProperty.observe(realm, source);
        IObservableList detailList = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose((IObservable)detailList, (IObservable)masterValue);
        return detailList;
    }

    public IObservableList observeDetail(IObservableValue master) {
        IObservableValue masterValue = this.masterProperty.observeDetail(master);
        IObservableList detailList = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose((IObservable)detailList, (IObservable)masterValue);
        return detailList;
    }

    public String toString() {
        return this.masterProperty + " => " + this.detailProperty;
    }
}

