/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.dom.dombycom.IFlashMSAANode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSAAQueryImpl {
    private static final String MSAA_QUERY_NS = "http://www.ibm.com/xmlns/prod/aiBrowser/fennec/msaa-query";
    private String[] ids;

    private MSAAQueryImpl(String[] ids) {
        this.ids = ids;
    }

    public boolean hasTarget() {
        return this.ids != null;
    }

    public List<Node> query(Node base) {
        if (this.ids == null) {
            return null;
        }
        if (!(base instanceof IFlashMSAANode)) {
            return null;
        }
        IFlashMSAANode mn = (IFlashMSAANode)base;
        ArrayList<Node> r = new ArrayList<Node>();
        int i = 0;
        while (i < this.ids.length) {
            IFlashMSAANode n = mn.searchByID(this.ids[i]);
            if (n != null) {
                r.add((Node)n);
            }
            ++i;
        }
        return r;
    }

    static MSAAQueryImpl parse(Element e, MSAAQueryImpl parentQuery) {
        String[] ids = null;
        String idrefs = e.getAttributeNS(MSAA_QUERY_NS, "idrefs");
        if (idrefs.length() > 0) {
            ids = idrefs.split("[ \r\n\t]");
        }
        return new MSAAQueryImpl(ids);
    }

    static Attr serializeQuery(Node domNode, Node usrNode) {
        if (!(domNode instanceof IFlashMSAANode)) {
            return null;
        }
        Document doc = usrNode.getOwnerDocument();
        String target = ((IFlashMSAANode)domNode).getID();
        if (target != null && target.length() > 0) {
            Attr attr = doc.createAttributeNS(MSAA_QUERY_NS, "msq:idrefs");
            attr.setNodeValue(target);
            return attr;
        }
        return null;
    }
}

