/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.query.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.model.dom.dombycom.IFlashNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashQueryImpl {
    private static final String FLASH_QUERY_NS = "http://www.ibm.com/xmlns/prod/aiBrowser/fennec/flash-query";
    private final String base;
    private final Target[] targets;
    private final boolean isFrameRangeSpecified;
    private final int frameRangeMin;
    private final int frameRangeMax;
    private final boolean isDepthSpecified;
    private final int depth;

    private FlashQueryImpl(String base, List<Target> targetList, boolean isDepthSpecified, int depth, boolean isFrameRangeSpecified, int frameRangeMin, int frameRangeMax) {
        this.base = base;
        this.targets = targetList.toArray(new Target[targetList.size()]);
        this.isDepthSpecified = isDepthSpecified;
        this.depth = depth;
        this.isFrameRangeSpecified = isFrameRangeSpecified;
        this.frameRangeMin = frameRangeMin;
        this.frameRangeMax = frameRangeMax;
    }

    public boolean hasTarget() {
        return this.targets.length > 0;
    }

    public List<Node> query(Node base) {
        if (!(base instanceof IFlashNode)) {
            return null;
        }
        IFlashNode fn = (IFlashNode)base;
        List<Node> r = new ArrayList<Node>();
        int i = 0;
        while (i < this.targets.length) {
            r = this.targets[i].query(fn, r);
            ++i;
        }
        if (this.isDepthSpecified) {
            ArrayList<IFlashNode> r2 = new ArrayList<IFlashNode>();
            for (IFlashNode iFlashNode : r) {
                IFlashNode fnd = iFlashNode.getNodeAtDepth(this.depth);
                if (fnd == null) continue;
                r2.add(fnd);
            }
            r = r2;
        }
        if (this.isFrameRangeSpecified) {
            Iterator it = r.iterator();
            while (it.hasNext()) {
                IFlashNode fn2 = (IFlashNode)it.next();
                int n = fn2.getCurrentFrame();
                if (this.frameRangeMin <= n && n < this.frameRangeMax) continue;
                it.remove();
            }
        }
        return r;
    }

    private static String computeBase(String path, String pbase) {
        char ct = path.charAt(0);
        switch (ct) {
            case '/': {
                return path.substring(1);
            }
            case '.': {
                return path;
            }
        }
        if (pbase.length() == 0 || pbase.equals(".")) {
            return path;
        }
        return String.valueOf(pbase) + "." + path;
    }

    static FlashQueryImpl parse(Element e, FlashQueryImpl parentQuery) {
        String base = e.getAttributeNS(FLASH_QUERY_NS, "base");
        String pbase = "";
        if (parentQuery != null) {
            pbase = parentQuery.base;
        }
        base = base.length() == 0 ? pbase : FlashQueryImpl.computeBase(base, pbase);
        String targetStr = e.getAttributeNS(FLASH_QUERY_NS, "targets");
        ArrayList<Target> targetList = new ArrayList<Target>();
        if (targetStr.length() > 0) {
            String[] targets = targetStr.split("[ \t\r\n]");
            int i = 0;
            while (i < targets.length) {
                if (targets[i].indexOf(42) >= 0) {
                    targetList.add(new WildCardTarget(targets[i], base));
                } else {
                    targetList.add(new SimpleTarget(FlashQueryImpl.computeBase(targets[i], base)));
                }
                ++i;
            }
        }
        String depthStr = e.getAttributeNS(FLASH_QUERY_NS, "depth");
        boolean isDepthSpecified = false;
        int depth = 0;
        if (depthStr.length() > 0) {
            try {
                depth = Integer.parseInt(depthStr.trim());
                isDepthSpecified = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        boolean isFrameRangeSpecified = false;
        int frameRangeMin = 0;
        int frameRangeMax = 0;
        String frameRangeStr = e.getAttributeNS(FLASH_QUERY_NS, "frameRange");
        if (frameRangeStr.length() > 0) {
            int pos = frameRangeStr.indexOf(45);
            try {
                if (pos < 0) {
                    int m;
                    frameRangeMin = m = Integer.parseInt(frameRangeStr.trim());
                    frameRangeMax = m + 1;
                } else {
                    frameRangeMin = Integer.parseInt(frameRangeStr.substring(0, pos).trim());
                    frameRangeMax = Integer.parseInt(frameRangeStr.substring(pos + 1).trim());
                }
                isFrameRangeSpecified = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        FlashQueryImpl q = new FlashQueryImpl(base, targetList, isDepthSpecified, depth, isFrameRangeSpecified, frameRangeMin, frameRangeMax);
        return q;
    }

    static Attr serializeQuery(Node domNode, Node usrNode) {
        if (!(domNode instanceof IFlashNode)) {
            return null;
        }
        Document doc = usrNode.getOwnerDocument();
        String target = ((IFlashNode)domNode).getTarget();
        if (target != null && target.length() > 0) {
            Attr attr = doc.createAttributeNS(FLASH_QUERY_NS, "flq:targets");
            attr.setNodeValue(target);
            return attr;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleTarget
    extends Target {
        private final String path;

        @Override
        public List<Node> query(IFlashNode fn, List<Node> l) {
            IFlashNode r = this.isRelative ? (this.path.length() > 0 ? fn.getNodeFromPath(String.valueOf(fn.getTarget()) + "." + this.path) : fn) : fn.getNodeFromPath(this.path);
            if (r != null) {
                l.add((Node)r);
            }
            return l;
        }

        SimpleTarget(String path) {
            if (path.charAt(0) == '.') {
                this.isRelative = true;
                this.path = path.substring(1);
            } else {
                this.isRelative = false;
                this.path = path;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Target {
        protected boolean isRelative;

        private Target() {
        }

        public abstract List<Node> query(IFlashNode var1, List<Node> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WildCardTarget
    extends Target {
        private List<Object> pathSegments = new ArrayList<Object>();

        private static Pattern regExpQuote(String pat, char wildCardChar) {
            StringBuffer r = new StringBuffer();
            int i = 0;
            while (i < pat.length()) {
                char c = pat.charAt(i);
                if (c == wildCardChar) {
                    r.append(".*");
                } else if ("\\?*+.[]{}()$^".indexOf(c) >= 0) {
                    r.append('\\');
                    r.append(c);
                } else {
                    r.append(c);
                }
                ++i;
            }
            return Pattern.compile(r.toString());
        }

        private boolean match(Pattern p, IFlashNode fn) {
            String target = fn.getTarget();
            int idx = target.lastIndexOf(".");
            if (idx > 0) {
                target = target.substring(idx + 1);
            }
            Matcher m = p.matcher(target);
            return m.matches();
        }

        private ArrayList<Node> queryWC(IFlashNode fn, Pattern p, ArrayList<Node> l) {
            IFlashNode[] fns = fn.getInnerNodes();
            int i = 0;
            while (i < fns.length) {
                if (this.match(p, fns[i])) {
                    l.add((Node)fns[i]);
                }
                ++i;
            }
            return l;
        }

        @Override
        public List<Node> query(IFlashNode fn, List<Node> l) {
            ArrayList<IFlashNode> cnl = new ArrayList<IFlashNode>();
            Iterator<Object> it = this.pathSegments.iterator();
            if (this.isRelative) {
                cnl.add(fn);
            } else {
                if (!it.hasNext()) {
                    return l;
                }
                Object ps = it.next();
                if (!(ps instanceof String)) {
                    return l;
                }
                IFlashNode fn2 = fn.getNodeFromPath((String)ps);
                if (fn2 == null) {
                    return l;
                }
                cnl.add(fn2);
            }
            while (it.hasNext()) {
                IFlashNode fn2;
                int i;
                ArrayList<Node> cnl2 = new ArrayList<Node>();
                Object ps = it.next();
                if (ps instanceof String) {
                    i = 0;
                    while (i < cnl.size()) {
                        fn2 = (IFlashNode)cnl.get(i);
                        if ((fn2 = fn2.getNodeFromPath(String.valueOf(fn2.getTarget()) + "." + ps)) != null) {
                            cnl2.add((Node)fn2);
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < cnl.size()) {
                        fn2 = (IFlashNode)cnl.get(i);
                        cnl2 = this.queryWC(fn2, (Pattern)ps, cnl2);
                        ++i;
                    }
                }
                cnl = cnl2;
                if (cnl.size() != 0) continue;
                return l;
            }
            l.addAll(cnl);
            return l;
        }

        WildCardTarget(String target, String base) {
            char ct = target.charAt(0);
            switch (ct) {
                case '/': {
                    this.isRelative = false;
                    target = target.substring(1);
                    break;
                }
                case '.': {
                    this.isRelative = true;
                    target = target.substring(1);
                    break;
                }
                default: {
                    this.isRelative = false;
                    target = String.valueOf(base) + "." + target;
                }
            }
            StringBuffer buf = new StringBuffer();
            String[] segs = target.split("\\.");
            int i = 0;
            while (i < segs.length) {
                if (segs[i].indexOf(42) >= 0) {
                    if (buf.length() > 0) {
                        this.pathSegments.add(buf.toString());
                        buf.setLength(0);
                    }
                    this.pathSegments.add(WildCardTarget.regExpQuote(segs[i], '*'));
                } else {
                    if (buf.length() > 0) {
                        buf.append(".");
                    }
                    buf.append(segs[i]);
                }
                ++i;
            }
            if (buf.length() > 0) {
                this.pathSegments.add(buf.toString());
            }
        }
    }
}

