/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableHelper;
import org.eclipse.core.runtime.Assert;

public class DetailObservableList
extends ObservableList
implements IObserving {
    private boolean updating = false;
    private IListChangeListener innerChangeListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            if (!DetailObservableList.this.updating) {
                DetailObservableList.this.fireListChange(event.diff);
            }
        }
    };
    private Object currentOuterValue;
    private IObservableList innerObservableList;
    private IObservableFactory factory;
    private IObservableValue outerObservableValue;
    private Object detailType;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            ObservableTracker.runAndIgnore(new Runnable(this){
                final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    ArrayList<E> oldList = new ArrayList<E>(DetailObservableList.access$2(2.access$0(this.this$1)));
                    DetailObservableList.access$3(2.access$0(this.this$1));
                    DetailObservableList.access$1(2.access$0(this.this$1), Diffs.computeListDiff(oldList, DetailObservableList.access$2(2.access$0(this.this$1))));
                }
            });
        }

        static /* synthetic */ DetailObservableList access$0(2 var0) {
            return var0.DetailObservableList.this;
        }
    };

    public DetailObservableList(IObservableFactory factory, IObservableValue outerObservableValue, Object detailType) {
        super(outerObservableValue.getRealm(), Collections.EMPTY_LIST, detailType);
        Assert.isTrue((!outerObservableValue.isDisposed() ? 1 : 0) != 0, (String)"Master observable is disposed");
        this.factory = factory;
        this.outerObservableValue = outerObservableValue;
        this.detailType = detailType;
        outerObservableValue.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent staleEvent) {
                DetailObservableList.this.dispose();
            }
        });
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                DetailObservableList.this.updateInnerObservableList();
            }
        });
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableList() {
        if (this.innerObservableList != null) {
            this.innerObservableList.removeListChangeListener(this.innerChangeListener);
            this.innerObservableList.dispose();
        }
        this.currentOuterValue = this.outerObservableValue.getValue();
        if (this.currentOuterValue == null) {
            this.innerObservableList = null;
            this.wrappedList = Collections.EMPTY_LIST;
        } else {
            ObservableTracker.runAndIgnore(new Runnable(){

                public void run() {
                    DetailObservableList.this.innerObservableList = (IObservableList)DetailObservableList.this.factory.createObservable(DetailObservableList.this.currentOuterValue);
                }
            });
            DetailObservableHelper.warnIfDifferentRealms(this.getRealm(), this.innerObservableList.getRealm());
            this.wrappedList = this.innerObservableList;
            if (this.detailType != null) {
                Object innerValueType = this.innerObservableList.getElementType();
                Assert.isTrue((boolean)this.getElementType().equals(innerValueType), (String)"Cannot change value type in a nested observable list");
            }
            this.innerObservableList.addListChangeListener(this.innerChangeListener);
        }
    }

    public boolean add(final Object o) {
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableList.this.wrappedList.add(o);
            }
        });
        return result[0];
    }

    public void add(final int index, final Object element) {
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                DetailObservableList.this.wrappedList.add(index, element);
            }
        });
    }

    public boolean remove(final Object o) {
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableList.this.wrappedList.remove(o);
            }
        });
        return result[0];
    }

    public Object set(final int index, final Object element) {
        final Object[] result = new Object[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableList.this.wrappedList.set(index, element);
            }
        });
        return result[0];
    }

    public Object move(final int oldIndex, final int newIndex) {
        if (this.innerObservableList != null) {
            final Object[] result = new Object[1];
            ObservableTracker.runAndIgnore(new Runnable(){

                public void run() {
                    result[0] = DetailObservableList.this.innerObservableList.move(oldIndex, newIndex);
                }
            });
            return result[0];
        }
        return super.move(oldIndex, newIndex);
    }

    public Object remove(final int index) {
        final Object[] result = new Object[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableList.this.wrappedList.remove(index);
            }
        });
        return result[0];
    }

    public boolean addAll(final Collection c) {
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableList.this.wrappedList.addAll(c);
            }
        });
        return result[0];
    }

    public boolean addAll(final int index, final Collection c) {
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableList.this.wrappedList.addAll(index, c);
            }
        });
        return result[0];
    }

    public boolean removeAll(final Collection c) {
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableList.this.wrappedList.removeAll(c);
            }
        });
        return result[0];
    }

    public boolean retainAll(final Collection c) {
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableList.this.wrappedList.retainAll(c);
            }
        });
        return result[0];
    }

    public void clear() {
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                DetailObservableList.this.wrappedList.clear();
            }
        });
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
        }
        if (this.innerObservableList != null) {
            this.innerObservableList.removeListChangeListener(this.innerChangeListener);
            this.innerObservableList.dispose();
        }
        this.outerObservableValue = null;
        this.outerChangeListener = null;
        this.currentOuterValue = null;
        this.factory = null;
        this.innerObservableList = null;
        this.innerChangeListener = null;
    }

    public Object getObserved() {
        if (this.innerObservableList instanceof IObserving) {
            return ((IObserving)((Object)this.innerObservableList)).getObserved();
        }
        return null;
    }
}

