/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.ArrayList;
import org.eclipse.actf.ai.fennec.impl.FennecGeneratedMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMetadata;
import org.eclipse.actf.ai.fennec.impl.TreeItemFennec;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.util.vocab.DelegationTerms;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeItemTerms
extends DelegationTerms {
    public TreeItemTerms(IEvalTarget delegationTarget) {
        super(delegationTarget);
    }

    private boolean isSymbol(char c) {
        int type = Character.getType(c);
        return type == 28 || type == 27 || type == 25;
    }

    private boolean isSeparator(char c) {
        switch (Character.getType(c)) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private boolean isPunctuation(char c) {
        int type = Character.getType(c);
        return type == 23 || type == 20 || type == 21 || type == 22 || type == 29 || type == 30 || type == 24;
    }

    private ContentCheckResult contentCommonCheck(ITreeItem item) {
        Object baseNode = item.getBaseNode();
        if (baseNode instanceof IEvalTarget && Vocabulary.hasContent().eval((IEvalTarget)baseNode)) {
            return ContentCheckResult.TRUE;
        }
        if (!this.isVisibleNode(item)) {
            return ContentCheckResult.FALSE;
        }
        if (Vocabulary.isSelectOption().eval((IEvalTarget)item)) {
            return ContentCheckResult.FALSE;
        }
        return ContentCheckResult.UNKNOWN;
    }

    public boolean hasContent(IEvalTarget target) {
        if (!(target instanceof ITreeItem)) {
            return false;
        }
        ITreeItem item = (ITreeItem)target;
        switch (this.contentCommonCheck(item)) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        String str = item.getUIString();
        return str.length() != 0;
    }

    public boolean hasReadingContent(IEvalTarget target) {
        if (!(target instanceof ITreeItem)) {
            return false;
        }
        ITreeItem item = (ITreeItem)target;
        switch (this.contentCommonCheck(item)) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        String str = item.getUIString();
        if (str.length() == 0) {
            return false;
        }
        if (Vocabulary.isLink().eval((IEvalTarget)item)) {
            return true;
        }
        int i = 0;
        while (i < str.length()) {
            if (!(this.isSeparator(str.charAt(i)) || this.isPunctuation(str.charAt(i)) || this.isSymbol(str.charAt(i)))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isVisibleNode(IEvalTarget target) {
        return true;
    }

    public boolean isBlockJumpPointF(IEvalTarget node) {
        return this.isBlockJumpPoint(false, node);
    }

    public boolean isBlockJumpPointB(IEvalTarget node) {
        return this.isBlockJumpPoint(true, node);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isBlockJumpPoint(boolean back, IEvalTarget node) {
        block20: {
            block21: {
                block19: {
                    if (!(node instanceof TreeItemFennec)) {
                        return false;
                    }
                    item = (TreeItemFennec)node;
                    if (back) break block19;
                    if (item.getNth() > 0) {
                        prev = (TreeItemFennec)item.getParent().getChildItems()[item.getNth() - 1];
                        while (prev.hasChild()) {
                            items = prev.getChildItems();
                            prev = (TreeItemFennec)items[items.length - 1];
                        }
                    } else {
                        prev = (TreeItemFennec)item.getParent();
                    }
                    break block20;
                }
                if (item.getNth() != item.getParent().getChildItems().length - 1) break block21;
                parent = item.getParent();
                if (parent != null) ** GOTO lbl21
                return false;
lbl-1000:
                // 1 sources

                {
                    if ((parent = parent.getParent()) != null) continue;
                    return false;
lbl21:
                    // 2 sources

                    ** while (parent.getNth() == parent.getParent().getChildItems().length - 1)
                }
lbl22:
                // 1 sources

                prev = (TreeItemFennec)parent.getParent().getChildItems()[parent.getNth() + 1];
                break block20;
            }
            prev = item.hasChild() != false ? (TreeItemFennec)item.getChildItems()[0] : (TreeItemFennec)item.getParent().getChildItems()[item.getNth() + 1];
        }
        if (prev == null) {
            return false;
        }
        item.distance = prev.distance + 1;
        prev.distance = 0;
        if (!(item.getBaseNode() instanceof INodeEx)) {
            return false;
        }
        if (!(prev.getBaseNode() instanceof INodeEx)) {
            return false;
        }
        nex = (INodeEx)item.getBaseNode();
        nex2 = (INodeEx)prev.getBaseNode();
        if (nex == null || nex2 == null) {
            return false;
        }
        r = nex.getLocation();
        r2 = nex2.getLocation();
        if (r == null || r2 == null) {
            return false;
        }
        dist = this.distance(r, r2);
        item.distance += dist;
        if (r.width < 20) {
            return false;
        }
        if (!Vocabulary.hasContent().eval(node)) {
            return false;
        }
        if (!Vocabulary.hasReadingContent().eval(node)) {
            return false;
        }
        if (Vocabulary.isClickable().eval(node)) {
            return false;
        }
        if (item.getNth() > 2 && Vocabulary.isConnectable().eval(node)) {
            return false;
        }
        if (item.distance > 800) {
            item.distance = 0;
            return true;
        }
        if (!back && !super.isBlockJumpPointF(node)) {
            return false;
        }
        if (back && !super.isBlockJumpPointB(node)) {
            return false;
        }
        if (item.distance > 200) {
            item.distance = 0;
            return true;
        }
        return false;
    }

    private int distance(Rectangle r, Rectangle r2) {
        return (int)Math.sqrt(Math.abs(r.x - r2.x) * Math.abs(r.y - r2.y)) + Math.abs(r.x - r2.x) + Math.abs(r.y - r2.y);
    }

    public boolean isHeading(int level, IEvalTarget node) {
        if (!(node instanceof ITreeItem)) {
            return false;
        }
        ITreeItem item = (ITreeItem)node;
        if (level == 0) {
            return item.getHeadingLevel() > 0;
        }
        return item.getHeadingLevel() == level;
    }

    public boolean isHeadingJumpPoint(IEvalTarget node) {
        ITreeItem item;
        if (!(node instanceof ITreeItem)) {
            return false;
        }
        ITreeItem current = item = (ITreeItem)node;
        short r = 0;
        do {
            if (current == null) {
                return super.isHeadingJumpPoint(node);
            }
            FennecMetadata meta = ((TreeItemFennec)current).getMetadata();
            if (!(meta instanceof FennecGeneratedMetadata)) break;
            r = ((FennecGeneratedMetadata)meta).getHeadingLevelByMetadata(item);
            if (r > 0) {
                return true;
            }
            if (r == -1) {
                return false;
            }
            current = current.getParent();
        } while (r == 0);
        if (((TreeItemFennec)item).getMetadata() == null) {
            return false;
        }
        return ((TreeItemFennec)item).getMetadata().getHeadingLevel(item) > 0;
    }

    public boolean isConnectable(IEvalTarget node) {
        if (!(node instanceof TreeItemFennec)) {
            return false;
        }
        TreeItemFennec item = (TreeItemFennec)node;
        if (item.hasChild()) {
            return false;
        }
        int nth = item.getNth();
        int nextNth = nth + 1;
        ITreeItem parent = ((TreeItemFennec)node).getParent();
        if (parent == null) {
            return false;
        }
        ITreeItem[] items = parent.getChildItems();
        if (nextNth >= items.length) {
            return false;
        }
        Object o = items[nextNth].getBaseNode();
        if (o == null || !(o instanceof Node)) {
            return false;
        }
        Node n = (Node)o;
        return Vocabulary.isReachable((Node)n).eval(node);
    }

    public boolean find(String str, boolean exact, IEvalTarget node) {
        if (!(node instanceof ITreeItem)) {
            return false;
        }
        ITreeItem item = (ITreeItem)node;
        String uiString = item.getUIString();
        if (!exact) {
            uiString = uiString.toLowerCase();
            str = str.toLowerCase();
        }
        return uiString.indexOf(str) != -1;
    }

    public boolean startsWith(String str, boolean exact, IEvalTarget node) {
        if (!(node instanceof TreeItemFennec)) {
            return false;
        }
        TreeItemFennec item = (TreeItemFennec)node;
        String uiString = item.getUIString();
        if (!exact) {
            uiString = uiString.toLowerCase();
            str = str.toLowerCase();
        }
        if (uiString.length() < str.length() && str.startsWith(uiString)) {
            int len = uiString.length();
            if (item.hasChild()) {
                return Vocabulary.startsWith((String)str.substring(len), (boolean)exact).eval((IEvalTarget)item.getChildItems()[0]);
            }
            int nth = item.getNth();
            ITreeItem parent = item.getParent();
            while (parent != null) {
                ITreeItem[] items = parent.getChildItems();
                if (nth + 1 < items.length) {
                    return Vocabulary.startsWith((String)str.substring(len), (boolean)exact).eval((IEvalTarget)items[nth + 1]);
                }
                nth = parent.getNth();
                parent = parent.getParent();
            }
        }
        return uiString.startsWith(str);
    }

    public boolean nodeLocation(Node refNode, boolean backward, IEvalTarget node) {
        if (!Vocabulary.hasContent().eval(node)) {
            return false;
        }
        if (!(node instanceof TreeItemFennec)) {
            return false;
        }
        TreeItemFennec item = (TreeItemFennec)node;
        Node targetNode = item.getNearestNode();
        if (targetNode == null) {
            return false;
        }
        ArrayList<Node> refAncestors = this.getAncestors(refNode);
        ArrayList<Node> ancestors = this.getAncestors(targetNode);
        int i = refAncestors.size() - 1;
        int j = ancestors.size() - 1;
        while (i >= 0 && j >= 0) {
            Node refAncestor = refAncestors.get(i);
            Node ancestor = ancestors.get(j);
            if (!ancestor.isSameNode(refAncestor)) {
                int refAncestorNth;
                if (!(ancestor instanceof INodeEx) && refAncestor instanceof INodeEx) {
                    return false;
                }
                int ancestorNth = ((INodeEx)ancestor).getNth();
                if (ancestorNth == (refAncestorNth = ((INodeEx)refAncestor).getNth())) {
                    return true;
                }
                if (backward) {
                    return ancestorNth < refAncestorNth;
                }
                return ancestorNth > refAncestorNth;
            }
            --i;
            --j;
        }
        return true;
    }

    private ArrayList<Node> getAncestors(Node n) {
        ArrayList<Node> list = new ArrayList<Node>();
        while (n != null) {
            list.add(n);
            n = n.getParentNode();
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContentCheckResult {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

