/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.ai.fennec.IFennecEntry;
import org.eclipse.actf.ai.fennec.impl.FennecEntryImpl;
import org.eclipse.actf.ai.fennec.impl.FennecGroupMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMode;
import org.eclipse.actf.ai.fennec.impl.FennecRecombinantMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecServiceImpl;
import org.eclipse.actf.ai.fennec.impl.FennecSimpleMetadata;
import org.eclipse.actf.ai.query.IQuery;
import org.eclipse.actf.ai.query.QueryService;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FennecDOMReader {
    public static final String Fennec_NAMESPACE_URI = "http://www.ibm.com/xmlns/prod/aiBrowser/fennec";
    public static final String Fennec_DOCUMENT_ELEMENT_NAME = "fennec";
    private FennecServiceImpl fennecService;

    private void error(String message) {
        System.err.println(message);
    }

    private IQuery parseQuery(Element e, IQuery parentQuery) {
        return QueryService.parse((Element)e, (IQuery)parentQuery);
    }

    private FennecMetadata parseNode(FennecMode mode, Element e, IQuery parentQuery) {
        NodeList nl = e.getChildNodes();
        IQuery q = this.parseQuery(e, parentQuery);
        if (q != null) {
            parentQuery = q;
        }
        FennecMetadata[] mds = this.parseInternal(mode, nl, parentQuery);
        return new FennecGroupMetadata(this.fennecService, q, mode, mds);
    }

    private FennecMetadata parseHeader(FennecMode mode, Element e, short level, IQuery parentQuery) {
        return FennecSimpleMetadata.newHeader(this.fennecService, null, mode, level);
    }

    private List parseTextFormat(Element e, IQuery parentQuery) {
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        if (len == 0) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while (i < len) {
            Node n = nl.item(i);
            switch (n.getNodeType()) {
                case 3: {
                    al.add(n.getNodeValue());
                    break;
                }
                case 1: {
                    Element ce = (Element)n;
                    if ("ref".equals(ce.getLocalName())) {
                        IQuery q = this.parseQuery((Element)n, parentQuery);
                        al.add((String)q);
                        break;
                    }
                    this.error("Invalid element in text format:" + n.getNodeName());
                }
            }
            ++i;
        }
        return al;
    }

    private FennecMetadata parseAltText(FennecMode mode, Element e, IQuery parentQuery) {
        IQuery q = this.parseQuery(e, parentQuery);
        if (q != null) {
            parentQuery = q;
        }
        List l = this.parseTextFormat(e, parentQuery);
        return FennecSimpleMetadata.newAltText(this.fennecService, q, mode, l);
    }

    private FennecMetadata parseDescription(FennecMode mode, Element e, IQuery parentQuery) {
        IQuery q = this.parseQuery(e, parentQuery);
        if (q != null) {
            parentQuery = q;
        }
        List l = this.parseTextFormat(e, parentQuery);
        return FennecSimpleMetadata.newDescription(this.fennecService, mode, q, l);
    }

    private boolean parseBoolean(String str) {
        String str2 = str.trim();
        if (str2.equals("0")) {
            return false;
        }
        if (str2.equals("false")) {
            return false;
        }
        if (str2.equals("1")) {
            return true;
        }
        if (str2.equals("true")) {
            return true;
        }
        this.error("Invalide boolean value:" + str2);
        return false;
    }

    private int parseTrigger(String str) {
        String str2 = str.trim();
        if ("always".equals(str2)) {
            return 23;
        }
        if ("move".equals(str2)) {
            return 1;
        }
        if ("click".equals(str2)) {
            return 2;
        }
        if (str.length() == 0) {
            return 23;
        }
        this.error("Invalid trigger attribute:" + str2);
        return 1;
    }

    private FennecMetadata parseInternalForElement(FennecMode mode, Element e, IQuery parentQuery) {
        String name = e.getLocalName();
        if (name.equals("node")) {
            return this.parseNode(mode, e, parentQuery);
        }
        if (!(name.equals("table") || name.equals("ul") || name.equals("ol"))) {
            if (name.equals("h-")) {
                return this.parseHeader(mode, e, (short)-1, parentQuery);
            }
            if (name.equals("h1")) {
                return this.parseHeader(mode, e, (short)1, parentQuery);
            }
            if (name.equals("h2")) {
                return this.parseHeader(mode, e, (short)2, parentQuery);
            }
            if (name.equals("h3")) {
                return this.parseHeader(mode, e, (short)3, parentQuery);
            }
            if (name.equals("h4")) {
                return this.parseHeader(mode, e, (short)4, parentQuery);
            }
            if (name.equals("h5")) {
                return this.parseHeader(mode, e, (short)5, parentQuery);
            }
            if (name.equals("h6")) {
                return this.parseHeader(mode, e, (short)6, parentQuery);
            }
            if (name.equals("altText")) {
                return this.parseAltText(mode, e, parentQuery);
            }
            if (name.equals("description")) {
                return this.parseDescription(mode, e, parentQuery);
            }
            if (!name.equals("metadata") && !name.equals("keyDescription")) {
                if (name.equals("attach")) {
                    NodeList nl = e.getChildNodes();
                    IQuery q = this.parseQuery(e, parentQuery);
                    String triggerStr = e.getAttributeNS(null, "trigger");
                    int trigger = this.parseTrigger(triggerStr);
                    String autoStr = e.getAttributeNS(null, "auto");
                    boolean auto = autoStr.length() == 0 ? true : this.parseBoolean(autoStr);
                    String changelessStr = e.getAttributeNS(null, "changeless");
                    boolean changeless = changelessStr.length() == 0 ? false : this.parseBoolean(changelessStr);
                    String waitContentsStr = e.getAttributeNS(null, "waitContents");
                    boolean waitContents = waitContentsStr.length() == 0 ? false : this.parseBoolean(waitContentsStr);
                    FennecMode nextMode = new FennecMode(1, trigger, auto, changeless, waitContents);
                    FennecMetadata[] mds = this.parseInternal(nextMode, nl, q);
                    return FennecRecombinantMetadata.newAttach(this.fennecService, q, mode, nextMode, mds);
                }
                if (name.equals("unwrap")) {
                    NodeList nl = e.getChildNodes();
                    IQuery q = this.parseQuery(e, parentQuery);
                    String triggerStr = e.getAttributeNS(null, "trigger");
                    int trigger = this.parseTrigger(triggerStr);
                    FennecMode nextMode = new FennecMode(2, trigger, false, false, false);
                    FennecMetadata[] mds = this.parseInternal(nextMode, nl, q);
                    return FennecRecombinantMetadata.newUnwrap(this.fennecService, q, mode, nextMode, mds);
                }
            }
        }
        return null;
    }

    private FennecMetadata[] parseInternal(FennecMode mode, NodeList nl, IQuery parentQuery) {
        ArrayList<FennecMetadata> al = new ArrayList<FennecMetadata>();
        int len = nl.getLength();
        int i = 0;
        while (i < len) {
            Element e;
            FennecMetadata md;
            String ns;
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && (ns = n.getNamespaceURI()).equals(Fennec_NAMESPACE_URI) && (md = this.parseInternalForElement(mode, e = (Element)n, parentQuery)) != null) {
                al.add(md);
            }
            ++i;
        }
        return al.toArray(new FennecMetadata[0]);
    }

    private FennecMetadata parseTop(Element e) {
        String namespaceURI = e.getNamespaceURI();
        if (!namespaceURI.equals(Fennec_NAMESPACE_URI)) {
            this.error("The namespace URI of the document element must be http://www.ibm.com/xmlns/prod/aiBrowser/fennec");
            return null;
        }
        String localName = e.getLocalName();
        if (!Fennec_DOCUMENT_ELEMENT_NAME.equals(localName)) {
            this.error("The document element is not fennec");
        }
        FennecMode rootMode = new FennecMode(0);
        IQuery q = this.parseQuery(e, null);
        FennecMetadata[] mds = this.parseInternal(rootMode, e.getChildNodes(), q);
        if (mds.length == 0) {
            return null;
        }
        return new FennecGroupMetadata(this.fennecService, q, rootMode, mds);
    }

    public FennecMetadata parse(IFennecEntry entry) throws XMLStoreException {
        Element e;
        FennecEntryImpl ei = (FennecEntryImpl)entry;
        IXMLInfo info = ei.getIXMLInfo();
        Node n = info.getRootNode();
        if (n instanceof Document) {
            e = ((Document)n).getDocumentElement();
        } else if (n instanceof Element) {
            e = (Element)n;
        } else {
            throw new XMLStoreException("Failed to load Fennec.", null);
        }
        return this.parseTop(e);
    }

    FennecDOMReader(FennecServiceImpl fennecService) {
        this.fennecService = fennecService;
    }
}

