/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.errorhandler;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.html.parser.HTMLParser;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLDocument;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RangeExpander
implements IErrorHandler {
    public boolean handleError(int code, IParser parser, Node errorNode) throws ParseException, IOException, SAXException {
        if (code != 6 || !(errorNode instanceof EndTag)) {
            return false;
        }
        Vector<Element> elementsToBeInserted = new Vector<Element>();
        Node node = parser.getContext();
        while (node instanceof Element) {
            String tagName = node.getNodeName();
            if (tagName.equalsIgnoreCase(errorNode.getNodeName())) {
                parser.setContext((Element)node.getParentNode());
                Enumeration e = elementsToBeInserted.elements();
                while (e.hasMoreElements()) {
                    Element el = (Element)e.nextElement();
                    parser.getContext().appendChild(el);
                    parser.setContext(el);
                }
                return true;
            }
            elementsToBeInserted.addElement(parser.getDocument().createElement(tagName));
            node = node.getParentNode();
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            HTMLParser parser = new HTMLParser();
            parser.addErrorLogListener(new IErrorLogListener(){

                public void errorLog(int code, String msg) {
                    System.err.println(msg);
                }
            });
            parser.setErrorHandler(new RangeExpander());
            parser.parse(new FileInputStream(args[0]));
            ((ISGMLDocument)parser.getDocument()).printAsSGML(new PrintWriter(System.out), false);
        }
        catch (Exception exception) {}
    }
}

