/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.internal.flash.proxy.ProxyManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ProxyPlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    private static ProxyPlugin plugin;
    private static ProxyManager proxyManager;
    private List<IPropertyChangeListener> listeners;
    public static final ImageDescriptor IMAGE_CLEAR;

    static {
        proxyManager = new ProxyManager();
        IMAGE_CLEAR = ProxyPlugin.getImageDescriptor("icons/action16/clear.gif");
    }

    public ProxyPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("ProxyType".equals(event.getProperty()) || "ProxySWFMethod".equals(event.getProperty()) || "SWFMinimumVersion".equals(event.getProperty()) || "Timeout".equals(event.getProperty()) || "PROXY_PORT".equals(event.getProperty())) {
                    ProxyPlugin.this.setProxySettings();
                }
            }
        });
        ProxyPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ProxyPlugin.this.setProxySettings();
            }
        });
    }

    private void setProxySettings() {
        proxyManager.stopProxy();
        String proxyType = this.getPreferenceStore().getString("ProxyType");
        int swfVersion = this.getPreferenceStore().getInt("SWFMinimumVersion");
        int timeout = this.getPreferenceStore().getInt("Timeout");
        int port = this.getPreferenceStore().getInt("PROXY_PORT");
        if (!"PROXY_NONE".equals(proxyType)) {
            String proxySwfMethod = this.getPreferenceStore().getString("ProxySWFMethod");
            boolean swfBootLoader = false;
            boolean swfTranscoder = false;
            if ("PROXY_SWF_METHOD_BOOTLOADER".equals(proxySwfMethod)) {
                swfBootLoader = true;
            } else if ("PROXY_SWF_METHOD_TRANSCODER".equals(proxySwfMethod)) {
                swfTranscoder = true;
            }
            proxyManager.startProxy(port, swfVersion, timeout * 1000, swfBootLoader, swfTranscoder);
        }
        proxyManager.setInternetOptions("PROXY_GLOBAL".equals(proxyType));
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        proxyManager.dispose();
        this.listeners = null;
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        plugin = null;
    }

    public static ProxyPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.model.flash.proxy", (String)path);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).propertyChange(event);
            ++i;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertyChangeListener>();
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }
}

