/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.services;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Qualifier;

public interface TaskingHeadlessLifeCycle
extends Comparable<TaskingHeadlessLifeCycle> {
    @Override
    default public int compareTo(TaskingHeadlessLifeCycle o) {
        int pA;
        HeadlessPrority prioA = this.getClass().getAnnotation(HeadlessPrority.class);
        HeadlessPrority prioB = o.getClass().getAnnotation(HeadlessPrority.class);
        int pB = prioB == null ? 1000 : prioB.value();
        int x = pB - (pA = prioA == null ? 1000 : prioA.value());
        if (x != 0) {
            return x;
        }
        return this.getClass().getSimpleName().compareTo(o.getClass().getSimpleName());
    }

    @Documented
    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HeadlessPrority {
        public int value() default 1000;
    }

    @Documented
    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface HeadlessShutdown {
    }

    @Documented
    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface HeadlessStartup {
    }

    public static enum StartupAction {
        CONTINUE,
        RESTART;

    }
}

