/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.ease.internal;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.IScriptModule;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tea.core.TaskingEngine;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.core.ui.TaskingEngineJob;
import org.eclipse.tea.core.ui.config.TaskingEclipsePreferenceStore;
import org.eclipse.tea.ease.internal.EaseTaskChainWrapper;

public class TeaModule
implements IScriptModule {
    private IScriptEngine scriptEngine;
    private TaskingEngine taskEngine;

    public void initialize(IScriptEngine engine, IEnvironment environment) {
        this.scriptEngine = engine;
        this.taskEngine = TaskingEngine.withConfiguration((TaskingConfigurationStore)new TaskingEclipsePreferenceStore());
        TaskingLog log = (TaskingLog)this.taskEngine.getContext().get(TaskingLog.class);
        engine.setErrorStream((OutputStream)log.error());
        engine.setOutputStream((OutputStream)log.info());
        engine.setCloseStreamsOnTerminate(false);
    }

    @WrapToScript
    public IStatus runTaskChain(Object chain) throws Exception {
        TaskingEngineJob[] result = new TaskingEngineJob[1];
        Display.getDefault().syncExec(() -> {
            taskingEngineJobArray[0] = new TaskingEngineJob(this.taskEngine, chain);
        });
        TaskingEngineJob job = result[0];
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return job.getActualResult();
    }

    @WrapToScript
    public TaskChain createTaskChain(String name, Object[] tasks) {
        return new EaseTaskChainWrapper(name, this.scriptEngine, new ArrayList<Object>(Arrays.asList(tasks)));
    }

    @WrapToScript
    public TaskChain createTaskChainFrom(String name, String template) {
        TaskChain chain = this.lookupTaskChain(template);
        EaseTaskChainWrapper wrapper = new EaseTaskChainWrapper(name, this.scriptEngine, new ArrayList<Object>());
        wrapper.addTask(chain);
        return wrapper;
    }

    @WrapToScript
    public TaskChain lookupTaskChain(String nameOrAlias) {
        IEclipseContext lookup = this.taskEngine.getContext().createChild();
        lookup.set("org.eclipse.tea.core.taskchain", (Object)nameOrAlias);
        TaskChain chain = (TaskChain)lookup.get(TaskChain.class);
        return chain;
    }

    @WrapToScript
    public IEclipseContext getContext() {
        return this.taskEngine.getContext().getActiveLeaf();
    }

    @WrapToScript
    public TaskingLog getLog() {
        return (TaskingLog)this.getContext().get(TaskingLog.class);
    }
}

