/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.core.FragmentDocument;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.internal.r.ui.FCallNamePattern;
import org.eclipse.statet.internal.r.ui.editors.RElementCompletionProposal;
import org.eclipse.statet.internal.r.ui.editors.RHelpTopicCompletionProposal;
import org.eclipse.statet.internal.r.ui.editors.RPkgCompletionProposal;
import org.eclipse.statet.internal.r.ui.editors.RSimpleCompletionProposal;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RSearchPattern;
import org.eclipse.statet.r.core.RSymbolComparator;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.rmodel.Parameters;
import org.eclipse.statet.r.core.rmodel.RCoreFunctions;
import org.eclipse.statet.r.core.rmodel.RElement;
import org.eclipse.statet.r.core.rmodel.RElementAccess;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RFrame;
import org.eclipse.statet.r.core.rmodel.RLangElement;
import org.eclipse.statet.r.core.rmodel.RLangMethod;
import org.eclipse.statet.r.core.rmodel.RModel;
import org.eclipse.statet.r.core.rmodel.RSourceFrame;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.statet.r.ui.sourceediting.RFrameSearchPath;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RHelpTopicEntry;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RPkgBuilt;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;

@NonNullByDefault
public class RElementCompletionComputer
implements ContentAssistComputer {
    private static final PartitionConstraint NO_R_COMMENT_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String partitionType) {
            return partitionType != "R.Comment";
        }
    };
    private static final ImList<String> fgKeywords;
    protected static final int NA_PRIO = Integer.MIN_VALUE;
    protected static final int ARG_NAME_PRIO = 80;
    protected static final int ARG_TYPE_PRIO = 40;
    protected static final int ARG_TYPE_NO_PRIO = -40;
    private final ElementLabelProvider labelProvider = new RLabelProvider(1);
    private final int mode;
    private int searchMatchRules;
    private final RFrameSearchPath searchPath = new RFrameSearchPath();
    private boolean inDefault;
    private boolean inString;
    private int pkgNamePrio;
    private int helpTopicPrio;

    static {
        ArrayList list = new ArrayList();
        Collections.addAll(list, RTokens.CONSTANT_WORDS);
        Collections.addAll(list, RTokens.FLOWCONTROL_WORDS);
        fgKeywords = ImCollections.toList(list, (Comparator)RSymbolComparator.R_NAMES_COLLATOR);
    }

    protected RElementCompletionComputer(int mode) {
        this.mode = mode;
    }

    public RElementCompletionComputer() {
        this(0);
    }

    public void onSessionStarted(SourceEditor editor, ContentAssist assist) {
        int matchRules = 4;
        if (assist.getShowSubstringMatches()) {
            matchRules |= 0x10;
        }
        this.searchMatchRules = matchRules;
    }

    public void onSessionEnded() {
        this.searchPath.clear();
    }

    protected final int getSearchMode(RAssistInvocationContext context) {
        if (this.mode != 0) {
            return this.mode;
        }
        return context.getDefaultRFrameSearchMode();
    }

    protected int getSearchMatchRules() {
        return this.searchMatchRules;
    }

    protected final boolean isSymbolCandidate(String name) {
        int i = 0;
        while (i < name.length()) {
            if (RTokens.isRobustSeparator((int)name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isCompletable(@Nullable RElementName elementName) {
        if (elementName == null) {
            return false;
        }
        do {
            switch (elementName.getType()) {
                case 27: 
                case 28: {
                    return false;
                }
            }
            if (elementName.getSegmentName() != null) continue;
            return false;
        } while ((elementName = elementName.getNextSegment()) != null);
        return true;
    }

    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context instanceof RAssistInvocationContext) {
            this.computeCompletionProposals((RAssistInvocationContext)context, mode, proposals, monitor);
        }
    }

    public void computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context instanceof RAssistInvocationContext) {
            this.doComputeContextProposals((RAssistInvocationContext)context, proposals, monitor);
        }
    }

    protected void computeCompletionProposals(RAssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context.getModelInfo() == null) {
            return;
        }
        RAstNode node = context.getInvocationRAstNode();
        RElementName prefixName = context.getIdentifierElementName();
        if (prefixName == null) {
            return;
        }
        this.inString = context.getInvocationContentType() == "R.String";
        this.inDefault = !this.inString;
        this.pkgNamePrio = Integer.MIN_VALUE;
        this.helpTopicPrio = Integer.MIN_VALUE;
        if (prefixName.getNextSegment() == null) {
            String help = this.checkHelp(context);
            if (help != null) {
                this.doComputeHelpTopicProposals(context, help, node, 40, proposals);
                if (prefixName.getScope() == null) {
                    this.doComputePkgNameProposals(context, -40, proposals);
                }
                return;
            }
            this.doComputeArgumentProposals(context, proposals, monitor);
            if (this.inDefault) {
                this.doComputeMainProposals(context, node, proposals, monitor);
            }
            if (this.mode == 0 && this.inDefault) {
                this.doComputeKeywordProposals(context, proposals, monitor);
            }
            if (this.mode == 0) {
                if (this.isPackageName(prefixName)) {
                    if (this.pkgNamePrio > 0) {
                        this.doComputePkgNameProposals(context, this.pkgNamePrio, proposals);
                    } else if (!prefixName.getSegmentName().isEmpty()) {
                        this.doComputePkgNameProposals(context, -40, proposals);
                    }
                }
                if (this.helpTopicPrio > 0) {
                    this.doComputeHelpTopicProposals(context, null, node, this.helpTopicPrio, proposals);
                }
            }
        } else {
            this.doComputeSubProposals(context, node, proposals, monitor);
        }
    }

    private @Nullable String checkHelp(RAssistInvocationContext context) {
        try {
            if (context.getIdentifierOffset() > 0 && context.getDocument().getChar(context.getIdentifierOffset() - 1) == '?') {
                String prefix = context.computeIdentifierPrefix(context.getIdentifierOffset() - 1);
                if (prefix != null && !prefix.isEmpty()) {
                    if (prefix.equals("class") || prefix.equals("methods")) {
                        return prefix;
                    }
                    return null;
                }
                return "";
            }
            return null;
        }
        catch (BadLocationException | BadPartitioningException e) {
            return null;
        }
    }

    protected List<? extends RLangElement> getChildren(RAssistInvocationContext context, RLangElement e) {
        if (e instanceof RReference) {
            RReference ref = (RReference)e;
            RObject rObject = ref.getResolvedRObject();
            if (rObject == null && e instanceof CombinedRElement && context.getTool() != null) {
                context.getToolReferencesUtil().resolve(ref, 0);
            }
            if (rObject instanceof CombinedRElement) {
                e = (CombinedRElement)rObject;
            }
        }
        return e.getModelChildren(null);
    }

    protected boolean doComputeArgumentProposals(RAssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RAssistInvocationContext.FCallInfo fCallInfo = context.getFCallInfo();
        if (fCallInfo != null) {
            boolean argName = false;
            boolean argValue = false;
            int argIdx = fCallInfo.getInvocationArgIdx();
            if (argIdx >= 0) {
                int offset;
                RHeuristicTokenScanner scanner;
                FCall.Arg arg = fCallInfo.getArg(argIdx);
                int argBeginOffset = fCallInfo.getArgBeginOffset(argIdx);
                IDocument document = context.getDocument();
                int offsetShift = 0;
                if (document instanceof FragmentDocument) {
                    FragmentDocument inputDoc = (FragmentDocument)document;
                    document = inputDoc.getMasterDocument();
                    offsetShift = inputDoc.getOffsetInMasterDocument();
                }
                if (argBeginOffset != Integer.MIN_VALUE) {
                    scanner = context.getRHeuristicTokenScanner();
                    scanner.configure(document, NO_R_COMMENT_CONSTRAINT);
                    offset = context.getIdentifierOffset();
                    if (argBeginOffset == offset || scanner.findNonBlankForward(argBeginOffset + offsetShift, offset + offsetShift, true) < 0) {
                        argName = this.inDefault && context.getIdentifierElementName().getScope() == null;
                        argValue = true;
                    }
                }
                if (!argValue && arg != null && arg.getAssignOffset() != Integer.MIN_VALUE) {
                    scanner = context.getRHeuristicTokenScanner();
                    scanner.configure(document, NO_R_COMMENT_CONSTRAINT);
                    offset = context.getIdentifierOffset();
                    if (argBeginOffset == offset || scanner.findNonBlankForward(arg.getAssignOffset() + offsetShift + 1, offset + offsetShift, true) < 0) {
                        argValue = true;
                    }
                }
            }
            if (argName || argValue) {
                this.doComputeFCallArgumentProposals(context, fCallInfo, argIdx, argName, argValue, proposals);
                return true;
            }
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void doComputeMainProposals(RAssistInvocationContext context, RAstNode node, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        this.searchPath.init(context, node, this.getSearchMode(context), prefixName.getScope());
        RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(context, context.getIdentifierLastSegmentOffset(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), prefixSegmentName), this.labelProvider);
        HashSet<String> mainNames = new HashSet<String>();
        ArrayList<String> methodNames = new ArrayList<String>();
        RFrameSearchPath.RFrameIterator iter = this.searchPath.iterator();
        while (iter.hasNext()) {
            RFrame envir = iter.next();
            parameters.baseRelevance = iter.getRelevance();
            List elements = envir.getModelChildren(null);
            for (RElement element : elements) {
                boolean isRich;
                RElementName elementName = element.getElementName();
                int c1type = element.getElementType() & 0xF00;
                boolean bl = isRich = c1type == 1280;
                if (!isRich && c1type != 1536 || !this.isCompletable(elementName) || !parameters.matchesNamePattern(elementName.getSegmentName()) || parameters.baseRelevance < 0 && !isRich && mainNames.contains(elementName.getSegmentName())) continue;
                parameters.replacementName = elementName;
                parameters.element = element;
                RElementCompletionProposal proposal = new RElementCompletionProposal(parameters);
                if (elementName.getNextSegment() == null) {
                    if (isRich) {
                        methodNames.add(elementName.getSegmentName());
                    } else {
                        mainNames.add(elementName.getSegmentName());
                    }
                }
                proposals.add((AssistProposal)proposal);
            }
        }
        mainNames.addAll(methodNames);
        for (RFrame envir : this.searchPath) {
            parameters.baseRelevance = 0;
            if (!(envir instanceof RSourceFrame)) continue;
            RSourceFrame sframe = (RSourceFrame)envir;
            @Nullable Set elementNames = sframe.getAllAccessNames();
            for (String candidate : elementNames) {
                if (candidate == null || candidate.equals(prefixSegmentName) && sframe.getAllAccessOf(candidate, false).size() <= 1 || mainNames.contains(candidate) || !parameters.matchesNamePattern(candidate)) continue;
                RSimpleCompletionProposal proposal = new RSimpleCompletionProposal(parameters, candidate);
                mainNames.add(candidate);
                proposals.add((AssistProposal)proposal);
            }
        }
    }

    private void doComputeKeywordProposals(RAssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (prefixName.getScope() != null) {
            return;
        }
        String prefixSource = context.getIdentifierPrefix();
        if (!prefixSegmentName.isEmpty() && prefixSource.charAt(0) != '`') {
            SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)context, context.getIdentifierOffset(), (SearchPattern)new RSearchPattern(4, prefixSegmentName));
            ImList<String> keywords = fgKeywords;
            for (String keyword : keywords) {
                if (!parameters.matchesNamePattern(keyword)) continue;
                proposals.add((AssistProposal)new RSimpleCompletionProposal((SourceProposal.ProposalParameters<RAssistInvocationContext>)parameters, keyword));
            }
        }
    }

    protected void doComputeSubProposals(RAssistInvocationContext context, RAstNode node, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RElementName prefixName = context.getIdentifierElementName();
        this.searchPath.init(context, node, this.getSearchMode(context), prefixName.getScope());
        int count = 0;
        RElementName prefixSegment = prefixName;
        while (true) {
            ++count;
            if (prefixSegment.getNextSegment() == null) break;
            prefixSegment = prefixSegment.getNextSegment();
        }
        String namePrefix = prefixSegment.getSegmentName() != null ? prefixSegment.getSegmentName() : "";
        RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(context, context.getIdentifierLastSegmentOffset(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), namePrefix), this.labelProvider);
        HashSet<String> mainNames = new HashSet<String>();
        ArrayList<String> methodNames = new ArrayList<String>();
        RFrameSearchPath.RFrameIterator iter = this.searchPath.iterator();
        while (iter.hasNext()) {
            RFrame envir = iter.next();
            parameters.baseRelevance = iter.getRelevance();
            List elements = envir.getModelChildren(null);
            block2: for (RLangElement rootElement : elements) {
                boolean childMode;
                List<RLangElement> children;
                boolean isRich;
                RElementName elementName = rootElement.getElementName();
                int c1type = rootElement.getElementType() & 0xF00;
                boolean bl = isRich = c1type == 1280;
                if (!isRich && c1type != 1536) continue;
                RLangElement element = rootElement;
                RElementName prefixSegment2 = prefixName;
                RElementName elementSegment = elementName;
                int i = 0;
                while (i < count - 1) {
                    block16: {
                        if (elementSegment == null) {
                            children = this.getChildren(context, element);
                            for (RLangElement child : children) {
                                elementSegment = child.getElementName();
                                if (!this.isCompletable(elementSegment) || !elementSegment.getSegmentName().equals(prefixSegment2.getSegmentName())) continue;
                                element = child;
                                prefixSegment2 = prefixSegment2.getNextSegment();
                                elementSegment = elementSegment.getNextSegment();
                                break block16;
                            }
                            continue block2;
                        }
                        if (!this.isCompletable(elementSegment) || !elementSegment.getSegmentName().equals(prefixSegment2.getSegmentName())) continue block2;
                        prefixSegment2 = prefixSegment2.getNextSegment();
                        elementSegment = elementSegment.getNextSegment();
                    }
                    ++i;
                }
                if (elementSegment == null) {
                    childMode = true;
                    children = this.getChildren(context, element);
                } else {
                    childMode = false;
                    children = Collections.singletonList(element);
                }
                for (RLangElement child : children) {
                    if (childMode) {
                        elementSegment = child.getElementName();
                    }
                    String candidate = elementSegment.getSegmentName();
                    if (!this.isCompletable(elementSegment) || !parameters.matchesNamePattern(candidate)) continue;
                    if (parameters.baseRelevance > 0 && !isRich && mainNames.contains(candidate)) continue block2;
                    parameters.replacementName = elementSegment;
                    parameters.element = child;
                    RElementCompletionProposal proposal = new RElementCompletionProposal(parameters);
                    if (elementSegment.getNextSegment() == null) {
                        if (isRich) {
                            methodNames.add(candidate);
                        } else {
                            mainNames.add(candidate);
                        }
                    }
                    proposals.add((AssistProposal)proposal);
                }
            }
        }
        mainNames.addAll(methodNames);
        for (RFrame envir : this.searchPath) {
            RSourceFrame sframe;
            ImList allAccess;
            parameters.baseRelevance = 0;
            if (!(envir instanceof RSourceFrame) || (allAccess = (sframe = (RSourceFrame)envir).getAllAccessOf(prefixName.getSegmentName(), true)) == null) continue;
            Iterator iterator = allAccess.iterator();
            block7: while (iterator.hasNext()) {
                String candidate;
                RElementAccess elementAccess;
                RElementAccess elementSegment = elementAccess = (RElementAccess)iterator.next();
                RElementName prefixSegment3 = prefixName;
                int i = 0;
                while (i < count - 1) {
                    if (!this.isCompletable((RElementName)elementSegment) || !elementSegment.getSegmentName().equals(prefixSegment3.getSegmentName())) continue block7;
                    prefixSegment3 = prefixSegment3.getNextSegment();
                    elementSegment = elementSegment.getNextSegment();
                    ++i;
                }
                if (elementSegment == null || elementSegment.isSlave() || (candidate = elementSegment.getSegmentName()) == null || !this.isCompletable((RElementName)elementSegment) || candidate.equals(namePrefix) || mainNames.contains(candidate) || !parameters.matchesNamePattern(candidate)) continue;
                RSimpleCompletionProposal proposal = new RSimpleCompletionProposal(parameters, candidate);
                mainNames.add(candidate);
                proposals.add((AssistProposal)proposal);
            }
        }
    }

    public void doComputeContextProposals(RAssistInvocationContext context, final AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context.getModelInfo() == null) {
            return;
        }
        final RAssistInvocationContext.FCallInfo fCallInfo = context.getFCallInfo();
        if (fCallInfo != null) {
            final RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(context, fCallInfo.getNode().getArgsOpenOffset() + 1, this.labelProvider);
            FCallNamePattern pattern = new FCallNamePattern((RElementName)fCallInfo.getAccess()){

                @Override
                protected void handleMatch(RLangMethod element, RFrame frame, RFrameSearchPath.RFrameIterator iterator) {
                    parameters.baseRelevance = iterator.getRelevance();
                    parameters.replacementName = element.getElementName();
                    parameters.element = element;
                    proposals.add((AssistProposal)new RElementCompletionProposal.ContextInformationProposal(parameters, fCallInfo.getNode()));
                }
            };
            pattern.searchFDef(fCallInfo.getSearchPath(this.getSearchMode(context)));
        }
    }

    protected final boolean isPackageArg(@Nullable String name) {
        return "package".equals(name);
    }

    private void doComputeFCallArgumentProposals(RAssistInvocationContext context, RAssistInvocationContext.FCallInfo fCallInfo, int argIdx, boolean argName, boolean argValue, AssistProposalCollector proposals) {
        FCall.Arg arg;
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (argValue && !argName && (arg = fCallInfo.getArg(argIdx)) != null && arg.hasName() && this.inString && this.isPackageArg(arg.getNameChild().getText())) {
            this.pkgNamePrio = 40;
        }
        RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(context, context.getIdentifierOffset(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), prefixSegmentName), this.labelProvider);
        class FCallHandler
        extends FCallNamePattern {
            private final @Nullable RCoreFunctions coreFunction;
            private final HashSet<String> argNames;
            private int matchCount;
            private final /* synthetic */ int val$argIdx;
            private final /* synthetic */ RAssistInvocationContext.FCallInfo val$fCallInfo;
            private final /* synthetic */ boolean val$argName;
            private final /* synthetic */ RElementCompletionProposal.RElementProposalParameters val$parameters;
            private final /* synthetic */ AssistProposalCollector val$proposals;
            private final /* synthetic */ boolean val$argValue;

            FCallHandler(RAssistInvocationContext.FCallInfo fCallInfo, int n, boolean bl, RElementCompletionProposal.RElementProposalParameters rElementProposalParameters, AssistProposalCollector assistProposalCollector, boolean bl2) {
                this.val$fCallInfo = fCallInfo;
                this.val$argIdx = n;
                this.val$argName = bl;
                this.val$parameters = rElementProposalParameters;
                this.val$proposals = assistProposalCollector;
                this.val$argValue = bl2;
                super((RElementName)fCallInfo.getAccess());
                this.argNames = new HashSet();
                this.coreFunction = fCallInfo.getAccess().getNextSegment() == null ? RCoreFunctions.DEFAULT : null;
            }

            private boolean isValidNameContext(Parameters.Parameter parameter) {
                if (RElementCompletionComputer.this.inString) {
                    return (parameter.getType() & 0x4000000) != 0;
                }
                return (parameter.getType() & 0x2000000) != 0;
            }

            private boolean checkArgsDef(RAsts.FCallArgMatch args, boolean guess, int relevance) {
                Parameters.Parameter parameter = args.getParameterForFCall(this.val$argIdx);
                if (parameter != null) {
                    boolean typedDef;
                    boolean bl = typedDef = parameter.getType() != 0;
                    if (RElementCompletionComputer.this.pkgNamePrio == Integer.MIN_VALUE) {
                        if (typedDef) {
                            if ((parameter.getType() & 0x200) != 0 && this.isValidNameContext(parameter)) {
                                RElementCompletionComputer.this.pkgNamePrio = 40 + relevance;
                            }
                        } else if (guess && RElementCompletionComputer.this.inString && RElementCompletionComputer.this.isPackageArg(parameter.getName())) {
                            RElementCompletionComputer.this.pkgNamePrio = 40 + relevance;
                        }
                    }
                    if (RElementCompletionComputer.this.helpTopicPrio == Integer.MIN_VALUE && typedDef && (parameter.getType() & 0x1000) != 0 && this.isValidNameContext(parameter)) {
                        RElementCompletionComputer.this.helpTopicPrio = 40 + relevance;
                    }
                    return typedDef;
                }
                return false;
            }

            @Override
            public void searchFDef(RFrameSearchPath searchPath) {
                Parameters coreParameters;
                super.searchFDef(searchPath);
                if (this.matchCount == 0 && this.coreFunction != null && (coreParameters = this.coreFunction.getParameters(this.getElementName().getSegmentName())) != null) {
                    this.checkArgsDef(RAsts.matchArgs((FCall)this.val$fCallInfo.getNode(), (Parameters)coreParameters), false, 0);
                }
            }

            @Override
            protected void handleMatch(RLangMethod element, RFrame frame, RFrameSearchPath.RFrameIterator iter) {
                Parameters coreParameters;
                Parameters elementParameters = element.getParameters();
                if (elementParameters == null) {
                    return;
                }
                int contextRelevance = iter.getRelevance();
                ++this.matchCount;
                if (this.val$argName) {
                    int i = 0;
                    while (i < elementParameters.size()) {
                        Parameters.Parameter param = elementParameters.get(i);
                        String paramName = param.getName();
                        if (paramName != null && !paramName.isEmpty() && !paramName.equals("...") && this.val$parameters.matchesNamePattern(paramName) && this.argNames.add(paramName)) {
                            RElementName name = RElementName.create((int)17, (String)param.getName());
                            this.val$parameters.baseRelevance = contextRelevance + 80;
                            this.val$parameters.replacementName = name;
                            this.val$parameters.element = element;
                            this.val$proposals.add((AssistProposal)new RElementCompletionProposal.ArgumentProposal(this.val$parameters));
                        }
                        ++i;
                    }
                }
                if (this.val$argValue && !this.checkArgsDef(RAsts.matchArgs((FCall)this.val$fCallInfo.getNode(), (Parameters)elementParameters), true, contextRelevance) && frame.getFrameType() == 2 && this.coreFunction != null && this.coreFunction.getPackageNames().contains((Object)frame.getElementName().getSegmentName()) && (coreParameters = this.coreFunction.getParameters(this.getElementName().getSegmentName())) != null) {
                    this.checkArgsDef(RAsts.matchArgs((FCall)this.val$fCallInfo.getNode(), (Parameters)coreParameters), false, contextRelevance);
                }
            }
        }
        FCallHandler search = new FCallHandler(fCallInfo, argIdx, argName, parameters, proposals, argValue);
        search.searchFDef(fCallInfo.getSearchPath(this.getSearchMode(context)));
    }

    protected final @Nullable RPkgManagerDataset getRPkgDataset(RAssistInvocationContext context) {
        IRPkgManager manager = RCore.getRPkgManager((REnv)context.getRCoreAccess().getREnv());
        if (manager != null) {
            return manager.getDataset();
        }
        return null;
    }

    protected final boolean isPackageName(RElementName elementName) {
        return (elementName.getType() == 17 || RElementName.isPackageFacetScopeType((int)elementName.getType())) && elementName.getNextSegment() == null;
    }

    protected final void doComputePkgNameProposals(RAssistInvocationContext context, int prio, AssistProposalCollector proposals) {
        Object envNames;
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (prefixName.getScope() != null || !this.isSymbolCandidate(prefixSegmentName)) {
            return;
        }
        RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(context, context.getInvocationOffset() - prefixSegmentName.length(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), prefixSegmentName), prio, this.labelProvider);
        RPkgManagerDataset rPkgDataset = this.getRPkgDataset(context);
        if (rPkgDataset != null) {
            RPkgCompilation pkgs = rPkgDataset.getInstalled();
            envNames = pkgs.getNames();
            Iterator iterator = envNames.iterator();
            while (iterator.hasNext()) {
                String pkgName = (String)iterator.next();
                if (!parameters.matchesNamePattern(pkgName)) continue;
                parameters.replacementName = RElementName.create((int)38, (String)pkgName);
                RPkgCompletionProposal proposal = new RPkgCompletionProposal(parameters, (RPkgBuilt)pkgs.getFirst(pkgName));
                proposals.add((AssistProposal)proposal);
            }
        } else {
            envNames = ImCollections.emptySet();
        }
        Set workspaceNames = RModel.getRModelManager().getPkgNames();
        for (String pkgName : workspaceNames) {
            if (envNames.contains(pkgName) || !parameters.matchesNamePattern(pkgName)) continue;
            parameters.replacementName = RElementName.create((int)38, (String)pkgName);
            proposals.add((AssistProposal)new RPkgCompletionProposal(parameters, null));
        }
    }

    protected final void doComputeHelpTopicProposals(RAssistInvocationContext context, @Nullable String topicType, RAstNode node, int prio, AssistProposalCollector proposals) {
        RElementName prefixName = context.getIdentifierElementName();
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (topicType == null && (prefixName.getScope() != null || prefixSegmentName.isEmpty())) {
            return;
        }
        REnv rEnv = context.getRCoreAccess().getREnv();
        if (rEnv == null) {
            return;
        }
        RHelpManager rHelpManager = RCore.getRHelpManager();
        REnvHelp help = rHelpManager.getHelp(rEnv);
        if (help != null) {
            try {
                SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)context, context.getInvocationContentType() != "R.Default" ? context.getIdentifierLastSegmentOffset() + 1 : context.getIdentifierLastSegmentOffset(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), prefixSegmentName), prio);
                HashMap<String, RHelpTopicCompletionProposal> map = new HashMap<String, RHelpTopicCompletionProposal>();
                this.searchPath.init(context, node, this.getSearchMode(context), prefixName.getScope());
                HashSet<String> pkgNames = new HashSet<String>();
                for (RFrame frame : this.searchPath) {
                    RPkgHelp pkgHelp;
                    String pkgName;
                    if (frame.getFrameType() != 2 || (pkgName = frame.getElementName().getSegmentName()) == null || !pkgNames.add(pkgName) || (pkgHelp = help.getPkgHelp(pkgName)) == null) continue;
                    for (RHelpTopicEntry topicEntry : pkgHelp.getTopics()) {
                        String topic = topicEntry.getTopic();
                        if (!parameters.matchesNamePattern(topic)) continue;
                        RHelpTopicCompletionProposal proposal = (RHelpTopicCompletionProposal)((Object)map.get(topic));
                        if (proposal == null) {
                            proposal = new RHelpTopicCompletionProposal((SourceProposal.ProposalParameters<RAssistInvocationContext>)parameters, topic, topicEntry.getPage());
                            map.put(topic, proposal);
                            proposals.add((AssistProposal)proposal);
                            continue;
                        }
                        proposal.addPage(topicEntry.getPage());
                    }
                }
            }
            finally {
                help.unlock();
            }
        }
    }

    public static class CompleteRuntime
    extends RElementCompletionComputer {
        public CompleteRuntime() {
            super(3);
        }
    }
}

