/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.statet.ecommons.waltable.ui.NatEventData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class NatTableContributionItem
extends ContributionItem {
    public static final int STYLE_PUSH = 8;
    public static final int STYLE_CHECK = 32;
    public static final int STYLE_RADIO = 16;
    public static final int STYLE_PULLDOWN = 4;
    public static final int MODE_FORCE_TEXT = 1;
    private LocalResourceManager localResourceManager;
    private Listener menuItemListener;
    private Widget widget;
    private ImageDescriptor icon;
    private String label;
    private String tooltip;
    private ImageDescriptor disabledIcon;
    private ImageDescriptor hoverIcon;
    private final String mnemonic;
    private boolean checkedState;
    private final int style;
    private IWorkbenchHelpSystem workbenchHelpSystem;
    private String helpContextId;
    private final int mode = 0;

    public NatTableContributionItem(CommandContributionItemParameter contributionParameters) {
        super(contributionParameters.id);
        this.icon = contributionParameters.icon;
        this.disabledIcon = contributionParameters.disabledIcon;
        this.hoverIcon = contributionParameters.hoverIcon;
        this.label = contributionParameters.label;
        this.mnemonic = contributionParameters.mnemonic;
        this.tooltip = contributionParameters.tooltip;
        this.style = contributionParameters.style;
        this.helpContextId = contributionParameters.helpContextId;
    }

    protected NatTableContributionItem(ImageDescriptor icon, ImageDescriptor disabledIcon, String label, String mnemonic) {
        this.icon = icon;
        this.disabledIcon = disabledIcon;
        this.label = label;
        this.mnemonic = mnemonic;
        this.style = 8;
    }

    protected NatTableContributionItem(String label, String mnemonic) {
        this.label = label;
        this.mnemonic = mnemonic;
        this.style = 8;
    }

    protected NatTableContributionItem(ImageDescriptor icon, ImageDescriptor disabledIcon, String label, String mnemonic, int style) {
        this.icon = icon;
        this.disabledIcon = disabledIcon;
        this.label = label;
        this.mnemonic = mnemonic;
        this.style = style;
    }

    protected NatTableContributionItem(String label, String mnemonic, int style) {
        this.label = label;
        this.mnemonic = mnemonic;
        this.style = style;
    }

    public void fill(Menu parent, int index) {
        if (this.widget != null || parent == null) {
            return;
        }
        int tmpStyle = this.style;
        if (tmpStyle == 4) {
            tmpStyle = 8;
        }
        MenuItem item = null;
        item = index >= 0 ? new MenuItem(parent, tmpStyle, index) : new MenuItem(parent, tmpStyle);
        item.setData((Object)this);
        if (this.workbenchHelpSystem != null) {
            this.workbenchHelpSystem.setHelp(item, this.helpContextId);
        }
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget != null || parent == null) {
            return;
        }
        ToolItem item = null;
        item = index >= 0 ? new ToolItem(parent, this.style, index) : new ToolItem(parent, this.style);
        item.setData((Object)this);
        item.addListener(13, this.getItemListener());
        item.addListener(12, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
    }

    public void fill(Composite parent) {
        if (this.widget != null || parent == null) {
            return;
        }
        int tmpStyle = this.style;
        if (tmpStyle == 4) {
            tmpStyle = 8;
        }
        Button item = new Button(parent, tmpStyle);
        item.setData((Object)this);
        if (this.workbenchHelpSystem != null) {
            this.workbenchHelpSystem.setHelp((Control)item, this.helpContextId);
        }
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        if (this.widget != null) {
            if (this.widget instanceof MenuItem) {
                this.updateMenuItem();
            } else if (this.widget instanceof ToolItem) {
                this.updateToolItem();
            } else if (this.widget instanceof Button) {
                this.updateButton();
            }
        }
    }

    private void updateMenuItem() {
        MenuItem item = (MenuItem)this.widget;
        boolean shouldBeEnabled = this.isEnabled();
        if (item.isDisposed()) {
            return;
        }
        String text = this.label;
        text = this.updateMnemonic(text);
        String keyBindingText = null;
        if (text != null) {
            if (keyBindingText == null) {
                item.setText(text);
            } else {
                item.setText(String.valueOf(text) + '\t' + keyBindingText);
            }
        }
        if (item.getSelection() != this.checkedState) {
            item.setSelection(this.checkedState);
        }
        if (item.getEnabled() != shouldBeEnabled) {
            item.setEnabled(shouldBeEnabled);
        }
    }

    private void updateToolItem() {
        ToolItem item = (ToolItem)this.widget;
        boolean shouldBeEnabled = this.isEnabled();
        if (item.isDisposed()) {
            return;
        }
        String text = this.label;
        if ((this.icon == null || false & true) && text != null) {
            item.setText(text);
        }
        String toolTipText = this.getToolTipText(text);
        item.setToolTipText(toolTipText);
        if (item.getSelection() != this.checkedState) {
            item.setSelection(this.checkedState);
        }
        if (item.getEnabled() != shouldBeEnabled) {
            item.setEnabled(shouldBeEnabled);
        }
    }

    private void updateButton() {
        Button item = (Button)this.widget;
        boolean shouldBeEnabled = this.isEnabled();
        if (item.isDisposed()) {
            return;
        }
        String text = this.label;
        if (text != null) {
            item.setText(text);
        }
        String toolTipText = this.getToolTipText(text);
        item.setToolTipText(toolTipText);
        if (item.getSelection() != this.checkedState) {
            item.setSelection(this.checkedState);
        }
        if (item.getEnabled() != shouldBeEnabled) {
            item.setEnabled(shouldBeEnabled);
        }
    }

    private String getToolTipText(String text) {
        String tooltipText = this.tooltip;
        if (this.tooltip == null) {
            tooltipText = text != null ? text : "";
        }
        return tooltipText;
    }

    private String updateMnemonic(String s) {
        if (this.mnemonic == null || s == null) {
            return s;
        }
        int idx = s.indexOf(this.mnemonic);
        if (idx == -1) {
            return s;
        }
        return String.valueOf(s.substring(0, idx)) + '&' + s.substring(idx);
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget = null;
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        this.disposeOldImages();
        super.dispose();
    }

    private void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    private Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            NatTableContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            if (event.widget == null) break;
                            NatTableContributionItem.this.handleWidgetSelection(event);
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private static NatEventData getNatEventData(Event selectionEvent) {
        Widget widget = selectionEvent.widget;
        if (widget == null || !(widget instanceof MenuItem)) {
            return null;
        }
        MenuItem menuItem = (MenuItem)widget;
        Object data = null;
        for (Menu parentMenu = menuItem.getParent(); parentMenu != null; parentMenu = parentMenu.getParentMenu()) {
            if (parentMenu.getData() == null) {
                continue;
            }
            data = parentMenu.getData();
            break;
        }
        return data != null ? (NatEventData)data : null;
    }

    private void handleWidgetSelection(Event event) {
        NatEventData eventData;
        if (this.openDropDownMenu(event)) {
            return;
        }
        if ((this.style & 0x22) != 0) {
            if (event.widget instanceof ToolItem) {
                this.checkedState = ((ToolItem)event.widget).getSelection();
            } else if (event.widget instanceof MenuItem) {
                this.checkedState = ((MenuItem)event.widget).getSelection();
            }
        }
        if ((eventData = NatTableContributionItem.getNatEventData(event)) == null) {
            return;
        }
        try {
            this.execute(eventData);
        }
        catch (ExecutionException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Failed to execute item " + this.getId(), (Throwable)e));
        }
    }

    private boolean openDropDownMenu(Event event) {
        int style;
        Widget item = event.widget;
        if (item != null && ((style = item.getStyle()) & 4) != 0 && event.detail == 4) {
            ToolItem ti = (ToolItem)item;
            MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu((Control)ti.getParent());
            if (this.workbenchHelpSystem != null) {
                this.workbenchHelpSystem.setHelp(menu, this.helpContextId);
            }
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    NatTableContributionItem.this.dropDownMenuAboutToShow(manager);
                }
            });
            Point point = ti.getParent().toDisplay(new Point(event.x, event.y));
            menu.setLocation(point.x, point.y);
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    private void updateIcons() {
        if (this.widget instanceof MenuItem) {
            MenuItem item = (MenuItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            try {
                item.setImage(this.icon == null ? null : m.createImage(this.icon));
            }
            catch (DeviceResourceException e) {
                this.icon = ImageDescriptor.getMissingImageDescriptor();
                item.setImage(m.createImage(this.icon));
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Failed to load image", (Throwable)e));
            }
            this.disposeOldImages();
            this.localResourceManager = m;
        } else if (this.widget instanceof ToolItem) {
            ToolItem item = (ToolItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            item.setDisabledImage(this.disabledIcon == null ? null : m.createImage(this.disabledIcon));
            item.setHotImage(this.hoverIcon == null ? null : m.createImage(this.hoverIcon));
            item.setImage(this.icon == null ? null : m.createImage(this.icon));
            this.disposeOldImages();
            this.localResourceManager = m;
        }
    }

    public void setText(String text) {
        this.label = text;
        this.update(null);
    }

    public void setChecked(boolean checked) {
        if (this.checkedState == checked) {
            return;
        }
        this.checkedState = checked;
        if (this.widget instanceof MenuItem) {
            ((MenuItem)this.widget).setSelection(this.checkedState);
        } else if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setSelection(this.checkedState);
        }
    }

    public void setTooltip(String text) {
        this.tooltip = text;
        if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setToolTipText(text);
        }
    }

    public void setIcon(ImageDescriptor desc) {
        this.icon = desc;
        this.updateIcons();
    }

    public void setDisabledIcon(ImageDescriptor desc) {
        this.disabledIcon = desc;
        this.updateIcons();
    }

    public void setHoverIcon(ImageDescriptor desc) {
        this.hoverIcon = desc;
        this.updateIcons();
    }

    protected void dropDownMenuAboutToShow(IMenuManager manager) {
    }

    protected void execute(NatEventData natEventData) throws ExecutionException {
    }
}

