/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.objectbrowser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.models.core.util.ElementPartition;
import org.eclipse.statet.ecommons.ts.ui.ToolRunnableDecorator;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.objectbrowser.ObjectBrowserView;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolMessageDialog;
import org.eclipse.statet.r.console.core.AbstractRDataRunnable;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.ui.util.RElementInputContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class DeleteHandler
extends AbstractHandler {
    private final ObjectBrowserView view;

    public DeleteHandler(ObjectBrowserView view) {
        this.view = view;
    }

    private boolean isValidSelection(ITreeSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (!(element instanceof ElementPartition)) continue;
            return false;
        }
        return true;
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        RProcess process = this.view.getTool();
        this.setBaseEnabled(process != null && !process.isTerminated() && this.isValidSelection(this.view.getSelection()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        RProcess process;
        if (!UIAccess.isOkToUse((Viewer)this.view.getViewer())) {
            return null;
        }
        ITreeSelection selection = this.view.getSelection();
        if (!this.isValidSelection(selection)) {
            return null;
        }
        TreePath[] treePaths = selection.getPaths();
        Arrays.sort(treePaths, new Comparator<TreePath>(){

            @Override
            public int compare(TreePath o1, TreePath o2) {
                return o1.getSegmentCount() - o2.getSegmentCount();
            }
        });
        IElementComparer comparer = new IElementComparer(){

            public int hashCode(Object e) {
                return e.hashCode();
            }

            public boolean equals(Object e1, Object e2) {
                return e1 == e2;
            }
        };
        ArrayList<String> commands = new ArrayList<String>(treePaths.length);
        ArrayList<String> names = new ArrayList<String>(treePaths.length);
        HashSet<ElementName> topEnvirs = new HashSet<ElementName>(treePaths.length);
        int i = 0;
        while (i < treePaths.length) {
            block14: {
                RElementName elementName;
                block15: {
                    int j = 0;
                    while (j < i) {
                        if (treePaths[j] != null && treePaths[i].startsWith(treePaths[j], comparer)) {
                            treePaths[i] = null;
                            break block14;
                        }
                        ++j;
                    }
                    TreePath treePath = treePaths[i];
                    CombinedRElement element = RElementInputContentProvider.getCombinedRElement(treePath.getLastSegment());
                    CombinedRElement parent = element.getModelParent();
                    elementName = this.view.getFQElementName(treePath);
                    if (parent == null || elementName == null) break block15;
                    switch (parent.getRObjectType()) {
                        case 8: {
                            RElementName envirName = treePath.getSegmentCount() > 1 ? this.view.getFQElementName(treePath.getParentPath()) : parent.getElementName();
                            RElementName itemName = element.getElementName();
                            RElementName topName = elementName.getScope();
                            if (envirName == null) break;
                            commands.add("rm(`" + itemName.getSegmentName() + "`," + "pos=" + RElementName.createDisplayName((RElementName)envirName, (int)3) + ")");
                            names.add(elementName.getDisplayName());
                            topEnvirs.add((ElementName)topName);
                            break block14;
                        }
                        case 6: 
                        case 7: 
                        case 10: {
                            RElementName topName = elementName.getScope();
                            String name = RElementName.createDisplayName((RElementName)elementName, (int)2);
                            commands.add("with(" + RElementName.createDisplayName((RElementName)topName, (int)1) + "," + name + "<-NULL" + ")");
                            names.add(elementName.getDisplayName());
                            topEnvirs.add((ElementName)topName);
                            break block14;
                        }
                    }
                }
                StringBuilder message = new StringBuilder("Selection contains unsupported object");
                if (elementName != null) {
                    message.append("\n\t");
                    message.append(elementName.getDisplayName());
                } else {
                    message.append(".");
                }
                MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)"Delete", (String)message.toString());
                return null;
            }
            ++i;
        }
        StringBuilder message = new StringBuilder(names.size() == 1 ? "Delete this object?" : NLS.bind((String)"Delete these {0} objects?", (Object)names.size()));
        int show = names.size() > 5 ? 3 : names.size();
        int i2 = 0;
        while (i2 < show) {
            message.append("\n\t");
            message.append((String)names.get(i2));
            ++i2;
        }
        if (show < names.size()) {
            message.append("\n\t...");
        }
        if (ToolMessageDialog.openConfirm((ToolProcess)(process = this.view.getTool()), (Shell)this.view.getSite().getShell(), (String)"Delete R Objects", (String)message.toString(), (String)"Delete")) {
            process.getQueue().add((ToolRunnable)new DeleteRunnable(names, commands, topEnvirs));
        }
        return null;
    }

    private static class DeleteRunnable
    extends AbstractRDataRunnable
    implements ToolRunnableDecorator {
        private final List<String> names;
        private final List<String> commands;
        private final Set<ElementName> topEnvirs;

        public DeleteRunnable(List<String> names, List<String> commands, Set<ElementName> topEnvirs) {
            super("r/objectbrowser/delete", "Delete Elements");
            this.names = names;
            this.commands = commands;
            this.topEnvirs = topEnvirs;
        }

        public Image getImage() {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        }

        public boolean changed(int event, Tool tool) {
            return event != 289;
        }

        protected void run(IRDataAdapter r, ProgressMonitor m) throws StatusException {
            r.briefAboutToChange();
            try {
                int i = 0;
                while (i < this.names.size()) {
                    r.evalVoid(this.commands.get(i), m);
                    ++i;
                }
            }
            finally {
                r.briefChanged(this.topEnvirs, 0);
            }
        }
    }
}

