/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public class TemplateUtils {
    public static String searchIndentation(IDocument document, int offset) {
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            String lineContent = document.get(region.getOffset(), region.getLength());
            return TemplateUtils.searchIndentation(lineContent);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private static String searchIndentation(String text) throws BadLocationException {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c != ' ' && c != '\t') break;
            ++i;
        }
        return text.substring(0, i);
    }

    public static void positionsToVariables(List<TextEdit> positions, TemplateVariable[] variables) {
        Iterator<TextEdit> iterator = positions.iterator();
        TemplateVariable[] templateVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable variable = templateVariableArray[n2];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j < offsets.length) {
                offsets[j] = iterator.next().getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++n2;
        }
    }

    public static List<TextEdit> variablesToPositions(TemplateVariable[] variables) {
        ArrayList<TextEdit> positions = new ArrayList<TextEdit>(5);
        TemplateVariable[] templateVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable variable = templateVariableArray[n2];
            int[] offsets = variable.getOffsets();
            String value = variable.getDefaultValue();
            int wsStart = 0;
            while (wsStart < value.length() && Character.isWhitespace(value.charAt(wsStart)) && !TemplateUtils.isLineDelimiterChar(value.charAt(wsStart))) {
                ++wsStart;
            }
            variable.getValues()[0] = value.substring(wsStart);
            int j = 0;
            while (j != offsets.length) {
                int n3 = j;
                offsets[n3] = offsets[n3] + wsStart;
                positions.add((TextEdit)new RangeMarker(offsets[j], 0));
                ++j;
            }
            ++n2;
        }
        return positions;
    }

    public static @Nullable TemplateVariable findVariable(TemplateBuffer buffer, String variableType) {
        TemplateVariable[] variables;
        TemplateVariable[] templateVariableArray = variables = buffer.getVariables();
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable cand = templateVariableArray[n2];
            if (variableType.equals(cand.getType())) {
                return cand;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isLineDelimiterChar(char c) {
        return c == '\r' || c == '\n';
    }

    public static void indentTemplateDocument(AbstractDocument doc, String lineIndent) throws BadLocationException {
        int lastLine = doc.getNumberOfLines() - 1;
        int templateLine = 0;
        while (templateLine < lastLine) {
            doc.replace(doc.getLineOffset(templateLine), 0, lineIndent);
            ++templateLine;
        }
        int lineOffset = doc.getLineOffset(lastLine);
        if (lineOffset != doc.getLength()) {
            doc.replace(lineOffset, 0, lineIndent);
            doc.replace(doc.getLength(), 0, doc.getDefaultLineDelimiter());
        }
    }

    public static class EvaluatedTemplate {
        private String content;
        private @Nullable IRegion select;
        private final String lineDelimiter;
        private @Nullable AbstractDocument postEditDocument;
        private @Nullable Position postEditSelectPosition;

        public EvaluatedTemplate(TemplateBuffer buffer, String lineDelimiter) {
            this.setContent(buffer.getString());
            TemplateVariable selectStartVariable = TemplateUtils.findVariable(buffer, "selection_begin");
            TemplateVariable selectEndVariable = TemplateUtils.findVariable(buffer, "selection_end");
            if (selectStartVariable != null && selectStartVariable.getOffsets().length == 1) {
                this.select = new Region(selectStartVariable.getOffsets()[0], selectEndVariable != null && selectEndVariable.getOffsets().length == 1 ? Math.max(selectEndVariable.getOffsets()[0] - selectStartVariable.getOffsets()[0], 0) : 0);
            }
            this.lineDelimiter = lineDelimiter;
        }

        public void setContent(String content) {
            this.postEditDocument = null;
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public @Nullable IRegion getRegionToSelect() {
            return this.select;
        }

        public AbstractDocument startPostEdit() throws BadLocationException {
            if (this.postEditDocument == null) {
                this.postEditDocument = new Document(this.getContent()){

                    public String getDefaultLineDelimiter() {
                        return lineDelimiter;
                    }
                };
                if (this.select != null) {
                    this.postEditSelectPosition = new Position(this.select.getOffset(), this.select.getLength());
                    this.postEditDocument.addPosition(this.postEditSelectPosition);
                }
            }
            return this.postEditDocument;
        }

        public void finishPostEdit() {
            this.setContent(this.postEditDocument.get());
            if (this.postEditSelectPosition != null) {
                this.select = this.postEditSelectPosition.isDeleted ? null : new Region(this.postEditSelectPosition.getOffset(), this.postEditSelectPosition.getLength());
            }
        }
    }
}

