/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistProcessorCommandExtension;

@NonNullByDefault
public class MultiContentSectionQuickAssistProcessor
implements IQuickAssistProcessor,
QuickAssistProcessorCommandExtension {
    private static final Object NULL = new Object();
    private final DocContentSections sections;
    private final Map<String, Object> processors = new IdentityHashMap<String, Object>(8);
    private @Nullable String errorMessage;

    public MultiContentSectionQuickAssistProcessor(DocContentSections sections) {
        this.sections = (DocContentSections)ObjectUtils.nonNullAssert((Object)sections);
    }

    protected void registerProcessor(String sectionType, IQuickAssistProcessor processor) {
        if (sectionType == null) {
            throw new NullPointerException("sectionType");
        }
        this.processors.put(sectionType, processor != null ? processor : NULL);
    }

    protected final @Nullable IQuickAssistProcessor getProcessor(String sectionType) {
        if (sectionType == "") {
            return null;
        }
        Object processor = this.processors.get(sectionType);
        if (processor == null) {
            processor = NULL;
            try {
                IQuickAssistProcessor newProcessor = this.createProcessor(sectionType);
                if (newProcessor != null) {
                    processor = newProcessor;
                }
            }
            finally {
                this.processors.put(sectionType, processor);
            }
        }
        return processor != NULL ? (IQuickAssistProcessor)processor : null;
    }

    protected @Nullable IQuickAssistProcessor createProcessor(String sectionType) {
        return null;
    }

    public @Nullable IQuickAssistProcessor getProcessor(IQuickAssistInvocationContext invocationContext) {
        IDocument document;
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        if (sourceViewer == null || (document = sourceViewer.getDocument()) == null) {
            return null;
        }
        return this.getProcessor(this.sections.getType(document, invocationContext.getOffset()));
    }

    public boolean canFix(Annotation annotation) {
        return false;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public @NonNull ICompletionProposal @Nullable [] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        this.errorMessage = null;
        IQuickAssistProcessor processor = this.getProcessor(invocationContext);
        if (processor != null) {
            try {
                ICompletionProposal[] iCompletionProposalArray = processor.computeQuickAssistProposals(invocationContext);
                return iCompletionProposalArray;
            }
            finally {
                this.errorMessage = processor.getErrorMessage();
            }
        }
        return null;
    }

    public @Nullable String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public @Nullable AssistProposal findQuickAssist(IQuickAssistInvocationContext invocationContext, String commandId) {
        IQuickAssistProcessor processor = this.getProcessor(invocationContext);
        if (processor instanceof QuickAssistProcessorCommandExtension) {
            return ((QuickAssistProcessorCommandExtension)processor).findQuickAssist(invocationContext, commandId);
        }
        return null;
    }
}

