/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractVetoableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

@NonNullByDefault
public class SnippetEditorObservable
extends AbstractVetoableValue<String> {
    private final StyledText text;
    private boolean updating = false;
    private final int updateEventType;
    private static final int[] validUpdateEventTypes;
    private String oldValue;
    private final Listener updateListener = new Listener(){

        public void handleEvent(Event event) {
            String newValue;
            if (!SnippetEditorObservable.this.updating && !(newValue = SnippetEditorObservable.this.text.getText()).equals(SnippetEditorObservable.this.oldValue)) {
                SnippetEditorObservable.this.fireValueChange(Diffs.createValueDiff((Object)SnippetEditorObservable.this.oldValue, (Object)newValue));
                SnippetEditorObservable.this.oldValue = newValue;
            }
        }
    };
    private final VerifyListener verifyListener;

    static {
        int[] nArray = new int[3];
        nArray[0] = 24;
        nArray[1] = 16;
        validUpdateEventTypes = nArray;
    }

    public SnippetEditorObservable(SnippetEditor editor, int updateEventType) {
        super(DisplayRealm.getRealm((Display)editor.getControl().getDisplay()));
        boolean eventValid = false;
        int i = 0;
        while (!eventValid && i < validUpdateEventTypes.length) {
            eventValid = updateEventType == validUpdateEventTypes[i];
            ++i;
        }
        if (!eventValid) {
            throw new IllegalArgumentException("UpdateEventType [" + updateEventType + "] is not supported.");
        }
        this.text = editor.getSourceViewer().getTextWidget();
        this.updateEventType = updateEventType;
        if (updateEventType != 0) {
            this.text.addListener(updateEventType, this.updateListener);
        }
        this.oldValue = this.text.getText();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String newText;
                String currentText;
                if (!SnippetEditorObservable.this.updating && !SnippetEditorObservable.this.fireValueChanging(Diffs.createValueDiff((Object)(currentText = SnippetEditorObservable.this.text.getText()), (Object)(newText = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end))))) {
                    e.doit = false;
                }
            }
        };
        this.text.addVerifyListener(this.verifyListener);
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SnippetEditorObservable.this.dispose();
            }
        });
    }

    protected void doSetApprovedValue(String value) {
        try {
            this.updating = true;
            this.text.setText(value == null ? "" : value.toString());
            this.oldValue = this.text.getText();
        }
        finally {
            this.updating = false;
        }
    }

    public String doGetValue() {
        this.oldValue = this.text.getText();
        return this.oldValue;
    }

    public Object getValueType() {
        return String.class;
    }

    public void dispose() {
        if (!this.text.isDisposed()) {
            if (this.updateEventType != 0) {
                this.text.removeListener(this.updateEventType, this.updateListener);
            }
            this.text.removeVerifyListener(this.verifyListener);
        }
        super.dispose();
    }
}

