/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.ui.processing;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.YamlBlockWeaveParticipant;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.yaml.core.source.ast.Collection;
import org.eclipse.statet.yaml.core.source.ast.MapEntry;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.SourceComponent;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;
import org.eclipse.statet.yaml.core.source.ast.YamlParser;

@NonNullByDefault
public class YamlFormatDetector {
    private static final String FAIL = "<fail>";
    private final String modelTypeId;
    private @Nullable Matcher extValidator;

    public YamlFormatDetector(String modelTypeId) {
        this.modelTypeId = modelTypeId;
    }

    public String detect(IFile file, SubMonitor m) throws CoreException {
        m.beginTask(NLS.bind((String)"Detecting output format of ''{0}''...", (Object)file.getName()), 10);
        SourceUnit sourceUnit = LtkModels.getSourceUnitManager().getSourceUnit(this.modelTypeId, Ltk.PERSISTENCE_CONTEXT, (Object)file, true, (IProgressMonitor)m.newChild(1));
        try {
            SourceContent content = sourceUnit.getContent((IProgressMonitor)m.newChild(1));
            m.worked(0);
            TextRegion yamlRegion = this.getYamlBlockRegion(content);
            m.worked(1);
            YamlParser yamlParser = new YamlParser();
            yamlParser.setScalarText(true);
            String code = content.getString(yamlRegion);
            SourceComponent block = yamlParser.parseSourceUnit(code, yamlRegion.getStartOffset(), null);
            String format = this.searchOutputInfo(block, code);
            String ext = this.toExtension(format);
            if (!this.isValidExt(ext)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)"Failed to detect file extension for format ''{0}''.", (Object)format)));
            }
            String string = ext;
            return string;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.wikitext.r", 0, NLS.bind((String)"Failed to detect output format specified in doc (YAML) for ''{0}''.", (Object)file.getName()), (Throwable)e));
        }
        finally {
            if (sourceUnit != null) {
                sourceUnit.disconnect((IProgressMonitor)m);
            }
        }
    }

    private TextRegion getYamlBlockRegion(SourceContent sourceContent) throws BadLocationException, CoreException {
        TextLineInformation lines = sourceContent.getStringLines();
        YamlBlockWeaveParticipant part = new YamlBlockWeaveParticipant();
        part.reset(sourceContent);
        int lineEndOffset = lines.getStartOffset(0);
        int numLines = lines.getNumberOfLines();
        int line = 0;
        while (line < numLines) {
            int lineOffset = lineEndOffset;
            if (part.checkStartLine(lineOffset, lineEndOffset = lines.getEndOffset(line))) {
                while (++line < numLines) {
                    lineOffset = lineEndOffset;
                    if (!part.checkEndLine(lineOffset, lineEndOffset = lines.getEndOffset(line))) continue;
                    return new BasicTextRegion(sourceContent.getStartOffset() + part.getStartOffset(), sourceContent.getStartOffset() + lineEndOffset);
                }
            }
            ++line;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.wikitext.r", "No YAML metadata block found."));
    }

    private String searchOutputInfo(SourceComponent block, String code) throws CoreException, InvocationTargetException {
        class Searcher
        extends YamlAstVisitor {
            private @Nullable String format;
            private @Nullable String output;
            private @Nullable String outputFormat;

            Searcher() {
            }

            public void visit(Collection node) throws InvocationTargetException {
                if (node.getYamlParent().getNodeType() == NodeType.DOCUMENT && node.getNodeType() == NodeType.MAP) {
                    node.acceptInYamlChildren((YamlAstVisitor)this);
                }
            }

            public void visit(MapEntry node) throws InvocationTargetException {
                block15: {
                    if (node.getKey().getNodeType() != NodeType.SCALAR) break block15;
                    switch ((String)ObjectUtils.nonNullElse((Object)node.getKey().getText(), (Object)"")) {
                        case "format": {
                            if (this.format != null) break;
                            if (node.getValue().getNodeType() == NodeType.SCALAR) {
                                this.format = node.getValue().getText();
                            }
                            if (this.format != null) break;
                            this.format = YamlFormatDetector.FAIL;
                            break;
                        }
                        case "output": {
                            if (this.output != null) break;
                            switch (node.getValue().getNodeType()) {
                                case SCALAR: {
                                    this.output = node.getValue().getText();
                                    break;
                                }
                                case SEQ: 
                                case MAP: {
                                    YamlAstNode firstOutput;
                                    if (!node.getValue().hasChildren() || (firstOutput = node.getValue().getChild(0)).getNodeType() != NodeType.MAP_ENTRY) break;
                                    this.checkOutputEntry((MapEntry)firstOutput);
                                    break;
                                }
                            }
                            if (this.output != null) break;
                            this.output = YamlFormatDetector.FAIL;
                            break;
                        }
                    }
                }
            }

            private void checkOutputEntry(MapEntry outputEntry) {
                if (outputEntry.getKey().getNodeType() == NodeType.SCALAR) {
                    this.output = outputEntry.getKey().getText();
                }
                if (outputEntry.getValue().getNodeType() == NodeType.MAP) {
                    YamlAstNode outputConfig = outputEntry.getValue();
                    int i = 0;
                    while (i < outputConfig.getChildCount()) {
                        MapEntry outputConfigEntry;
                        YamlAstNode iChild = outputConfig.getChild(i);
                        if (iChild.getNodeType() == NodeType.MAP_ENTRY && (outputConfigEntry = (MapEntry)iChild).getKey().getNodeType() == NodeType.SCALAR && "format".equals(outputConfigEntry.getKey().getText()) && outputConfigEntry.getValue().getNodeType() == NodeType.SCALAR) {
                            this.outputFormat = outputConfigEntry.getValue().getText();
                        }
                        ++i;
                    }
                }
            }
        }
        Searcher searcher = new Searcher();
        block.acceptInYaml((YamlAstVisitor)searcher);
        if (searcher.format != null) {
            if (searcher.format == FAIL) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "Unexpected data for 'format'.\nYAML code:\n" + code));
            }
            return searcher.format;
        }
        if (searcher.output != null) {
            if (searcher.outputFormat != null && this.isValidExt(this.toExtension(searcher.outputFormat))) {
                return searcher.outputFormat;
            }
            if (searcher.output == FAIL) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "Unexpected data for 'output'.\nYAML code:\n" + code));
            }
            return searcher.output;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "No 'format' or 'output' entry found.\nYAML code:\n" + code));
    }

    private String toExtension(String format) {
        int idx = format.lastIndexOf(58);
        if (idx >= 0) {
            format = format.substring(idx + 1);
        }
        if ((idx = format.indexOf(95)) >= 0) {
            format = format.substring(0, idx);
        }
        switch (format) {
            case "native": {
                return "hs";
            }
            case "plain": {
                return "txt";
            }
            case "markdown": {
                return "md";
            }
            case "mediawiki": {
                return "mediawiki";
            }
            case "textile": {
                return "textile";
            }
            case "asciidoc": {
                return "asciidoc";
            }
            case "html": 
            case "html5": {
                return "html";
            }
            case "beamer": 
            case "pdf": 
            case "latex": {
                return "pdf";
            }
            case "context": {
                return "tex";
            }
            case "texinfo": {
                return "texi";
            }
            case "docbook": {
                return "dbk";
            }
            case "opendocument": 
            case "odt": {
                return "odt";
            }
            case "docx": 
            case "word": {
                return "docx";
            }
            case "rtf": {
                return "rtf";
            }
            case "epub": 
            case "epub3": {
                return "epub";
            }
            case "dzslides": 
            case "slideous": 
            case "revealjs": 
            case "s5": 
            case "slidy": {
                return "html";
            }
        }
        return format;
    }

    private boolean isValidExt(String ext) {
        Matcher extValidator = this.extValidator;
        if (extValidator == null) {
            this.extValidator = extValidator = DocProcessingConfig.VALID_EXT_PATTERN.matcher(ext);
        } else {
            extValidator.reset(ext);
        }
        return extValidator.matches();
    }
}

