/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.IToolEventHandler;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolMessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class LoginHandler
implements IToolEventHandler {
    private static final String SECURE_PREF_ROOT = "/statet/nico";
    private static final String SECURE_PREF_CHARSET = "UTF-8";
    private static final String SECURE_PREF_NAME_KEY = "name";
    private static final String SECURE_PREF_PASSWORD_KEY = "password";

    public Status execute(String id, ToolService service, final ToolCommandData data, ProgressMonitor m) {
        Callback[] callbacks;
        ConsoleService console = (ConsoleService)service;
        final boolean saveAllowed = data.getBoolean("save.allowed", true);
        final boolean saveActivated = data.getBoolean("save.activated", false);
        Callback[] callbackArray = callbacks = (Callback[])data.getRequired("callbacks", Callback[].class);
        int n = callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            Callback callback = callbackArray[n2];
            if (!(callback instanceof TextOutputCallback || callback instanceof NameCallback || callback instanceof PasswordCallback || callback instanceof TextInputCallback)) {
                ErrorStatus status = new ErrorStatus("org.eclipse.statet.nico.ui", Messages.Login_error_UnsupportedOperation_message, (Throwable)new UnsupportedCallbackException(callback));
                StatusManager.getManager().handle(StatusUtils.convert((Status)status), 3);
                return status;
            }
            ++n2;
        }
        final ToolProcess process = console.getTool();
        if (id.equals("common/login.request")) {
            if (saveAllowed && data.getInt("attempt", -1) == 1 && this.readData(callbacks, this.getDataNode(process, data, false), data)) {
                return Status.OK_STATUS;
            }
            final String message = data.getString("message");
            if (callbacks.length == 0) {
                return Status.OK_STATUS;
            }
            final AtomicReference<Status> result = new AtomicReference<Status>(Status.CANCEL_STATUS);
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow((boolean)true);
                    LoginDialog dialog = new LoginDialog(process, window.getShell());
                    dialog.message = message;
                    dialog.callbacks = callbacks;
                    dialog.allowSave = saveAllowed;
                    dialog.save = saveActivated;
                    if (dialog.open() == 0) {
                        data.setReturnData("save.activated", (Object)(dialog.allowSave && dialog.save ? 1 : 0));
                        data.setReturnData("username", (Object)dialog.username);
                        result.set(Status.OK_STATUS);
                    } else {
                        data.setReturnData("save.activated", null);
                    }
                }
            });
            return result.get();
        }
        if (id.equals("common/login.ok")) {
            if (saveAllowed && saveActivated && this.saveData(callbacks, this.getDataNode(process, data, true))) {
                return Status.OK_STATUS;
            }
            return Status.OK_STATUS;
        }
        throw new UnsupportedOperationException();
    }

    private boolean readData(Callback[] callbacks, @Nullable ISecurePreferences node, ToolCommandData data) {
        try {
            int nameCount = 0;
            int passwordCount = 0;
            boolean complete = true;
            Charset charset = Charset.forName(SECURE_PREF_CHARSET);
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                if (!(callback instanceof TextOutputCallback)) {
                    if (callback instanceof NameCallback) {
                        String name;
                        NameCallback nameCallback = (NameCallback)callback;
                        String string = name = node != null ? node.get(SECURE_PREF_NAME_KEY + nameCount++, null) : null;
                        if (name == null || name.isEmpty() || Boolean.TRUE.equals(data.get("username.force", Boolean.class))) {
                            name = (String)data.get("username", String.class);
                        }
                        if (name != null && name.length() > 0) {
                            nameCallback.setName(name);
                            data.setReturnData("username", (Object)name);
                        } else {
                            complete = false;
                        }
                    } else if (callback instanceof PasswordCallback) {
                        byte[] array;
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        byte[] byArray = array = node != null ? node.getByteArray(SECURE_PREF_PASSWORD_KEY + passwordCount++, null) : null;
                        if (array != null) {
                            char[] password = charset.decode(ByteBuffer.wrap(array)).array();
                            passwordCallback.setPassword(password);
                            Arrays.fill(array, (byte)0);
                            Arrays.fill(password, '\u0000');
                        }
                    } else if (callback instanceof TextInputCallback) {
                        complete = false;
                    }
                }
                ++n2;
            }
            return complete;
        }
        catch (Exception e) {
            NicoUIPlugin.logError(-1, Messages.Login_Safe_error_Loading_message, e);
            return false;
        }
    }

    private boolean saveData(Callback[] callbacks, @Nullable ISecurePreferences node) {
        if (node == null) {
            return false;
        }
        try {
            int nameCount = 0;
            int passwordCount = 0;
            boolean complete = true;
            Charset charset = Charset.forName(SECURE_PREF_CHARSET);
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                if (!(callback instanceof TextOutputCallback)) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        node.put(SECURE_PREF_NAME_KEY + nameCount++, nameCallback.getName(), true);
                    } else if (callback instanceof PasswordCallback) {
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        char[] password = passwordCallback.getPassword();
                        byte[] array = charset.encode(CharBuffer.wrap(password)).array();
                        node.putByteArray(SECURE_PREF_PASSWORD_KEY + passwordCount++, array, true);
                        Arrays.fill(password, '\u0000');
                        Arrays.fill(array, (byte)0);
                    } else if (callback instanceof TextInputCallback) {
                        complete = false;
                    }
                }
                ++n2;
            }
            return true;
        }
        catch (Exception e) {
            NicoUIPlugin.logError(-1, Messages.Login_Safe_error_Saving_message, e);
            return false;
        }
    }

    private @Nullable ISecurePreferences getDataNode(ToolProcess process, ToolCommandData data, boolean create) {
        String id = data.getString("address");
        if (id == null) {
            return null;
        }
        ISecurePreferences store = SecurePreferencesFactory.getDefault();
        if (store == null) {
            return null;
        }
        String path = "/statet/nico/" + EncodingUtils.encodeSlashes((String)process.getMainType()) + '/' + EncodingUtils.encodeSlashes((String)id);
        if (!create && !store.nodeExists(path)) {
            return null;
        }
        return store.node(path);
    }

    private static class LoginDialog
    extends ToolMessageDialog {
        private @Nullable String message;
        private Callback[] callbacks;
        private boolean allowSave;
        private Button saveControl;
        private boolean save;
        private String username;
        private final List<Runnable> okRunners = new ArrayList<Runnable>();

        public LoginDialog(ToolProcess process, Shell shell) {
            super(process, shell, Messages.Login_Dialog_title, null, Messages.Login_Dialog_message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Control createMessageArea(Composite parent) {
            super.createMessageArea(parent);
            LayoutUtils.addGDDummy((Composite)parent);
            Composite inputComposite = new Composite(parent, 0);
            inputComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            inputComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
            if (this.message != null) {
                Label label = new Label(inputComposite, 64);
                label.setText(this.message);
                label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                LayoutUtils.addSmallFiller((Composite)inputComposite, (boolean)false);
            }
            Callback[] callbackArray = this.callbacks;
            int n = this.callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                String init;
                GridData gd;
                Text field;
                Label label;
                Callback callback = callbackArray[n2];
                if (callback instanceof TextOutputCallback) {
                    TextOutputCallback outputCallback = (TextOutputCallback)callback;
                    Label icon = new Label(inputComposite, 16384);
                    switch (outputCallback.getMessageType()) {
                        case 2: {
                            icon.setImage(Display.getCurrent().getSystemImage(1));
                            break;
                        }
                        case 1: {
                            icon.setImage(Display.getCurrent().getSystemImage(8));
                            break;
                        }
                        default: {
                            icon.setImage(Display.getCurrent().getSystemImage(2));
                        }
                    }
                    icon.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
                    Label label2 = new Label(inputComposite, 64);
                    label2.setText(outputCallback.getMessage());
                    label2.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                } else if (callback instanceof NameCallback) {
                    final NameCallback nameCallback = (NameCallback)callback;
                    label = new Label(inputComposite, 16384);
                    label.setText(String.valueOf(nameCallback.getPrompt()) + ':');
                    label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
                    field = new Text(inputComposite, 18432);
                    gd = new GridData(4, 0x1000000, true, false, 1, 1);
                    gd.widthHint = LayoutUtils.hintWidth((Text)field, (int)25);
                    field.setLayoutData((Object)gd);
                    init = nameCallback.getName();
                    if (init == null || init.isEmpty()) {
                        init = nameCallback.getDefaultName();
                    }
                    if (init != null) {
                        field.setText(init);
                    }
                    this.okRunners.add(new Runnable(){

                        @Override
                        public void run() {
                            if (username == null) {
                                username = field.getText();
                            }
                            nameCallback.setName(field.getText());
                        }
                    });
                } else if (callback instanceof PasswordCallback) {
                    final PasswordCallback passwordCallback = (PasswordCallback)callback;
                    label = new Label(inputComposite, 16384);
                    label.setText(String.valueOf(passwordCallback.getPrompt()) + ':');
                    label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
                    field = new Text(inputComposite, 0x404800);
                    gd = new GridData(4, 0x1000000, true, false, 1, 1);
                    gd.widthHint = LayoutUtils.hintWidth((Text)field, (int)25);
                    field.setLayoutData((Object)gd);
                    field.setTextLimit(50);
                    this.okRunners.add(new Runnable(){

                        @Override
                        public void run() {
                            passwordCallback.setPassword(field.getText().toCharArray());
                        }
                    });
                } else if (callback instanceof TextInputCallback) {
                    final TextInputCallback inputCallback = (TextInputCallback)callback;
                    label = new Label(inputComposite, 16384);
                    label.setText(String.valueOf(inputCallback.getPrompt()) + ':');
                    label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
                    field = new Text(inputComposite, 0x404800);
                    gd = new GridData(4, 0x1000000, true, false, 1, 1);
                    gd.widthHint = LayoutUtils.hintWidth((Text)field, (int)25);
                    field.setLayoutData((Object)gd);
                    init = inputCallback.getText();
                    if (init == null || init.isEmpty()) {
                        init = inputCallback.getDefaultText();
                    }
                    if (init != null) {
                        field.setText(init);
                    }
                    this.okRunners.add(new Runnable(){

                        @Override
                        public void run() {
                            inputCallback.setText(field.getText());
                        }
                    });
                }
                ++n2;
            }
            if (this.allowSave) {
                LayoutUtils.addSmallFiller((Composite)inputComposite, (boolean)false);
                this.saveControl = new Button(inputComposite, 32);
                this.saveControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
                this.saveControl.setText(Messages.Login_Dialog_Save_label);
                this.saveControl.setSelection(false);
            }
            return parent;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.okPressed();
            }
            super.buttonPressed(buttonId);
        }

        protected void okPressed() {
            if (this.saveControl != null) {
                this.save = this.saveControl.getSelection();
            }
            for (Runnable runnable : this.okRunners) {
                runnable.run();
            }
            super.okPressed();
        }
    }
}

