/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.ViewerSourceEditorAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class SourceViewerInformationControl
extends AbstractInformationControl {
    private static final int MODE_SIMPLE = 1;
    private static final int MODE_FOCUS = 2;
    private final int mode;
    private Composite contentComposite;
    private StyledText text;
    private SourceViewer viewer;
    private final SourceEditorViewerConfigurator configurator;
    private IInformationControlCreator informationCreator;
    private final int orientation;

    public SourceViewerInformationControl(Shell parent, SourceEditorViewerConfigurator configurator, int orientation, IInformationControlCreator informationCreator) {
        super(parent, EditorsUI.getTooltipAffordanceString());
        assert (orientation == 0x4000000 || orientation == 0x2000000 || orientation == 0);
        this.mode = 1;
        this.configurator = configurator;
        this.orientation = orientation;
        this.informationCreator = informationCreator;
        this.create();
    }

    public SourceViewerInformationControl(Shell parent, SourceEditorViewerConfigurator configurator, int orientation) {
        super(parent, true);
        assert (orientation == 0x4000000 || orientation == 0x2000000 || orientation == 0);
        this.mode = 2;
        this.configurator = configurator;
        this.orientation = orientation;
        this.create();
    }

    protected void createContent(Composite parent) {
        this.contentComposite = new Composite(parent, 0){

            public Point computeSize(int width, int height, boolean changed) {
                return super.computeSize(width, height, changed || width != this.getSize().x);
            }
        };
        this.contentComposite.setBackground(parent.getBackground());
        GridLayout gridLayout = LayoutUtils.newCompositeGrid((int)1);
        this.contentComposite.setLayout((Layout)gridLayout);
        int vIndent = Math.max(1, LayoutUtils.defaultVSpacing() / 4);
        int hIndent = Math.max(2, LayoutUtils.defaultHSpacing() / 3);
        this.viewer = new SourceViewer(this.contentComposite, null, null, false, (this.mode == 2 ? 768 : 0) | 2 | 8 | this.orientation);
        this.viewer.setEditable(false);
        ViewerSourceEditorAdapter editor = new ViewerSourceEditorAdapter(this.viewer, this.configurator);
        this.configurator.setTarget(editor);
        this.text = this.viewer.getTextWidget();
        GridData gd = new GridData(4, 4, true, true);
        this.text.setLayoutData((Object)gd);
        this.text.setFont(JFaceResources.getTextFont());
        this.text.setIndent(hIndent);
        this.setBackgroundColor(this.getShell().getDisplay().getSystemColor(29));
        this.setForegroundColor(this.getShell().getDisplay().getSystemColor(28));
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
        this.text.setBackground(background);
    }

    public void setForegroundColor(Color foreground) {
        super.setForegroundColor(foreground);
        this.text.setForeground(foreground);
    }

    public void setInformation(String content) {
        if (content == null) {
            this.viewer.setInput(null);
            return;
        }
        if (content.length() > 2 && content.charAt(content.length() - 1) == '\n') {
            content = content.charAt(content.length() - 2) == '\r' ? content.substring(0, content.length() - 2) : content.substring(0, content.length() - 1);
        }
        Document document = new Document(content);
        this.configurator.getDocumentSetupParticipant().setup((IDocument)document);
        this.viewer.setInput((Object)document);
    }

    public final void dispose() {
        if (this.configurator != null) {
            this.configurator.unconfigureTarget();
        }
        super.dispose();
        this.text = null;
    }

    public void setFocus() {
        this.text.setFocus();
        super.setFocus();
    }

    public boolean hasContents() {
        return this.text.getCharCount() > 0;
    }

    protected ISourceViewer getViewer() {
        return this.viewer;
    }

    public Point computeSizeHint() {
        int widthMax;
        Point sizeConstraints = this.getSizeConstraints();
        Rectangle trim = this.computeTrim();
        int widthHint = this.text.computeSize((int)-1, (int)-1, (boolean)true).x + LayoutUtils.defaultHSpacing();
        if (widthHint > (widthMax = (sizeConstraints != null && sizeConstraints.x != -1 ? sizeConstraints.x : LayoutUtils.hintWidth((StyledText)this.text, null, (int)80)) - trim.width)) {
            widthHint = widthMax;
        }
        int heightMax = (sizeConstraints != null && sizeConstraints.y != -1 ? sizeConstraints.y : this.text.getLineHeight() * 12) - trim.height;
        Point size = this.contentComposite.computeSize(widthHint, -1, false);
        size.x = Math.max(Math.min(size.x, widthMax), 200) + trim.width;
        size.y = Math.max(Math.min(size.y, heightMax), 80) + trim.height;
        return size;
    }

    public Rectangle computeTrim() {
        Rectangle trim = super.computeTrim();
        Rectangle textTrim = this.text.computeTrim(0, 0, 0, 0);
        trim.x += textTrim.x;
        trim.y += textTrim.y;
        trim.width += textTrim.width;
        trim.height += textTrim.height;
        return trim;
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        GC gc = new GC((Drawable)this.text);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            double width = gc.getFontMetrics().getAverageCharacterWidth() * (double)widthInChars;
            int height = gc.getFontMetrics().getHeight() * heightInChars;
            Point point = new Point((int)Math.round(width + 0.4999997615814209), height);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return this.informationCreator;
    }
}

