/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.ui.editors;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.assist.LinkedModeBracketLevel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class YamlBracketLevel
extends LinkedModeBracketLevel {
    public static LinkedModeBracketLevel.InBracketPosition createPosition(char c, IDocument document, int offset, int length, int sequence) {
        switch (c) {
            case '{': {
                return new CurlyBracketPosition(document, offset, length, sequence);
            }
            case '[': {
                return new SquareBracketPosition(document, offset, length, sequence);
            }
            case '\"': {
                return new QuotedDPosition(document, offset, length, sequence);
            }
            case '\'': {
                return new QuotedSPosition(document, offset, length, sequence);
            }
        }
        throw new IllegalArgumentException("Invalid position type: " + c);
    }

    public YamlBracketLevel(LinkedModeModel model, IDocument document, DocContentSections docContentSections, List<? extends LinkedPosition> positions, int mode) {
        super(model, document, docContentSections, positions, mode);
    }

    public static final class CurlyBracketPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public CurlyBracketPosition(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public char getOpenChar() {
            return '{';
        }

        public char getCloseChar() {
            return '}';
        }
    }

    public static final class QuotedDPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public QuotedDPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '\"';
        }

        public char getCloseChar() {
            return '\"';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return TextUtil.countBackward((IDocument)this.getDocument(), (int)offset, (char)'\\') % 2 == 1;
        }
    }

    public static final class QuotedSPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public QuotedSPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '\'';
        }

        public char getCloseChar() {
            return '\'';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            IDocument document = this.getDocument();
            return TextUtil.countBackward((IDocument)document, (int)offset, (char)'\'') % 2 == 1 || offset + 1 < document.getLength() && document.getChar(offset + 1) == '\'';
        }
    }

    public static final class SquareBracketPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public SquareBracketPosition(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public char getOpenChar() {
            return '[';
        }

        public char getCloseChar() {
            return ']';
        }
    }
}

