/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.ConsoleMessageCmdItem;
import org.eclipse.statet.rj.server.ConsoleReadCmdItem;
import org.eclipse.statet.rj.server.ConsoleWriteCmdItem;
import org.eclipse.statet.rj.server.DataCmdItem;
import org.eclipse.statet.rj.server.DbgCmdItem;
import org.eclipse.statet.rj.server.ExtClientCmdItem;
import org.eclipse.statet.rj.server.GDCmdItem;
import org.eclipse.statet.rj.server.GraOpCmdItem;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.MainCtrlCmdItem;
import org.eclipse.statet.rj.server.RjsComObject;

@NonNullByDefault
public final class MainCmdC2SList
implements RjsComObject,
Externalizable {
    private final @Nullable RJIO privateIO;
    private @Nullable MainCmdItem first;

    public MainCmdC2SList(RJIO io) {
        this.privateIO = io;
    }

    public MainCmdC2SList() {
        this.privateIO = null;
        this.first = null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        RJIO io;
        if (this.privateIO != null) {
            io = this.privateIO;
            io.connect(out);
        } else {
            io = RJIO.get((ObjectOutput)out);
        }
        int check = io.writeCheck1();
        MainCmdItem item = this.first;
        if (item != null) {
            do {
                out.writeByte(item.getCmdType());
                item.writeExternal(io);
            } while ((item = item.next) != null);
        }
        out.writeByte(0);
        io.writeCheck2(check);
        io.disconnect(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        RJIO io = RJIO.get((ObjectInput)in);
        try {
            MainCmdItem item;
            int check = io.readCheck1();
            byte cmdType = in.readByte();
            if (cmdType == 0) {
                this.first = null;
                io.readCheck2(check);
                return;
            }
            this.first = item = this.readItem(cmdType, io);
            while (true) {
                if ((cmdType = in.readByte()) == 0) {
                    io.readCheck2(check);
                    return;
                }
                item = item.next = this.readItem(cmdType, io);
            }
        }
        finally {
            io.disconnect(in);
        }
    }

    private MainCmdItem readItem(byte cmdType, RJIO io) throws IOException, ClassNotFoundException {
        switch (cmdType) {
            case 1: {
                return new ConsoleReadCmdItem(io);
            }
            case 2: {
                return new ConsoleWriteCmdItem(io);
            }
            case 4: {
                return new ConsoleMessageCmdItem(io);
            }
            case 5: {
                return new ExtClientCmdItem(io);
            }
            case 7: {
                return new GDCmdItem.Answer(io);
            }
            case 16: {
                return new MainCtrlCmdItem(io);
            }
            case 17: {
                return new DataCmdItem(io);
            }
            case 18: {
                return new GraOpCmdItem(io);
            }
            case 20: {
                return new DbgCmdItem(io);
            }
        }
        throw new ClassNotFoundException("Unknown cmdtype id: " + cmdType);
    }

    public void clear() {
        this.first = null;
    }

    public void setObjects(MainCmdItem first) {
        this.first = first;
    }

    @Override
    public int getComType() {
        return 3;
    }

    public @Nullable MainCmdItem getItems() {
        return this.first;
    }

    public boolean testEquals(MainCmdC2SList other) {
        MainCmdItem thisItem = this.first;
        MainCmdItem otherItem = other.first;
        while (thisItem != null && otherItem != null) {
            if (!thisItem.equals(otherItem)) {
                return false;
            }
            thisItem = thisItem.next;
            otherItem = otherItem.next;
        }
        return thisItem == null && otherItem == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("MainCmdC2SList (");
        sb.append("):");
        if (this.first == null) {
            sb.append("\n<ITEM/>");
        } else {
            MainCmdItem item = this.first;
            int i = 0;
            while (item != null) {
                sb.append("\n<ITEM i=\"");
                sb.append(i);
                sb.append("\">\n");
                sb.append(item.toString());
                sb.append("\n</ITEM>");
                item = item.next;
                ++i;
            }
        }
        return sb.toString();
    }
}

