/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RUniqueCharacter32Store;

public class RUniqueCharacterHash32Store
extends RUniqueCharacter32Store {
    private final HashMap<String, Integer> map = new HashMap();

    public RUniqueCharacterHash32Store(String[] names) {
        super(names);
        this.initMap();
    }

    RUniqueCharacterHash32Store(RCharacter32Store source, boolean reuse) {
        super(source, reuse);
        this.initMap();
    }

    public RUniqueCharacterHash32Store(RJIO io, int length) throws IOException {
        super(io, length);
        this.initMap();
    }

    protected void initMap() {
        int length = (int)this.getLength();
        int idx = 0;
        while (idx < length) {
            if (this.charValues[idx] != null) {
                this.map.put(this.charValues[idx], idx);
            }
            ++idx;
        }
    }

    @Override
    public void setChar(int idx, String value) {
        String previous = this.getChar(idx);
        super.setChar(idx, value);
        this.map.remove(previous);
        this.map.put(value, idx);
    }

    @Override
    public void setChar(long idx, String value) {
        if (idx < 0L || idx >= this.getLength()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.setChar((int)idx, value);
    }

    @Override
    public void insertChar(int idx, String name) {
        super.insertChar(idx, name);
        this.map.put(name, idx);
    }

    @Override
    public void remove(int idx) {
        this.map.remove(this.getChar(idx));
        super.remove(idx);
    }

    @Override
    public boolean contains(String value) {
        return value != null && this.map.containsKey(value);
    }

    @Override
    public long indexOf(String name, long fromIdx) {
        return this.map.get(name).intValue();
    }
}

