/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RS4Object;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;

@NonNullByDefault
public class RS4ObjectImpl
extends AbstractRObject
implements RS4Object,
ExternalizableRObject {
    private String className;
    private int dataSlotIdx;
    private RCharacter32Store slotNames;
    private RObject[] slotValues;

    public RS4ObjectImpl(String className, String[] slotNames, RObject[] slotValues) {
        if (className == null || slotNames == null || slotValues == null) {
            throw new NullPointerException();
        }
        this.className = className;
        this.slotNames = new RCharacter32Store(slotNames);
        this.dataSlotIdx = this.slotNames.indexOf(".Data", 0);
        this.slotValues = slotValues;
    }

    public RS4ObjectImpl(RJIO io, RObjectFactory factory) throws IOException {
        this.readExternal(io, factory);
    }

    public void readExternal(RJIO io, RObjectFactory factory) throws IOException {
        int options = io.readInt();
        this.className = io.readString();
        int l = (int)io.readVULong((byte)(options & 7));
        this.dataSlotIdx = io.readInt();
        this.slotNames = new RCharacter32Store(io, l);
        this.slotValues = new RObject[l];
        int i = 0;
        while (i < l) {
            this.slotValues[i] = factory.readObject(io);
            ++i;
        }
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        int l = this.slotValues.length;
        byte options = io.getVULongGrade(l);
        io.writeInt(options);
        io.writeString(this.className);
        io.writeVULong((byte)(options & 7), l);
        io.writeInt(this.dataSlotIdx);
        this.slotNames.writeExternal(io);
        int i = 0;
        while (i < l) {
            factory.writeObject(this.slotValues[i], io);
            ++i;
        }
    }

    @Override
    public byte getRObjectType() {
        return 10;
    }

    @Override
    public String getRClassName() {
        return this.className;
    }

    @Override
    public long getLength() {
        return this.slotValues.length;
    }

    @Override
    public boolean hasDataSlot() {
        return this.dataSlotIdx >= 0;
    }

    @Override
    public @Nullable RObject getDataSlot() {
        return this.dataSlotIdx >= 0 ? this.slotValues[this.dataSlotIdx] : null;
    }

    @Override
    public @Nullable RStore<?> getData() {
        return this.dataSlotIdx >= 0 && this.slotValues[this.dataSlotIdx] != null ? this.slotValues[this.dataSlotIdx].getData() : null;
    }

    @Override
    public RCharacterStore getNames() {
        return this.slotNames;
    }

    @Override
    public String getName(int idx) {
        return this.slotNames.getChar(idx);
    }

    @Override
    public String getName(long idx) {
        return this.slotNames.getChar(idx);
    }

    @Override
    public RObject get(int idx) {
        return this.slotValues[idx];
    }

    @Override
    public RObject get(long idx) {
        if (idx < 0L || idx >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.slotValues[(int)idx];
    }

    @Override
    public RObject get(String name) {
        int idx = this.slotNames.indexOf(name, 0);
        if (idx >= 0) {
            return this.slotValues[idx];
        }
        throw new IllegalArgumentException();
    }

    public void insert(int idx, String name, RObject component) {
        throw new UnsupportedOperationException();
    }

    public void add(String name, RObject component) {
        throw new UnsupportedOperationException();
    }

    public void remove(int idx) {
        throw new UnsupportedOperationException();
    }

    public boolean set(int idx, RObject value) {
        this.slotValues[idx] = value;
        return true;
    }

    public boolean set(String name, RObject component) {
        if (this.dataSlotIdx >= 0 && name.equals(".Data")) {
            this.slotValues[this.dataSlotIdx] = component;
            return true;
        }
        int i = this.slotNames.indexOf(name, 0);
        if (i >= 0) {
            this.slotValues[i] = component;
            return true;
        }
        return false;
    }
}

