/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RLogicalStore;
import org.eclipse.statet.rj.data.RNumericStore;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RRawStore;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;

@NonNullByDefault
public class RDataUtils {
    public static final String getStoreAbbr(RStore<?> store) {
        switch (store.getStoreType()) {
            case 1: {
                return "logi";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "num";
            }
            case 5: {
                return "chr";
            }
            case 4: {
                return "cplx";
            }
            case 6: {
                return "raw";
            }
            case 10: {
                return ((RFactorStore)store).isOrdered() ? "ordered" : "factor";
            }
        }
        return "";
    }

    public static final String getStoreClass(RStore<?> store) {
        switch (store.getStoreType()) {
            case 1: {
                return "logical";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "numeric";
            }
            case 5: {
                return "character";
            }
            case 4: {
                return "complex";
            }
            case 6: {
                return "raw";
            }
            case 10: {
                return ((RFactorStore)store).isOrdered() ? "ordered" : "factor";
            }
        }
        return "";
    }

    public static final String getStoreMode(int storeType) {
        switch (storeType) {
            case 1: {
                return "logical";
            }
            case 2: 
            case 10: {
                return "integer";
            }
            case 3: {
                return "numeric";
            }
            case 5: {
                return "character";
            }
            case 4: {
                return "complex";
            }
            case 6: {
                return "raw";
            }
        }
        return "";
    }

    public static final String getObjectTypeName(byte type) {
        switch (type) {
            case 1: {
                return "RNull";
            }
            case 2: {
                return "RVector";
            }
            case 3: {
                return "RArray";
            }
            case 7: {
                return "RList";
            }
            case 6: {
                return "RDataFrame";
            }
            case 10: {
                return "RS4Object";
            }
            case 8: {
                return "REnvironment";
            }
            case 12: {
                return "RLanguage";
            }
            case 13: {
                return "RFunction";
            }
            case 14: {
                return "RReference";
            }
            case 15: {
                return "<other>";
            }
            case 17: {
                return "RMissing";
            }
            case 18: {
                return "RPromise";
            }
        }
        return "<unkown>";
    }

    public static final long computeLengthFromDim(int[] dims) {
        if (dims.length == 0) {
            return 0L;
        }
        long length = 1L;
        int i = 0;
        while (i < dims.length) {
            length *= (long)dims[i];
            ++i;
        }
        return length;
    }

    public static final long getDataIdx(int[] dims, int ... idxs) {
        assert (dims.length > 0);
        assert (dims.length == idxs.length);
        long dataIdx = idxs[0];
        long step = dims[0];
        int i = 1;
        while (i < dims.length) {
            dataIdx += step * (long)idxs[i];
            step *= (long)dims[i];
            ++i;
        }
        return dataIdx;
    }

    public static final long getDataIdx(RStore<?> dims, int ... idxs) {
        assert (dims.getLength() > 0L);
        assert (dims.getLength() == (long)idxs.length);
        long dataIdx = idxs[0];
        long step = dims.getInt(0);
        int i = 1;
        while ((long)i < dims.getLength()) {
            dataIdx += step * (long)idxs[i];
            step *= (long)dims.getInt(i);
            ++i;
        }
        return dataIdx;
    }

    public static final long getDataIdx(long rowCount, long rowIdx, long columnIdx) {
        return rowIdx + rowCount * columnIdx;
    }

    public static final int[] getDataIdxs(int[] dims, int dim, int idx) {
        int size;
        assert (dims.length > 0);
        assert (dim >= 0 && dim < dims.length);
        assert (idx >= 0 && idx < dims[dim]);
        int dimsCount = dims.length;
        if (dimsCount == 1) {
            size = 1;
        } else if (dimsCount == 2) {
            size = dims[dim == 0 ? 1 : 0];
        } else {
            int counter = 1;
            int dimIdx = 0;
            while (dimIdx < dimsCount) {
                if (dimIdx != dim) {
                    counter *= dims[dimIdx];
                }
                ++dimIdx;
            }
            size = counter;
        }
        int[] dataIdxs = new int[size];
        int step = 1;
        int stepCount = 1;
        int dimIdx = 0;
        while (dimIdx < dimsCount) {
            int dimSize = dims[dimIdx];
            if (dimIdx == dim) {
                int add = step * idx;
                int i = 0;
                while (i < size) {
                    int n = i++;
                    dataIdxs[n] = dataIdxs[n] + add;
                }
            } else {
                int i = 0;
                int idxInDim = 0;
                while (i < size) {
                    if (idxInDim == dimSize) {
                        idxInDim = 0;
                    }
                    int add = step * idxInDim;
                    int j = 0;
                    while (j < stepCount && i < size) {
                        int n = i++;
                        dataIdxs[n] = dataIdxs[n] + add;
                        ++j;
                    }
                    ++idxInDim;
                }
                stepCount *= dimSize;
            }
            step *= dimSize;
            ++dimIdx;
        }
        return dataIdxs;
    }

    private static final RStore<?> requireObjectData(RObject obj) throws UnexpectedRDataException {
        RStore<?> store = obj.getData();
        if (store == null) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()) + " (without R data)");
        }
        return store;
    }

    private static final RLogicalStore requireRLogicalStore(RStore<?> store) throws UnexpectedRDataException {
        if (store.getStoreType() != 1) {
            throw new UnexpectedRDataException("Unexpected R data type: " + RDataUtils.getStoreAbbr(store));
        }
        return (RLogicalStore)store;
    }

    private static final RIntegerStore requireRIntegerStore(RStore<?> store) throws UnexpectedRDataException {
        if (store.getStoreType() != 2) {
            throw new UnexpectedRDataException("Unexpected R data type: " + RDataUtils.getStoreAbbr(store));
        }
        return (RIntegerStore)store;
    }

    private static final RNumericStore requireRNumericStore(RStore<?> store) throws UnexpectedRDataException {
        if (store.getStoreType() != 3) {
            throw new UnexpectedRDataException("Unexpected R data type: " + RDataUtils.getStoreAbbr(store));
        }
        return (RNumericStore)store;
    }

    private static final RCharacterStore requireRCharacterStore(RStore<?> store) throws UnexpectedRDataException {
        if (store.getStoreType() != 5) {
            throw new UnexpectedRDataException("Unexpected R data type: " + RDataUtils.getStoreAbbr(store));
        }
        return (RCharacterStore)store;
    }

    private static final RRawStore requireRRawStore(RStore<?> store) throws UnexpectedRDataException {
        if (store.getStoreType() != 6) {
            throw new UnexpectedRDataException("Unexpected R data type: " + RDataUtils.getStoreAbbr(store));
        }
        return (RRawStore)store;
    }

    private static final void requireLengthEqual1(RStore<?> store) throws UnexpectedRDataException {
        if (store.getLength() != 1L) {
            throw new UnexpectedRDataException("Unexpected R data length: " + store.getLength() + ", but == 1 expected.");
        }
    }

    public static final RVector<?> checkRVector(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 2) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        return (RVector)obj;
    }

    public static final RVector<RLogicalStore> checkRLogiVector(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 2) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RDataUtils.requireRLogicalStore(RDataUtils.requireObjectData(obj));
        return (RVector)obj;
    }

    public static final RVector<RIntegerStore> checkRIntVector(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 2) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RDataUtils.requireRIntegerStore(RDataUtils.requireObjectData(obj));
        return (RVector)obj;
    }

    public static final RVector<RNumericStore> checkRNumVector(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 2) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RDataUtils.requireRNumericStore(RDataUtils.requireObjectData(obj));
        return (RVector)obj;
    }

    public static final RVector<RCharacterStore> checkRCharVector(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 2) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RDataUtils.requireRCharacterStore(RDataUtils.requireObjectData(obj));
        return (RVector)obj;
    }

    public static final RVector<RRawStore> checkRRawVector(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 2) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RDataUtils.requireRRawStore(RDataUtils.requireObjectData(obj));
        return (RVector)obj;
    }

    public static final RArray<?> checkRArray(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 3) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        return (RArray)obj;
    }

    public static final RArray<?> checkRArray(@Nullable RObject obj, int dim) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 3) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RArray array = (RArray)obj;
        if (dim > 0 && (long)dim != array.getDim().getLength()) {
            throw new UnexpectedRDataException("Unexpected R array dimension: " + array.getDim().getLength());
        }
        return array;
    }

    public static final RArray<?> checkRArray(@Nullable RObject obj, long dim) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 3) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RArray array = (RArray)obj;
        if (dim > 0L && dim != array.getDim().getLength()) {
            throw new UnexpectedRDataException("Unexpected R array dimension: " + array.getDim().getLength());
        }
        return array;
    }

    public static final RArray<RCharacterStore> checkRCharArray(@Nullable RObject obj, int dim) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 3) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RDataUtils.requireRCharacterStore(RDataUtils.requireObjectData(obj));
        RArray array = (RArray)obj;
        if (dim > 0 && (long)dim != array.getDim().getLength()) {
            throw new UnexpectedRDataException("Unexpected R array dimension: " + array.getDim().getLength());
        }
        return array;
    }

    public static final RArray<RRawStore> checkRRawArray(@Nullable RObject obj, int dim) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 3) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RDataUtils.requireRRawStore(RDataUtils.requireObjectData(obj));
        RArray array = (RArray)obj;
        if (dim > 0 && (long)dim != array.getDim().getLength()) {
            throw new UnexpectedRDataException("Unexpected R array dimension: " + array.getDim().getLength());
        }
        return array;
    }

    public static final RList checkRList(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 7) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        return (RList)obj;
    }

    public static final RDataFrame checkRDataFrame(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 6) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        return (RDataFrame)obj;
    }

    public static final RDataFrame checkRDataFrame(@Nullable RObject obj, long length) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 6) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        if (obj.getLength() != length) {
            throw new UnexpectedRDataException("Unexpected R dataframe column count: " + obj.getLength());
        }
        return (RDataFrame)obj;
    }

    public static final RReference checkRReference(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 14) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        return (RReference)obj;
    }

    public static final RReference checkRReference(@Nullable RObject obj, byte referencedObjectType) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 14) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        RReference reference = (RReference)obj;
        if (reference.getReferencedRObjectType() != referencedObjectType) {
            throw new UnexpectedRDataException("Unexpected referenced R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()) + ", but " + RDataUtils.getObjectTypeName(referencedObjectType) + " expected.");
        }
        return (RReference)obj;
    }

    public static final RLanguage checkRLanguage(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != 12) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()));
        }
        return (RLanguage)obj;
    }

    public static final boolean isSingleLogi(@Nullable RObject obj) {
        RStore<?> data;
        return obj != null && (data = obj.getData()) != null && data.getStoreType() == 1 && data.getLength() == 1L;
    }

    public static final @Nullable Boolean checkSingleLogi(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RLogicalStore data = RDataUtils.requireRLogicalStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        return data.get(0);
    }

    public static final boolean checkSingleLogiValue(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RLogicalStore data = RDataUtils.requireRLogicalStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        if (data.isNA(0)) {
            throw new UnexpectedRDataException("Unexpected R data value: NA");
        }
        return data.getLogi(0);
    }

    public static final boolean isSingleInt(@Nullable RObject obj) {
        RStore<?> data;
        return obj != null && (data = obj.getData()) != null && data.getStoreType() == 2 && data.getLength() == 1L;
    }

    public static final @Nullable Integer checkSingleInt(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RIntegerStore data = RDataUtils.requireRIntegerStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        return data.get(0);
    }

    public static final int checkSingleIntValue(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RIntegerStore data = RDataUtils.requireRIntegerStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        if (data.isNA(0)) {
            throw new UnexpectedRDataException("Unexpected R data value: NA");
        }
        return data.getInt(0);
    }

    public static final boolean isSingleNum(@Nullable RObject obj) {
        RStore<?> data;
        return obj != null && (data = obj.getData()) != null && data.getStoreType() == 3 && data.getLength() == 1L;
    }

    public static final @Nullable Double checkSingleNum(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RNumericStore data = RDataUtils.requireRNumericStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        return data.get(0);
    }

    public static final double checkSingleNumValue(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RNumericStore data = RDataUtils.requireRNumericStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        if (data.isNA(0)) {
            throw new UnexpectedRDataException("Unexpected R data value: NA");
        }
        return data.getNum(0);
    }

    public static final boolean isSingleChar(@Nullable RObject obj) {
        RStore<?> data;
        return obj != null && (data = obj.getData()) != null && data.getStoreType() == 5 && data.getLength() == 1L;
    }

    @Deprecated
    public static final boolean isSingleString(@Nullable RObject obj) {
        return RDataUtils.isSingleChar(obj);
    }

    public static final @Nullable String checkSingleChar(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RCharacterStore data = RDataUtils.requireRCharacterStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        return data.get(0);
    }

    public static final String checkSingleCharValue(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RCharacterStore data = RDataUtils.requireRCharacterStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        if (data.isNA(0)) {
            throw new UnexpectedRDataException("Unexpected R data value: NA");
        }
        return data.getChar(0);
    }

    public static final boolean isSingleRaw(@Nullable RObject obj) {
        RStore<?> data;
        return obj != null && (data = obj.getData()) != null && data.getStoreType() == 6 && data.getLength() == 1L;
    }

    public static final Byte checkSingleRaw(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RRawStore data = RDataUtils.requireRRawStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        return data.get(0);
    }

    public static final byte checkSingleRawValue(@Nullable RObject obj) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        RRawStore data = RDataUtils.requireRRawStore(RDataUtils.requireObjectData(obj));
        RDataUtils.requireLengthEqual1(data);
        return data.getRaw(0);
    }

    public static final RObject checkType(@Nullable RObject obj, byte objectType) throws UnexpectedRDataException {
        if (obj == null) {
            throw new UnexpectedRDataException("Missing R object.");
        }
        if (obj.getRObjectType() != objectType) {
            throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName(obj.getRObjectType()) + ", but " + RDataUtils.getObjectTypeName(objectType) + " expected.");
        }
        return obj;
    }

    public static final RStore<?> checkData(RStore<?> data, byte storeType) throws UnexpectedRDataException {
        if (data.getStoreType() != storeType) {
            throw new UnexpectedRDataException("Unexpected R data type: " + RDataUtils.getStoreAbbr(data) + ", but " + storeType + " expected.");
        }
        return data;
    }

    public static final int checkIntLength(RObject obj) throws UnexpectedRDataException {
        return RDataUtils.checkIntLength(obj.getLength());
    }

    public static final int checkIntLength(RStore<?> data) throws UnexpectedRDataException {
        return RDataUtils.checkIntLength(data.getLength());
    }

    public static final int checkIntLength(long length) throws UnexpectedRDataException {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new UnexpectedRDataException("Unexpected R data length: " + length + ", but <= 2^31-1 expected.");
        }
        return (int)length;
    }

    public static final int checkIntIdx(long idx) throws UnexpectedRDataException {
        if (idx < 0L || idx >= Integer.MAX_VALUE) {
            throw new UnexpectedRDataException("Unexpected R data index: " + idx + ", but < 2^31-1 expected.");
        }
        return (int)idx;
    }

    public static final <T extends RObject> T checkLengthEqual(T obj, long length) throws UnexpectedRDataException {
        if (obj.getLength() != length) {
            throw new UnexpectedRDataException("Unexpected R object length: " + obj.getLength() + ", but == " + length + " expected.");
        }
        return obj;
    }

    public static final <TData extends RStore<?>> TData checkLengthEqual(TData data, long length) throws UnexpectedRDataException {
        if (data.getLength() != length) {
            throw new UnexpectedRDataException("Unexpected R data length: " + data.getLength() + ", but == " + length + " expected.");
        }
        return data;
    }

    public static final <TData extends RStore<?>> TData checkLengthGreaterOrEqual(TData data, long length) throws UnexpectedRDataException {
        if (data.getLength() < length) {
            throw new UnexpectedRDataException("Unexpected R data length: " + data.getLength() + ", but >= " + length + " expected.");
        }
        return data;
    }

    public static final <P> P checkValue(RStore<P> data, int idx) throws UnexpectedRDataException {
        P value = data.get(idx);
        if (value == null) {
            throw new UnexpectedRDataException("Unexpected R data value: NA");
        }
        return value;
    }

    public static final <P> P checkValue(RStore<P> data, long idx) throws UnexpectedRDataException {
        P value = data.get(idx);
        if (value == null) {
            throw new UnexpectedRDataException("Unexpected R data value: NA");
        }
        return value;
    }

    public static final <P> P getValue(RStore<P> data, int idx, P na) {
        P value = data.get(idx);
        return value != null ? value : na;
    }

    public static final <P> P getValue(RStore<P> data, long idx, P na) {
        P value = data.get(idx);
        return value != null ? value : na;
    }

    public static final int getRowCount(RArray<?> array) throws UnexpectedRDataException {
        return array.getDim().getInt(0);
    }

    public static final void checkRowCountEqual(RArray<?> array, int count) throws UnexpectedRDataException {
        if (array.getDim().getInt(0) != count) {
            throw new UnexpectedRDataException("Unexpected R matrix row count: " + array.getDim().getInt(0) + ", but == " + count + " expected.");
        }
    }

    public static final void checkRowCountEqual(RDataFrame dataframe, long count) throws UnexpectedRDataException {
        if (dataframe.getRowCount() != count) {
            throw new UnexpectedRDataException("Unexpected R dataframe row count: " + dataframe.getRowCount() + ", but == " + count + " expected.");
        }
    }

    public static final int getColumnCount(RArray<?> array) throws UnexpectedRDataException {
        return array.getDim().getInt(1);
    }

    public static final void checkColumnCountEqual(RArray<?> array, int count) throws UnexpectedRDataException {
        if (array.getDim().getInt(1) != count) {
            throw new UnexpectedRDataException("Unexpected R matrix column count: " + array.getDim().getInt(1) + ", but == " + count + " expected.");
        }
    }

    public static final long checkColumnName(RArray<?> array, String name) throws UnexpectedRDataException {
        long idx = array.getNames(1).indexOf(name);
        if (idx < 0L) {
            throw new UnexpectedRDataException("Missing R matrix column: " + name);
        }
        return idx;
    }

    public static final void checkColumnCountEqual(RDataFrame dataframe, long count) throws UnexpectedRDataException {
        if (dataframe.getColumnCount() != count) {
            throw new UnexpectedRDataException("Unexpected R dataframe column count: " + dataframe.getColumnCount() + ", but == " + count + " expected.");
        }
    }

    public static final long binarySearch(RVector<?> vector, int value) {
        Object data = vector.getData();
        return RDataUtils.binarySearch(data, 0L, data.getLength(), value);
    }

    public static final long binarySearch(RStore<?> data, int value) {
        return RDataUtils.binarySearch(data, 0L, data.getLength(), value);
    }

    public static final int binarySearch(RStore<?> data, int fromIdx, int toIdx, int value) {
        if (fromIdx < 0 || (long)fromIdx > data.getLength() || toIdx < 0 || (long)toIdx > data.getLength()) {
            throw new IndexOutOfBoundsException(Long.toString(fromIdx));
        }
        if (fromIdx > toIdx) {
            throw new IllegalArgumentException();
        }
        return RDataUtils.doBinarySearch(data, fromIdx, toIdx - 1, value);
    }

    private static int doBinarySearch(RStore<?> data, int low, int high, int value) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int midValue = data.getInt(mid);
            if (midValue < value) {
                low = mid + 1;
                continue;
            }
            if (midValue > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static final long binarySearch(RStore<?> data, long fromIdx, long toIdx, int value) {
        if (fromIdx < 0L || fromIdx > data.getLength() || toIdx < 0L || toIdx > data.getLength()) {
            throw new IndexOutOfBoundsException(Long.toString(fromIdx));
        }
        if (fromIdx > toIdx) {
            throw new IllegalArgumentException();
        }
        if (toIdx <= Integer.MAX_VALUE) {
            return RDataUtils.doBinarySearch(data, (int)fromIdx, (int)toIdx - 1, value);
        }
        return RDataUtils.doBinarySearch(data, fromIdx, toIdx - 1L, value);
    }

    private static long doBinarySearch(RStore<?> data, long low, long high, int value) {
        while (low <= high) {
            long mid = low + high >>> 1;
            int midValue = data.getInt(mid);
            if (midValue < value) {
                low = mid + 1L;
                continue;
            }
            if (midValue > value) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public static final int binarySearch(RStore<?> data, long[] fromIdxs, int length, int[] values) {
        if (fromIdxs.length > values.length) {
            throw new IllegalArgumentException();
        }
        if (length < 0 || (long)length > data.getLength()) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < fromIdxs.length) {
            if (fromIdxs[i] < 0L || fromIdxs[i] + (long)length > data.getLength()) {
                throw new IndexOutOfBoundsException(Long.toString(fromIdxs[i]));
            }
            ++i;
        }
        int low = 0;
        int high = length - 1;
        block1: while (low <= high) {
            int mid = low + high >>> 1;
            int i2 = 0;
            while (i2 < fromIdxs.length) {
                int midValue = data.getInt(fromIdxs[i2] + (long)mid);
                if (midValue < values[i2]) {
                    low = mid + 1;
                    continue block1;
                }
                if (midValue > values[i2]) {
                    high = mid - 1;
                    continue block1;
                }
                ++i2;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static final int compare(int[] values1, int[] values2) {
        int i = 0;
        while (i < values1.length) {
            if (values1[i] < values2[i]) {
                return -1;
            }
            if (values1[i] > values2[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static final long binarySearch(RStore<?> data, long value) {
        return RDataUtils.binarySearch(data, 0L, data.getLength(), value);
    }

    public static final int binarySearch(RStore<?> data, int fromIdx, int toIdx, long value) {
        if (fromIdx < 0 || (long)fromIdx > data.getLength() || toIdx < 0 || (long)toIdx > data.getLength()) {
            throw new IndexOutOfBoundsException(Long.toString(fromIdx));
        }
        if (fromIdx > toIdx) {
            throw new IllegalArgumentException();
        }
        return RDataUtils.doBinarySearch(data, fromIdx, toIdx - 1, value);
    }

    private static int doBinarySearch(RStore<?> data, int low, int high, long value) {
        while (low <= high) {
            int mid = low + high >>> 1;
            double midValue = data.getNum(mid);
            if (midValue < (double)value) {
                low = mid + 1;
                continue;
            }
            if (midValue > (double)value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static final long binarySearch(RStore<?> data, long fromIdx, long toIdx, long value) {
        if (fromIdx < 0L || fromIdx > data.getLength() || toIdx < 0L || toIdx > data.getLength()) {
            throw new IndexOutOfBoundsException(Long.toString(fromIdx));
        }
        if (fromIdx > toIdx) {
            throw new IllegalArgumentException();
        }
        if (toIdx <= Integer.MAX_VALUE) {
            return RDataUtils.doBinarySearch(data, (int)fromIdx, (int)toIdx - 1, value);
        }
        return RDataUtils.doBinarySearch(data, fromIdx, toIdx - 1L, value);
    }

    private static long doBinarySearch(RStore<?> data, long low, long high, long value) {
        while (low <= high) {
            long mid = low + high >>> 1;
            double midValue = data.getNum(mid);
            if (midValue < (double)value) {
                low = mid + 1L;
                continue;
            }
            if (midValue > (double)value) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public static final int binarySearch(RStore<?> data, long[] fromIdxs, int length, long[] values) {
        if (fromIdxs.length > values.length) {
            throw new IllegalArgumentException();
        }
        if (length < 0 || (long)length > data.getLength()) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < fromIdxs.length) {
            if (fromIdxs[i] < 0L || fromIdxs[i] + (long)length > data.getLength()) {
                throw new IndexOutOfBoundsException(Long.toString(fromIdxs[i]));
            }
            ++i;
        }
        int low = 0;
        int high = length - 1;
        block1: while (low <= high) {
            int mid = low + high >>> 1;
            int i2 = 0;
            while (i2 < fromIdxs.length) {
                double midValue = data.getNum(fromIdxs[i2] + (long)mid);
                if (midValue < (double)values[i2]) {
                    low = mid + 1;
                    continue block1;
                }
                if (midValue > (double)values[i2]) {
                    high = mid - 1;
                    continue block1;
                }
                ++i2;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static final int compare(long[] values1, long[] values2) {
        int i = 0;
        while (i < values1.length) {
            if (values1[i] < values2[i]) {
                return -1;
            }
            if (values1[i] > values2[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static final byte[] encodeLongToRaw(long id) {
        byte[] raw = new byte[8];
        RDataUtils.encodeLongToRaw(id, raw, 0);
        return raw;
    }

    public static final void encodeLongToRaw(long id, byte[] raw, int idx) {
        raw[idx++] = (byte)(id >>> 56);
        raw[idx++] = (byte)(id >>> 48);
        raw[idx++] = (byte)(id >>> 40);
        raw[idx++] = (byte)(id >>> 32);
        raw[idx++] = (byte)(id >>> 24);
        raw[idx++] = (byte)(id >>> 16);
        raw[idx++] = (byte)(id >>> 8);
        raw[idx] = (byte)id;
    }

    public static final long decodeLongFromRaw(byte[] raw) {
        return RDataUtils.decodeLongFromRaw(raw, 0);
    }

    public static final long decodeLongFromRaw(byte[] raw, int idx) {
        return (long)(raw[idx++] & 0xFF) << 56 | (long)(raw[idx++] & 0xFF) << 48 | (long)(raw[idx++] & 0xFF) << 40 | (long)(raw[idx++] & 0xFF) << 32 | (long)(raw[idx++] & 0xFF) << 24 | (long)((raw[idx++] & 0xFF) << 16) | (long)((raw[idx++] & 0xFF) << 8) | (long)(raw[idx] & 0xFF);
    }
}

