/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.actions;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.io.ObservableFileValidator;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolInfoGroup;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractHistoryPage
extends WizardPage {
    private static final String SETTINGS_HISTORY = "statet:location.history";
    protected ResourceInputComposite fLocationGroup;
    private String fResourcePath;
    public IFile fResourceInWorkspace;
    public IFileStore fResourceInEFS;
    public String fEncoding = "UTF-8";
    protected ToolProcess fTool;
    protected boolean isIntialized = false;

    public AbstractHistoryPage(String pageName, String title, ToolProcess tool) {
        super(pageName);
        this.fTool = tool;
        this.setTitle(title);
    }

    public void createControl(Composite parent) {
        Composite saveOptions;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newContentGrid((int)1));
        this.fLocationGroup = this.createResourceInputComposite(composite);
        this.fLocationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fLocationGroup.setHistory(this.getDialogSettings().getArray(SETTINGS_HISTORY));
        this.fLocationGroup.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractHistoryPage.this.validate();
            }
        });
        Composite contentOptions = this.createContentOptions(composite);
        if (contentOptions != null) {
            contentOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        if ((saveOptions = this.createSaveOptions(composite)) != null) {
            saveOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)true);
        ToolInfoGroup info = new ToolInfoGroup(composite, this.fTool);
        info.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.initFields();
        this.isIntialized = true;
        this.validate();
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    protected abstract ResourceInputComposite createResourceInputComposite(Composite var1);

    protected Composite createContentOptions(Composite parent) {
        return null;
    }

    protected Composite createSaveOptions(Composite parent) {
        return null;
    }

    protected void initFields() {
    }

    protected void validate() {
        if (!this.isIntialized) {
            return;
        }
        ObservableFileValidator validator = this.fLocationGroup.getValidator();
        IStatus status = validator.getStatus();
        if (status == null) {
            status = Status.OK_STATUS;
        }
        StatusInfo.applyToStatusLine((DialogPage)this, (IStatus)status);
        if (status.getSeverity() == 4) {
            this.setPageComplete(false);
            this.fResourceInWorkspace = null;
            this.fResourceInEFS = null;
            this.fResourcePath = null;
        } else {
            this.setPageComplete(true);
            this.fResourceInWorkspace = (IFile)this.fLocationGroup.getResourceAsWorkspaceResource();
            this.fResourceInEFS = this.fLocationGroup.getResourceAsFileStore();
            this.fResourcePath = this.fLocationGroup.getResourceString();
        }
    }

    public Object getFile() {
        if (this.fResourceInWorkspace != null) {
            return this.fResourceInWorkspace;
        }
        return this.fResourceInEFS;
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        DialogUtils.saveHistorySettings((IDialogSettings)settings, (String)SETTINGS_HISTORY, (String)this.fResourcePath);
    }
}

