/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.databinding.NotEmptyValidator;
import org.eclipse.statet.ecommons.databinding.URLValidator;
import org.eclipse.statet.ecommons.databinding.core.conversion.ClassTypedConverter;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.rj.renv.core.RPkgType;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
class EditRepoDialog
extends ExtStatusDialog {
    private static final String DEFAULT_TYPE = "Default";
    private static final Class<@Nullable RPkgType> Nullable_RPkgType_TYPE = RPkgType.class;
    private final RRepo repo;
    private final boolean isNew;
    private Text nameControl;
    private Text urlControl;
    private ComboViewer typeControl;

    public EditRepoDialog(Shell parent, RRepo repo, boolean isNew) {
        super(parent, isNew ? 2 : 6);
        this.repo = repo;
        this.isNew = isNew;
        this.setTitle(isNew ? "Add Repository" : "Edit Repository");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        area.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        Label label = new Label(area, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Name:");
        Text text = new Text(area, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameControl = text;
        label = new Label(area, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("URL:");
        text = new Text(area, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)this.nameControl, (int)60);
        text.setLayoutData((Object)gd);
        this.urlControl = text;
        label = new Label(area, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Type:");
        ComboViewer viewer = new ComboViewer(area, 2060);
        gd = new GridData(16384, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Combo)viewer.getCombo(), (int)10);
        viewer.getCombo().setLayoutData((Object)gd);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof RPkgType) {
                    return ((RPkgType)element).getLabel();
                }
                return super.getText(element);
            }
        });
        viewer.setInput((Object)new Object[]{DEFAULT_TYPE, RPkgType.SOURCE, RPkgType.BINARY});
        viewer.setSelection((ISelection)new StructuredSelection((Object)DEFAULT_TYPE));
        this.typeControl = viewer;
        LayoutUtils.addSmallFiller((Composite)area, (boolean)true);
        EditRepoDialog.applyDialogFont((Control)area);
        return area;
    }

    protected void addBindings(DataBindingSupport databinding) {
        DataBindingContext dbc = databinding.getContext();
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameControl), PojoProperties.value(RRepo.class, (String)"name", (Class)ObjectUtils.NonNull_String_TYPE).observe((Object)this.repo), null, null);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.urlControl), PojoProperties.value(RRepo.class, (String)"URL", (Class)ObjectUtils.NonNull_String_TYPE).observe((Object)this.repo), new UpdateValueStrategy().setAfterGetValidator((IValidator)new NotEmptyValidator("URL", (IValidator)new URLValidator("URL"))), null);
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection(Object.class).observe((Viewer)this.typeControl), PojoProperties.value(RRepo.class, (String)"pkgType", Nullable_RPkgType_TYPE).observe((Object)this.repo), new UpdateValueStrategy().setConverter((IConverter)ClassTypedConverter.create((Class)ObjectUtils.Nullable_Object_TYPE, Nullable_RPkgType_TYPE, fromObject -> fromObject != DEFAULT_TYPE ? (RPkgType)fromObject : null)), new UpdateValueStrategy().setConverter((IConverter)ClassTypedConverter.create(Nullable_RPkgType_TYPE, (Class)ObjectUtils.NonNull_Object_TYPE, fromObject -> fromObject != null ? fromObject : DEFAULT_TYPE)));
    }
}

