/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.config.LayoutSizeConfig;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerEvent;
import org.eclipse.statet.ecommons.waltable.data.core.DataLayerDim;
import org.eclipse.statet.ecommons.waltable.resize.core.DimResizeEvent;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.ContentDescription;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatter;
import org.eclipse.statet.internal.r.ui.intable.DimPositionResizeCommandHandler;
import org.eclipse.statet.internal.r.ui.intable.MultiColumnAutoResizeCommandHandler;
import org.eclipse.statet.internal.r.ui.intable.MultiColumnResizeCommandHandler;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;

@NonNullByDefault
public class RDataLayer
extends AbstractLayer<DataLayerDim<RDataLayer>> {
    private final AbstractRDataProvider<?> dataProvider;
    private LayoutSizeConfig sizeConfig;

    public RDataLayer(AbstractRDataProvider<?> dataProvider, LayoutSizeConfig sizeConfig) {
        this.dataProvider = dataProvider;
        this.sizeConfig = sizeConfig;
        this.init();
        this.registerCommandHandlers();
    }

    protected DataLayerDim<RDataLayer> createDim(Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return new ColumnsDim(this, this.sizeConfig.getCharWidth(), this.sizeConfig.getDefaultSpace() * 4);
            }
            case VERTICAL: {
                return new RowsDim(this, this.sizeConfig.getRowHeight());
            }
        }
        throw new IllegalStateException();
    }

    private ColumnsDim getColumnDim() {
        return (ColumnsDim)this.getDim(Orientation.HORIZONTAL);
    }

    private RowsDim getRowDim() {
        return (RowsDim)this.getDim(Orientation.VERTICAL);
    }

    public void setSizeConfig(LayoutSizeConfig sizeConfig) {
        this.sizeConfig = sizeConfig;
        this.getColumnDim().setSize(sizeConfig.getCharWidth(), this.sizeConfig.getDefaultSpace() * 4);
        this.getRowDim().setSize(sizeConfig.getRowHeight());
    }

    protected void registerCommandHandlers() {
        this.registerCommandHandler((LayerCommandHandler)new DimPositionResizeCommandHandler(this));
        this.registerCommandHandler((LayerCommandHandler)new MultiColumnResizeCommandHandler(this));
        this.registerCommandHandler((LayerCommandHandler)new MultiColumnAutoResizeCommandHandler(this));
    }

    public void setColumnWidth(long columnPosition, int width) {
        this.getColumnDim().setCustomSize(columnPosition, width);
        this.fireLayerEvent((LayerEvent)new DimResizeEvent(this.getDim(Orientation.HORIZONTAL), new LRange(columnPosition)));
    }

    public void setColumnWidthToAutoWidth(long columnPosition) {
        this.getColumnDim().setAutoSize(columnPosition);
        this.fireLayerEvent((LayerEvent)new DimResizeEvent(this.getDim(Orientation.HORIZONTAL), new LRange(columnPosition)));
    }

    public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
        LayerDim hDim = this.getDim(Orientation.HORIZONTAL);
        LayerDim vDim = this.getDim(Orientation.VERTICAL);
        long columnId = hDim.getPositionId(columnPosition, columnPosition);
        long rowId = vDim.getPositionId(rowPosition, rowPosition);
        return new BasicLayerCell((Layer)this, (LayerCellDim)new BasicLayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition), (LayerCellDim)new BasicLayerCellDim(Orientation.VERTICAL, rowId, rowPosition)){

            public Object getDataValue(int flags, @Nullable IProgressMonitor monitor) {
                return RDataLayer.this.dataProvider.getDataValue(this.getColumnPosition(), this.getRowPosition(), flags, monitor);
            }
        };
    }

    public @Nullable Layer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
        return null;
    }

    private static class ColumnsDim
    extends DataLayerDim<RDataLayer> {
        private final int defaultMinChars = 8;
        private final int defaultMaxChars = 20;
        private final int autoMinChars = 3;
        private final int autoMaxChars = 1000;
        private final int fallbackPositionSize = 10;
        private final Map<Long, Integer> customPositionSizes = new HashMap<Long, Integer>();
        private int charSize;
        private int spacing;

        public ColumnsDim(RDataLayer layer, int charSize, int spacing) {
            super((Layer)layer, Orientation.HORIZONTAL, 0x10000000000000L);
            this.charSize = charSize;
            this.spacing = spacing;
        }

        public long getPositionCount() {
            return ((RDataLayer)this.layer).dataProvider.getColumnCount();
        }

        public void setSize(int charSize, int spacing) {
            if (charSize != this.charSize || spacing != this.spacing) {
                double factor = (double)charSize / (double)this.charSize;
                for (Map.Entry<Long, Integer> entry : this.customPositionSizes.entrySet()) {
                    entry.setValue((int)((double)(entry.getValue() - this.spacing) * factor + (double)spacing + 0.5));
                }
            }
            this.charSize = charSize;
            this.spacing = spacing;
        }

        private long aggregateSize(long position) {
            if (position < 0L) {
                return -1L;
            }
            if (((RDataLayer)this.layer).dataProvider.getAllColumnsEqual()) {
                Integer columnWidth = this.customPositionSizes.get(0L);
                if (columnWidth != null) {
                    return (long)columnWidth.intValue() * position;
                }
                return (long)this.getDefaultSize(0L) * position;
            }
            long width = 0L;
            long i = 0L;
            while (i < position) {
                Integer columnWidth = this.customPositionSizes.get(i);
                width = columnWidth != null ? (width += (long)columnWidth.intValue()) : (width += (long)this.getDefaultSize(i));
                ++i;
            }
            return width;
        }

        public long getSize() {
            return this.aggregateSize(this.getPositionCount());
        }

        public long getPositionStart(long position) {
            if (position < 0L || position >= this.getPositionCount()) {
                throw new PositionOutOfBoundsException(position, this.getOrientation());
            }
            return this.aggregateSize(position);
        }

        public int getPositionSize(long position) {
            if (position < 0L || position >= this.getPositionCount()) {
                throw new PositionOutOfBoundsException(position, this.getOrientation());
            }
            Integer columnWidth = this.customPositionSizes.get(((RDataLayer)this.layer).dataProvider.getAllColumnsEqual() ? Long.valueOf(0L) : Long.valueOf(position));
            if (columnWidth != null) {
                return columnWidth;
            }
            return this.getDefaultSize(position);
        }

        public boolean isPositionResizable(long position) {
            return true;
        }

        protected int getFormatterCharWidth(long position) {
            if (((RDataLayer)this.layer).dataProvider.getAllColumnsEqual()) {
                RDataFormatter formatter;
                ContentDescription description = ((RDataLayer)this.layer).dataProvider.getDescription();
                if (description != null && (formatter = description.getDefaultDataFormat()) != null && formatter.getAutoWidth() >= 0) {
                    return formatter.getAutoWidth();
                }
                return 10;
            }
            ContentDescription description = ((RDataLayer)this.layer).dataProvider.getDescription();
            if (description != null) {
                RDataFormatter formatter;
                ImList<RDataTableColumn> columns = description.getDataColumns();
                if (position < (long)columns.size() && (formatter = ((RDataTableColumn)columns.get((int)position)).getDefaultFormat()) != null && formatter.getAutoWidth() >= 0) {
                    return formatter.getAutoWidth();
                }
                formatter = description.getDefaultDataFormat();
                if (formatter != null && formatter.getAutoWidth() >= 0) {
                    return formatter.getAutoWidth();
                }
            }
            return 10;
        }

        protected int getDefaultSize(long position) {
            int charWidth = Math.clamp((long)this.getFormatterCharWidth(position), 8, 20);
            return charWidth * this.charSize + this.spacing;
        }

        protected int getAutoSize(long position) {
            int charWidth = Math.clamp((long)this.getFormatterCharWidth(position), 3, 1000);
            return charWidth * this.charSize + this.spacing;
        }

        public void setCustomSize(long position, int size) {
            this.customPositionSizes.put(((RDataLayer)this.layer).dataProvider.getAllColumnsEqual() ? Long.valueOf(0L) : Long.valueOf(position), size);
        }

        public void setAutoSize(long position) {
            this.customPositionSizes.put(((RDataLayer)this.layer).dataProvider.getAllColumnsEqual() ? Long.valueOf(0L) : Long.valueOf(position), this.getAutoSize(position));
        }
    }

    private static class RowsDim
    extends DataLayerDim<RDataLayer> {
        private int positionSize;

        public RowsDim(RDataLayer layer, int positionSize) {
            super((Layer)layer, Orientation.VERTICAL, 0x10000000000000L);
            this.positionSize = positionSize;
        }

        public long getPositionCount() {
            return ((RDataLayer)this.layer).dataProvider.getRowCount();
        }

        public void setSize(int rowHeight) {
            this.positionSize = rowHeight;
        }

        public long getSize() {
            return this.getPositionCount() * (long)this.positionSize;
        }

        public long getPositionStart(long position) {
            if (position < 0L || position >= this.getPositionCount()) {
                throw new IndexOutOfBoundsException("position: " + position);
            }
            return position * (long)this.positionSize;
        }

        public int getPositionSize(long position) {
            if (position < 0L || position >= this.getPositionCount()) {
                throw new IndexOutOfBoundsException("position: " + position);
            }
            return this.positionSize;
        }

        public boolean isPositionResizable(long position) {
            return false;
        }
    }
}

