/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.actions.ControlServicesUtil;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.components.DropDownButton;
import org.eclipse.statet.ecommons.ui.components.SearchText;
import org.eclipse.statet.ecommons.ui.util.AutoCheckController;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.ui.datafilter.TextSearchType;
import org.eclipse.statet.internal.r.ui.datafilter.TextVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilterview.ColumnLabelProvider;
import org.eclipse.statet.internal.r.ui.datafilterview.FilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.Messages;
import org.eclipse.statet.internal.r.ui.datafilterview.RStore2UIConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.RStoreContentProvider;
import org.eclipse.statet.internal.r.ui.datafilterview.UI2RStoreConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableComposite;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class TextFilterClient
extends FilterClient<TextVariableFilter> {
    private static final int SELECTION_DEPENDENT = 2;
    private RCharacterStore availableValues;
    private final IObservableSet<@Nullable String> selectedValueSet;
    private TextSearchType searchType;
    private SearchText searchTextControl = (SearchText)ObjectUtils.nonNullLateInit();
    private DropDownButton searchButtonControl = (DropDownButton)ObjectUtils.nonNullLateInit();
    private MenuItem[] searchMenuItems = (MenuItem[])ObjectUtils.nonNullLateInit();
    private CheckboxTableViewer valueListViewer = (CheckboxTableViewer)ObjectUtils.nonNullLateInit();
    private ContextHandlers valueListHandlers = (ContextHandlers)ObjectUtils.nonNullLateInit();
    private MenuManager valueListMenuManager = (MenuManager)ObjectUtils.nonNullLateInit();

    public TextFilterClient(VariableComposite parent, TextVariableFilter filter) {
        super(parent, filter);
        this.availableValues = filter.getAvailableValues();
        this.selectedValueSet = filter.getSelectedValues();
        this.searchType = TextSearchType.ECLIPSE;
        this.init(2);
    }

    @Override
    protected void onDispose() {
        if (this.valueListMenuManager != null) {
            this.valueListMenuManager.dispose();
            this.valueListMenuManager = null;
        }
        if (this.valueListHandlers != null) {
            this.valueListHandlers.dispose();
            this.valueListHandlers = null;
        }
        super.onDispose();
    }

    @Override
    public TextVariableFilter getFilter() {
        return (TextVariableFilter)this.filter;
    }

    @Override
    protected void addWidgets() {
        this.searchTextControl = new SearchText((Composite)this, "", 0x800800);
        this.searchTextControl.addListener(new SearchText.Listener(){

            public void textChanged(boolean user) {
            }

            public void okPressed() {
                TextFilterClient.this.search(null);
            }

            public void downPressed() {
            }
        });
        this.searchTextControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchButtonControl = new DropDownButton((Composite)this, 0x800000);
        this.searchButtonControl.setText(Messages.Items_Search_label);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.heightHint = this.searchButtonControl.computeSize((int)-1, (int)-1).y;
        int textHeight = this.searchTextControl.computeSize((int)-1, (int)-1).y;
        if (gd.heightHint - textHeight > 2) {
            gd.heightHint = textHeight + 2;
        }
        this.searchButtonControl.setLayoutData((Object)gd);
        this.searchButtonControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFilterClient.this.search(null);
            }
        });
        Menu searchMenu = this.searchButtonControl.getDropDownMenu();
        ImList<TextSearchType> searchTypes = TextSearchType.TYPES;
        this.searchMenuItems = new MenuItem[searchTypes.size()];
        Listener searchTypeListener = new Listener(){

            public void handleEvent(Event event) {
                TextFilterClient.this.search((TextSearchType)event.widget.getData());
            }
        };
        int id = 0;
        while (id < searchTypes.size()) {
            TextSearchType type = (TextSearchType)searchTypes.get(id);
            MenuItem item = new MenuItem(searchMenu, 16);
            item.setText(type.getLabel());
            item.setData((Object)type);
            item.addListener(13, searchTypeListener);
            this.searchMenuItems[id] = item;
            ++id;
        }
        this.setSearchType(this.searchType);
        this.addStatusInfoLine();
        this.valueListViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)8454146);
        this.valueListViewer.setContentProvider((IContentProvider)new RStoreContentProvider());
        this.valueListViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(((TextVariableFilter)this.filter).getColumn()));
    }

    @Override
    protected void initActions(IServiceLocator serviceLocator) {
        ControlServicesUtil servicesUtil = new ControlServicesUtil(serviceLocator, ((Object)((Object)this)).getClass().getName() + "/ValueList#" + ((Object)((Object)this)).hashCode(), (Control)this);
        servicesUtil.addControl((Control)this.valueListViewer.getTable());
        ContextHandlers handlers = new ContextHandlers(serviceLocator);
        handlers.setDefaultActivationExpression(servicesUtil.getExpression());
        handlers.setDeactivateOnDisposal(true);
        this.valueListHandlers = handlers;
        AutoCheckController autoCheckController = new AutoCheckController(this.valueListViewer, this.selectedValueSet);
        Object handler = autoCheckController.createSelectAllHandler();
        handlers.addActivate("org.eclipse.ui.edit.selectAll", handler);
        handler = new RemoveHandler();
        handlers.addActivate("org.eclipse.ui.edit.delete", handler, 2);
        handler = new RemoveUncheckedHandler();
        handlers.add("RemoveUnchecked", handler);
        handler = new RemoveAllHandler();
        handlers.add("RemoveAll", handler);
        ViewerUtils.installSearchTextNavigation((TableViewer)this.valueListViewer, (SearchText)this.searchTextControl, (boolean)true);
        this.valueListMenuManager = new MenuManager();
        this.valueListMenuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.edit.selectAll", 8), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get("org.eclipse.ui.edit.selectAll"))));
        this.valueListMenuManager.add((IContributionItem)new Separator());
        this.valueListMenuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.edit.delete", 8), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get("org.eclipse.ui.edit.delete"))));
        this.valueListMenuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, null, null, null, Messages.Items_RemoveUnchecked_label, null, "Remove unchecked items", 8, null, false), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get("RemoveUnchecked"))));
        this.valueListMenuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, null, null, null, Messages.Items_RemoveAll_label, null, "Remove all items", 8, null, false), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get("RemoveAll"))));
        this.valueListViewer.getTable().setMenu(this.valueListMenuManager.createContextMenu(this.valueListViewer.getControl()));
        this.valueListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TextFilterClient.this.updateActions();
            }
        });
        this.updateActions();
    }

    @Override
    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindSet(ViewerProperties.checkedElements(Object.class).observe((Object)this.valueListViewer), this.selectedValueSet, new UpdateSetStrategy().setConverter(new UI2RStoreConverter()), new UpdateSetStrategy().setConverter(new RStore2UIConverter()));
    }

    @Override
    protected void updateInput() {
        this.availableValues = ((TextVariableFilter)this.filter).getAvailableValues();
        this.valueListViewer.setInput((Object)this.availableValues);
        this.updateActions();
        this.checkLayout();
    }

    protected void updateActions() {
        this.valueListHandlers.update(null, 2);
    }

    @Override
    protected boolean updateLayout() {
        return this.updateLayout((TableViewer)this.valueListViewer, (int)this.availableValues.getLength());
    }

    @Override
    protected int getMinHeightPadding() {
        return this.searchTextControl.getSize().y + 20 + 10 * LayoutUtils.defaultVSpacing();
    }

    protected void setSearchType(TextSearchType type) {
        this.searchType = type;
        int id = 0;
        while (id < this.searchMenuItems.length) {
            this.searchMenuItems[id].setSelection(type.getId() == id);
            ++id;
        }
        this.searchButtonControl.setToolTipText(type.getLabel());
    }

    private void search(@Nullable TextSearchType type) {
        if (type != null) {
            if (this.searchType != type) {
                this.setSearchType(type);
            }
        } else {
            type = this.searchType;
        }
        String text = this.searchTextControl.getText();
        ((TextVariableFilter)this.filter).search(type, text);
    }

    private class RemoveAllHandler
    extends AbstractHandler {
        private RemoveAllHandler() {
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            this.setBaseEnabled(TextFilterClient.this.availableValues.getLength() > 0L);
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            ((TextVariableFilter)TextFilterClient.this.filter).removeAllValues();
            TextFilterClient.this.updateInput();
            return null;
        }
    }

    private class RemoveHandler
    extends AbstractHandler
    implements IElementUpdater {
        private RemoveHandler() {
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            this.setBaseEnabled(!TextFilterClient.this.valueListViewer.getSelection().isEmpty());
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            IStructuredSelection selection = (IStructuredSelection)TextFilterClient.this.valueListViewer.getSelection();
            ((TextVariableFilter)TextFilterClient.this.filter).removeValues(selection.toList());
            TextFilterClient.this.updateInput();
            return null;
        }

        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
            try {
                element.setText(Messages.Items_Remove_label);
                element.setTooltip(Messages.Items_RemoveSelected_label);
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }
    }

    private class RemoveUncheckedHandler
    extends AbstractHandler {
        private RemoveUncheckedHandler() {
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            this.setBaseEnabled(TextFilterClient.this.availableValues.getLength() > (long)TextFilterClient.this.selectedValueSet.size());
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            ArrayList<String> values = new ArrayList<String>((int)TextFilterClient.this.availableValues.getLength() - TextFilterClient.this.selectedValueSet.size());
            int i = 0;
            while ((long)i < TextFilterClient.this.availableValues.getLength()) {
                String value = TextFilterClient.this.availableValues.get(i);
                if (!TextFilterClient.this.selectedValueSet.contains((Object)value)) {
                    values.add(value);
                }
                ++i;
            }
            ((TextVariableFilter)TextFilterClient.this.filter).removeValues(values);
            TextFilterClient.this.updateInput();
            return null;
        }
    }
}

